/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.   ## Resources - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */

/// SendEmailOptions : Options for sending an email message from an inbox. You must provide one of: `to`, `toGroup`, or `toContacts` to send an email. All other parameters are optional. 



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SendEmailOptions {
    /// Optional list of attachment IDs to send with this email. You must first upload each attachment separately in order to obtain attachment IDs. This way you can reuse attachments with different emails once uploaded.
    #[serde(rename = "attachments", skip_serializing_if = "Option::is_none")]
    pub attachments: Option<Vec<String>>,
    /// Optional list of bcc destination email addresses
    #[serde(rename = "bcc", skip_serializing_if = "Option::is_none")]
    pub bcc: Option<Vec<String>>,
    /// Optional contents of email. If body contains HTML then set `isHTML` to true to ensure that email clients render it correctly. You can use moustache template syntax in the email body in conjunction with `toGroup` contact variables or `templateVariables` data. If you need more templating control consider creating a template and using the `template` property instead of the body.
    #[serde(rename = "body", skip_serializing_if = "Option::is_none")]
    pub body: Option<String>,
    /// Optional list of cc destination email addresses
    #[serde(rename = "cc", skip_serializing_if = "Option::is_none")]
    pub cc: Option<Vec<String>>,
    /// Optional charset
    #[serde(rename = "charset", skip_serializing_if = "Option::is_none")]
    pub charset: Option<String>,
    /// Optional from address. If not set the source inbox address will be used for this field. Beware of potential spam penalties when setting this field to an address not used by the inbox. For custom email addresses use a custom domain.
    #[serde(rename = "from", skip_serializing_if = "Option::is_none")]
    pub from: Option<String>,
    /// Optional HTML flag. If true the `content-type` of the email will be `text/html`. Set to true when sending HTML to ensure proper rending on email clients
    #[serde(rename = "isHTML", skip_serializing_if = "Option::is_none")]
    pub is_html: Option<bool>,
    /// Optional replyTo header
    #[serde(rename = "replyTo", skip_serializing_if = "Option::is_none")]
    pub reply_to: Option<String>,
    /// Optional strategy to use when sending the email
    #[serde(rename = "sendStrategy", skip_serializing_if = "Option::is_none")]
    pub send_strategy: Option<SendStrategy>,
    /// Optional email subject line
    #[serde(rename = "subject", skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    /// Optional template ID to use for body. Will override body if provided. When using a template make sure you pass the corresponding map of `templateVariables`. You can find which variables are needed by fetching the template itself or viewing it in the dashboard.
    #[serde(rename = "template", skip_serializing_if = "Option::is_none")]
    pub template: Option<String>,
    /// Optional map of template variables. Will replace moustache syntax variables in subject and body or template with the associated values if found.
    #[serde(rename = "templateVariables", skip_serializing_if = "Option::is_none")]
    pub template_variables: Option<serde_json::Value>,
    /// List of destination email addresses. Even single recipients must be in array form. Maximum recipients per email depends on your plan. If you need to send many emails try using contacts or contact groups or use a non standard sendStrategy to ensure that spam filters are not triggered (many recipients in one email can affect your spam rating).
    #[serde(rename = "to", skip_serializing_if = "Option::is_none")]
    pub to: Option<Vec<String>>,
    /// Optional list of contact IDs to send email to. Manage your contacts via the API or dashboard. When contacts are used the email is sent to each contact separately so they will not see other recipients.
    #[serde(rename = "toContacts", skip_serializing_if = "Option::is_none")]
    pub to_contacts: Option<Vec<String>>,
    /// Optional contact group ID to send email to. You can create contacts and contact groups in the API or dashboard and use them for email campaigns. When contact groups are used the email is sent to each contact separately so they will not see other recipients
    #[serde(rename = "toGroup", skip_serializing_if = "Option::is_none")]
    pub to_group: Option<String>,
}

impl SendEmailOptions {
    /// Options for sending an email message from an inbox. You must provide one of: `to`, `toGroup`, or `toContacts` to send an email. All other parameters are optional. 
    pub fn new() -> SendEmailOptions {
        SendEmailOptions {
            attachments: None,
            bcc: None,
            body: None,
            cc: None,
            charset: None,
            from: None,
            is_html: None,
            reply_to: None,
            send_strategy: None,
            subject: None,
            template: None,
            template_variables: None,
            to: None,
            to_contacts: None,
            to_group: None,
        }
    }
}

/// Optional strategy to use when sending the email
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum SendStrategy {
    #[serde(rename = "SINGLE_MESSAGE")]
    SINGLEMESSAGE,
}

