pub mod offset {
    pub const AH: usize = 0;
    pub const AL: usize = 1;
    pub const BH: usize = 2;
    pub const BL: usize = 3;
    pub const CH: usize = 4;
    pub const CL: usize = 5;
    pub const DH: usize = 6;
    pub const DL: usize = 7;
    pub const FLAGS: usize = 8;
    pub const AX: usize = AH;
    pub const BX: usize = BH;
    pub const CX: usize = CH;
    pub const DX: usize = DH;
}

pub mod id {
    pub const AH: usize = 0;
    pub const AL: usize = 1;
    pub const BH: usize = 2;
    pub const BL: usize = 3;
    pub const CH: usize = 4;
    pub const CL: usize = 5;
    pub const DH: usize = 6;
    pub const DL: usize = 7;
    pub const FLAGS: usize = 8;
    pub const AX: usize = 9;
    pub const BX: usize = 10;
    pub const CX: usize = 11;
    pub const DX: usize = 12;

    pub const fn size(value: usize) -> usize {
        if matches!(value, AX | BX | CX | DX) {
            2
        } else {
            1
        }
    }

    pub const fn name(value: u8) -> &'static str {
        match value as usize {
            AH => "AH",
            AL => "AL",
            BH => "BH",
            BL => "BL",
            CH => "CH",
            CL => "CL",
            DH => "DH",
            DL => "DL",
            AX => "AX",
            BX => "BX",
            CX => "CX",
            DX => "DX",
            FLAGS => "FLG",
            _ => "?",
        }
    }
}

pub const SIZE: usize = 9;

pub mod flags {
    pub const CARRY: u8 = 0b10000000;
    pub const ZERO: u8 = 0b01000000;
    pub const SIGNED: u8 = 0b00100000;
    pub const OVERFLOW: u8 = 0b00010000;
    pub const LESS_THAN: u8 = 0b00001000;
    pub const GREATER_THAN: u8 = 0b00000100;
    //pub const RESERVED: u8 = 0b00000010;
    pub const INTERRUPTS: u8 = 0b00000001;
}

pub const FLG_DEFAULT: u8 = flags::ZERO + flags::INTERRUPTS;
