pub mod op {
    pub const NOP: &str = "NOP";
    pub const HALT: &str = "HALT";
    pub const CALL_ADDR: &str = "CALL";
    pub const CALL_REG: &str = "CALL";
    pub const RET: &str = "RET";
    pub const RETI: &str = "RETI";
    pub const CPY_REG_REG_BYTE: &str = "CPY.B";
    pub const CPY_REG_REG_WORD: &str = "CPY.W";
    pub const CPY_ADDR_REG_BYTE: &str = "CPY.B";
    pub const CPY_ADDR_REG_WORD: &str = "CPY.W";
    pub const CPY_REG_ADDR_BYTE: &str = "CPY.B";
    pub const CPY_REG_ADDR_WORD: &str = "CPY.W";
    pub const CPY_ADDR_ADDR_BYTE: &str = "CPY.B";
    pub const CPY_ADDR_ADDR_WORD: &str = "CPY.W";
    pub const CPY_REG_NUM_BYTE: &str = "CPY.B";
    pub const CPY_REG_NUM_WORD: &str = "CPY.W";
    pub const CPY_ADDR_NUM_BYTE: &str = "CPY.B";
    pub const CPY_ADDR_NUM_WORD: &str = "CPY.W";
    pub const ADD_REG_REG_BYTE: &str = "ADD.B";
    pub const ADD_REG_REG_WORD: &str = "ADD.W";
    pub const ADD_REG_NUM_BYTE: &str = "ADD.B";
    pub const ADD_REG_NUM_WORD: &str = "ADD.W";
    pub const ADD_REG_ADDR_BYTE: &str = "ADD.B";
    pub const ADD_REG_ADDR_WORD: &str = "ADD.W";
    pub const ADD_ADDR_REG_BYTE: &str = "ADD.B";
    pub const ADD_ADDR_REG_WORD: &str = "ADD.W";
    pub const ADD_ADDR_NUM_BYTE: &str = "ADD.B";
    pub const ADD_ADDR_NUM_WORD: &str = "ADD.W";
    pub const ADD_ADDR_ADDR_BYTE: &str = "ADD.B";
    pub const ADD_ADDR_ADDR_WORD: &str = "ADD.W";
    pub const INC_REG_BYTE: &str = "INC.B";
    pub const INC_REG_WORD: &str = "INC.W";
    pub const INC_ADDR_BYTE: &str = "INC.B";
    pub const INC_ADDR_WORD: &str = "INC.W";
    pub const SUB_REG_REG_BYTE: &str = "SUB.B";
    pub const SUB_REG_REG_WORD: &str = "SUB.W";
    pub const SUB_REG_NUM_BYTE: &str = "SUB.B";
    pub const SUB_REG_NUM_WORD: &str = "SUB.W";
    pub const SUB_REG_ADDR_BYTE: &str = "SUB.B";
    pub const SUB_REG_ADDR_WORD: &str = "SUB.W";
    pub const SUB_ADDR_REG_BYTE: &str = "SUB.B";
    pub const SUB_ADDR_REG_WORD: &str = "SUB.W";
    pub const SUB_ADDR_NUM_BYTE: &str = "SUB.B";
    pub const SUB_ADDR_NUM_WORD: &str = "SUB.W";
    pub const SUB_ADDR_ADDR_BYTE: &str = "SUB.B";
    pub const SUB_ADDR_ADDR_WORD: &str = "SUB.W";
    pub const DEC_REG_BYTE: &str = "DEC.B";
    pub const DEC_REG_WORD: &str = "DEC.W";
    pub const DEC_ADDR_BYTE: &str = "DEC.B";
    pub const DEC_ADDR_WORD: &str = "DEC.W";
    pub const SWAP_REG_REG_BYTE: &str = "SWAP.B";
    pub const SWAP_REG_REG_WORD: &str = "SWAP.W";
    pub const MEM_CPY_ADDR_ADDR_BYTE: &str = "MCPY";
    pub const MEM_CPY_ADDR_REG_BYTE: &str = "MCPY";
    pub const MEM_CPY_REG_ADDR_BYTE: &str = "MCPY";
    pub const MEM_CPY_REG_REG_BYTE: &str = "MCPY";
    pub const MEM_CPY_ADDR_ADDR_REG: &str = "MCPY";
    pub const MEM_CPY_ADDR_REG_REG: &str = "MCPY";
    pub const MEM_CPY_REG_ADDR_REG: &str = "MCPY";
    pub const MEM_CPY_REG_REG_REG: &str = "MCPY";
    pub const NOT_REG_BYTE: &str = "NOT.B";
    pub const NOT_REG_WORD: &str = "NOT.W";
    pub const OR_REG_REG_BYTE: &str = "OR.B";
    pub const OR_REG_REG_WORD: &str = "OR.W";
    pub const OR_REG_NUM_BYTE: &str = "OR.B";
    pub const OR_REG_NUM_WORD: &str = "OR.W";
    pub const XOR_REG_REG_BYTE: &str = "XOR.B";
    pub const XOR_REG_REG_WORD: &str = "XOR.W";
    pub const XOR_REG_NUM_BYTE: &str = "XOR.B";
    pub const XOR_REG_NUM_WORD: &str = "XOR.W";
    pub const AND_REG_REG_BYTE: &str = "AND.B";
    pub const AND_REG_REG_WORD: &str = "AND.W";
    pub const AND_REG_NUM_BYTE: &str = "AND.B";
    pub const AND_REG_NUM_WORD: &str = "AND.W";
    pub const ASL_REG_NUM_BYTE: &str = "ASL.B";
    pub const ASL_REG_REG_BYTE: &str = "ASL.B";
    pub const ASL_REG_NUM_WORD: &str = "ASL.W";
    pub const ASL_REG_REG_WORD: &str = "ASL.W";
    pub const ASL_ADDR_BYTE: &str = "ASL.B";
    pub const ASL_ADDR_WORD: &str = "ASL.W";
    pub const ASR_REG_NUM_BYTE: &str = "ASR.B";
    pub const ASR_REG_REG_BYTE: &str = "ASR.B";
    pub const ASR_REG_NUM_WORD: &str = "ASR.W";
    pub const ASR_REG_REG_WORD: &str = "ASR.W";
    pub const ASR_ADDR_BYTE: &str = "ASR.B";
    pub const ASR_ADDR_WORD: &str = "ASR.W";
    pub const LSR_REG_NUM_BYTE: &str = "LSR.B";
    pub const LSR_REG_REG_BYTE: &str = "LSR.B";
    pub const LSR_REG_NUM_WORD: &str = "LSR.W";
    pub const LSR_REG_REG_WORD: &str = "LSR.W";
    pub const LSR_ADDR_BYTE: &str = "LSR.B";
    pub const LSR_ADDR_WORD: &str = "LSR.W";
    pub const ROL_REG_NUM_BYTE: &str = "ROL.B";
    pub const ROL_REG_REG_BYTE: &str = "ROL.B";
    pub const ROL_REG_NUM_WORD: &str = "ROL.W";
    pub const ROL_REG_REG_WORD: &str = "ROL.W";
    pub const ROL_ADDR_BYTE: &str = "ROL.B";
    pub const ROL_ADDR_WORD: &str = "ROL.W";
    pub const ROR_REG_NUM_BYTE: &str = "ROR.B";
    pub const ROR_REG_REG_BYTE: &str = "ROR.B";
    pub const ROR_REG_NUM_WORD: &str = "ROR.W";
    pub const ROR_REG_REG_WORD: &str = "ROR.W";
    pub const ROR_ADDR_BYTE: &str = "ROR.B";
    pub const ROR_ADDR_WORD: &str = "ROR.W";
    pub const ROXL_REG_NUM_BYTE: &str = "ROXL.B";
    pub const ROXL_REG_REG_BYTE: &str = "ROXL.B";
    pub const ROXL_REG_NUM_WORD: &str = "ROXL.W";
    pub const ROXL_REG_REG_WORD: &str = "ROXL.W";
    pub const ROXL_ADDR_BYTE: &str = "ROXL.B";
    pub const ROXL_ADDR_WORD: &str = "ROXL.W";
    pub const ROXR_REG_NUM_BYTE: &str = "ROXR.B";
    pub const ROXR_REG_REG_BYTE: &str = "ROXR.B";
    pub const ROXR_REG_NUM_WORD: &str = "ROXR.W";
    pub const ROXR_REG_REG_WORD: &str = "ROXR.W";
    pub const ROXR_ADDR_BYTE: &str = "ROXR.B";
    pub const ROXR_ADDR_WORD: &str = "ROXR.W";
    pub const MUL_REG_REG_BYTE: &str = "MUL.B";
    pub const MUL_REG_REG_WORD: &str = "MUL.W";
    pub const MUL_REG_NUM_BYTE: &str = "MUL.B";
    pub const MUL_REG_NUM_WORD: &str = "MUL.W";
    pub const MUL_REG_ADDR_BYTE: &str = "MUL.B";
    pub const MUL_REG_ADDR_WORD: &str = "MUL.W";
    pub const MUL_ADDR_REG_BYTE: &str = "MUL.B";
    pub const MUL_ADDR_REG_WORD: &str = "MUL.W";
    pub const MUL_ADDR_NUM_BYTE: &str = "MUL.B";
    pub const MUL_ADDR_NUM_WORD: &str = "MUL.W";
    pub const MUL_ADDR_ADDR_BYTE: &str = "MUL.B";
    pub const MUL_ADDR_ADDR_WORD: &str = "MUL.W";
    pub const MULS_REG_REG_BYTE: &str = "MULS.B";
    pub const MULS_REG_REG_WORD: &str = "MULS.W";
    pub const MULS_REG_NUM_BYTE: &str = "MULS.B";
    pub const MULS_REG_NUM_WORD: &str = "MULS.W";
    pub const MULS_REG_ADDR_BYTE: &str = "MULS.B";
    pub const MULS_REG_ADDR_WORD: &str = "MULS.W";
    pub const MULS_ADDR_REG_BYTE: &str = "MULS.B";
    pub const MULS_ADDR_REG_WORD: &str = "MULS.W";
    pub const MULS_ADDR_NUM_BYTE: &str = "MULS.B";
    pub const MULS_ADDR_NUM_WORD: &str = "MULS.W";
    pub const MULS_ADDR_ADDR_BYTE: &str = "MULS.B";
    pub const MULS_ADDR_ADDR_WORD: &str = "MULS.W";
    pub const DIV_REG_REG_BYTE: &str = "DIV.B";
    pub const DIV_REG_REG_WORD: &str = "DIV.W";
    pub const DIV_REG_NUM_BYTE: &str = "DIV.B";
    pub const DIV_REG_NUM_WORD: &str = "DIV.W";
    pub const DIV_REG_ADDR_BYTE: &str = "DIV.B";
    pub const DIV_REG_ADDR_WORD: &str = "DIV.W";
    pub const DIV_ADDR_REG_BYTE: &str = "DIV.B";
    pub const DIV_ADDR_REG_WORD: &str = "DIV.W";
    pub const DIV_ADDR_NUM_BYTE: &str = "DIV.B";
    pub const DIV_ADDR_NUM_WORD: &str = "DIV.W";
    pub const DIV_ADDR_ADDR_BYTE: &str = "DIV.B";
    pub const DIV_ADDR_ADDR_WORD: &str = "DIV.W";
    pub const DIVS_REG_REG_BYTE: &str = "DIVS.B";
    pub const DIVS_REG_NUM_BYTE: &str = "DIVS.B";
    pub const DIVS_REG_ADDR_BYTE: &str = "DIVS.B";
    pub const DIVS_ADDR_REG_BYTE: &str = "DIVS.B";
    pub const DIVS_REG_REG_WORD: &str = "DIVS.W";
    pub const DIVS_REG_NUM_WORD: &str = "DIVS.W";
    pub const DIVS_REG_ADDR_WORD: &str = "DIVS.W";
    pub const DIVS_ADDR_REG_WORD: &str = "DIVS.W";
    pub const DIVS_ADDR_NUM_BYTE: &str = "DIVS.B";
    pub const DIVS_ADDR_NUM_WORD: &str = "DIVS.W";
    pub const DIVS_ADDR_ADDR_BYTE: &str = "DIVS.B";
    pub const DIVS_ADDR_ADDR_WORD: &str = "DIVS.W";
    pub const JMP_REG: &str = "JMP.B";
    pub const JMP_ADDR: &str = "JMP.B";
    pub const JL_REG: &str = "JL.B";
    pub const JL_ADDR: &str = "JL.B";
    pub const JLE_REG: &str = "JLE.B";
    pub const JLE_ADDR: &str = "JLE.B";
    pub const JG_REG: &str = "JG.B";
    pub const JG_ADDR: &str = "JG.B";
    pub const JGE_REG: &str = "JGE.B";
    pub const JGE_ADDR: &str = "JGE.B";
    pub const JE_REG: &str = "JE.B";
    pub const JE_ADDR: &str = "JE.B";
    pub const JNE_REG: &str = "JNE.B";
    pub const JNE_ADDR: &str = "JNE.B";
    pub const CMP_REG_NUM_BYTE: &str = "CMP.B";
    pub const CMP_REG_NUM_WORD: &str = "CMP.W";
    pub const CMP_REG_REG_BYTE: &str = "CMP.B";
    pub const CMP_REG_REG_WORD: &str = "CMP.W";
    pub const CMPS_REG_NUM_BYTE: &str = "CMPS.B";
    pub const CMPS_REG_NUM_WORD: &str = "CMPS.W";
    pub const CMPS_REG_REG_BYTE: &str = "CMPS.B";
    pub const CMPS_REG_REG_WORD: &str = "CMPS.W";
    pub const JBS_REG_REG: &str = "JBS";
    pub const JBS_REG_NUM: &str = "JBS";
    pub const JBS_ADDR_REG: &str = "JBS";
    pub const JBS_ADDR_NUM: &str = "JBS";
    pub const JBC_REG_REG: &str = "JBC";
    pub const JBC_REG_NUM: &str = "JBC";
    pub const JBC_ADDR_REG: &str = "JBC";
    pub const JBC_ADDR_NUM: &str = "JBC";
    pub const CMP_REG_ADDR_BYTE: &str = "CMP.B";
    pub const CMP_REG_ADDR_WORD: &str = "CMP.W";
    pub const CMPS_REG_ADDR_BYTE: &str = "CMPS.B";
    pub const CMPS_REG_ADDR_WORD: &str = "CMPS.W";
    pub const JRB_BYTE: &str = "JRB";
    pub const JRF_BYTE: &str = "JRF";
    pub const ADDC_REG_REG_BYTE: &str = "ADDC.B";
    pub const ADDC_REG_REG_WORD: &str = "ADDC.W";
    pub const ADDC_REG_NUM_BYTE: &str = "ADDC.B";
    pub const ADDC_REG_NUM_WORD: &str = "ADDC.W";
    pub const ADDC_REG_ADDR_BYTE: &str = "ADDC.B";
    pub const ADDC_REG_ADDR_WORD: &str = "ADDC.W";
    pub const ADDC_ADDR_REG_BYTE: &str = "ADDC.B";
    pub const ADDC_ADDR_REG_WORD: &str = "ADDC.W";
    pub const ADDC_ADDR_NUM_BYTE: &str = "ADDC.B";
    pub const ADDC_ADDR_NUM_WORD: &str = "ADDC.W";
    pub const ADDC_ADDR_ADDR_BYTE: &str = "ADDC.B";
    pub const ADDC_ADDR_ADDR_WORD: &str = "ADDC.W";
    pub const SUBC_REG_REG_BYTE: &str = "SUBC.B";
    pub const SUBC_REG_REG_WORD: &str = "SUBC.W";
    pub const SUBC_REG_NUM_BYTE: &str = "SUBC.B";
    pub const SUBC_REG_NUM_WORD: &str = "SUBC.W";
    pub const SUBC_REG_ADDR_BYTE: &str = "SUBC.B";
    pub const SUBC_REG_ADDR_WORD: &str = "SUBC.W";
    pub const SUBC_ADDR_REG_BYTE: &str = "SUBC.B";
    pub const SUBC_ADDR_REG_WORD: &str = "SUBC.W";
    pub const SUBC_ADDR_NUM_BYTE: &str = "SUBC.B";
    pub const SUBC_ADDR_NUM_WORD: &str = "SUBC.W";
    pub const SUBC_ADDR_ADDR_BYTE: &str = "SUBC.B";
    pub const SUBC_ADDR_ADDR_WORD: &str = "SUBC.W";
}

pub mod full {
    pub const NOP: &str = "NOP";
    pub const HALT: &str = "HALT";
    pub const CALL_ADDR: &str = "CALL (A)";
    pub const CALL_REG: &str = "CALL (R)";
    pub const RET: &str = "RET";
    pub const RETI: &str = "RETI";
    pub const CPY_REG_REG_BYTE: &str = "CPY.B (R,R)";
    pub const CPY_REG_REG_WORD: &str = "CPY.W (R,R)";
    pub const CPY_ADDR_REG_BYTE: &str = "CPY.B (A,R)";
    pub const CPY_ADDR_REG_WORD: &str = "CPY.W (A,R)";
    pub const CPY_REG_ADDR_BYTE: &str = "CPY.B (R,A)";
    pub const CPY_REG_ADDR_WORD: &str = "CPY.W (R,A)";
    pub const CPY_ADDR_ADDR_BYTE: &str = "CPY.B (A,A)";
    pub const CPY_ADDR_ADDR_WORD: &str = "CPY.W (A,A)";
    pub const CPY_REG_NUM_BYTE: &str = "CPY.B (R,N)";
    pub const CPY_REG_NUM_WORD: &str = "CPY.W (R,N)";
    pub const CPY_ADDR_NUM_BYTE: &str = "CPY.B (A,N)";
    pub const CPY_ADDR_NUM_WORD: &str = "CPY.W (A,N)";
    pub const ADD_REG_REG_BYTE: &str = "ADD.B (R,R)";
    pub const ADD_REG_REG_WORD: &str = "ADD.W (R,R)";
    pub const ADD_REG_NUM_BYTE: &str = "ADD.B (R,N)";
    pub const ADD_REG_NUM_WORD: &str = "ADD.W (R,N)";
    pub const ADD_REG_ADDR_BYTE: &str = "ADD.B (R,A)";
    pub const ADD_REG_ADDR_WORD: &str = "ADD.W (R,A)";
    pub const ADD_ADDR_REG_BYTE: &str = "ADD.B (A,R)";
    pub const ADD_ADDR_REG_WORD: &str = "ADD.W (A,R)";
    pub const ADD_ADDR_NUM_BYTE: &str = "ADD.B (A,N)";
    pub const ADD_ADDR_NUM_WORD: &str = "ADD.W (A,N)";
    pub const ADD_ADDR_ADDR_BYTE: &str = "ADD.B (A,A)";
    pub const ADD_ADDR_ADDR_WORD: &str = "ADD.W (A,A)";
    pub const INC_REG_BYTE: &str = "INC.B (R)";
    pub const INC_REG_WORD: &str = "INC.W (R)";
    pub const INC_ADDR_BYTE: &str = "INC.B (A)";
    pub const INC_ADDR_WORD: &str = "INC.W (A)";
    pub const SUB_REG_REG_BYTE: &str = "SUB.B (R,R)";
    pub const SUB_REG_REG_WORD: &str = "SUB.W (R,R)";
    pub const SUB_REG_NUM_BYTE: &str = "SUB.B (R,N)";
    pub const SUB_REG_NUM_WORD: &str = "SUB.W (R,N)";
    pub const SUB_REG_ADDR_BYTE: &str = "SUB.B (R,A)";
    pub const SUB_REG_ADDR_WORD: &str = "SUB.W (R,A)";
    pub const SUB_ADDR_REG_BYTE: &str = "SUB.B (A,R)";
    pub const SUB_ADDR_REG_WORD: &str = "SUB.W (A,R)";
    pub const SUB_ADDR_NUM_BYTE: &str = "SUB.B (A,N)";
    pub const SUB_ADDR_NUM_WORD: &str = "SUB.W (A,N)";
    pub const SUB_ADDR_ADDR_BYTE: &str = "SUB.B (A,A)";
    pub const SUB_ADDR_ADDR_WORD: &str = "SUB.W (A,A)";
    pub const DEC_REG_BYTE: &str = "DEC.B (R)";
    pub const DEC_REG_WORD: &str = "DEC.W (R)";
    pub const DEC_ADDR_BYTE: &str = "DEC.B (A)";
    pub const DEC_ADDR_WORD: &str = "DEC.W (A)";
    pub const SWAP_REG_REG_BYTE: &str = "SWAP.B (R,R)";
    pub const SWAP_REG_REG_WORD: &str = "SWAP.W (R,R)";
    pub const MEM_CPY_ADDR_ADDR_BYTE: &str = "MCPY (A,A,N)";
    pub const MEM_CPY_ADDR_REG_BYTE: &str = "MCPY (A,R,N)";
    pub const MEM_CPY_REG_ADDR_BYTE: &str = "MCPY (R,A,N)";
    pub const MEM_CPY_REG_REG_BYTE: &str = "MCPY (R,R,N)";
    pub const MEM_CPY_ADDR_ADDR_REG: &str = "MCPY (A,A,R)";
    pub const MEM_CPY_ADDR_REG_REG: &str = "MCPY (A,R,R)";
    pub const MEM_CPY_REG_ADDR_REG: &str = "MCPY (R,A,R)";
    pub const MEM_CPY_REG_REG_REG: &str = "MCPY (R,R,R)";
    pub const NOT_REG_BYTE: &str = "NOT.B (R)";
    pub const NOT_REG_WORD: &str = "NOT.W (R)";
    pub const OR_REG_REG_BYTE: &str = "OR.B (R,R)";
    pub const OR_REG_REG_WORD: &str = "OR.W (R,R)";
    pub const OR_REG_NUM_BYTE: &str = "OR.B (R,N)";
    pub const OR_REG_NUM_WORD: &str = "OR.W (R,N)";
    pub const XOR_REG_REG_BYTE: &str = "XOR.B (R,R)";
    pub const XOR_REG_REG_WORD: &str = "XOR.W (R,R)";
    pub const XOR_REG_NUM_BYTE: &str = "XOR.B (R,N)";
    pub const XOR_REG_NUM_WORD: &str = "XOR.W (R,N)";
    pub const AND_REG_REG_BYTE: &str = "AND.B (R,R)";
    pub const AND_REG_REG_WORD: &str = "AND.W (R,R)";
    pub const AND_REG_NUM_BYTE: &str = "AND.B (R,N)";
    pub const AND_REG_NUM_WORD: &str = "AND.W (R,N)";
    pub const ASL_REG_NUM_BYTE: &str = "ASL.B (R,N)";
    pub const ASL_REG_REG_BYTE: &str = "ASL.B (R,R)";
    pub const ASL_REG_NUM_WORD: &str = "ASL.W (R,N)";
    pub const ASL_REG_REG_WORD: &str = "ASL.W (R,R)";
    pub const ASL_ADDR_BYTE: &str = "ASL.B (A)";
    pub const ASL_ADDR_WORD: &str = "ASL.W (A)";
    pub const ASR_REG_NUM_BYTE: &str = "ASR.B (R,N)";
    pub const ASR_REG_REG_BYTE: &str = "ASR.B (R,R)";
    pub const ASR_REG_NUM_WORD: &str = "ASR.W (R,N)";
    pub const ASR_REG_REG_WORD: &str = "ASR.W (R,R)";
    pub const ASR_ADDR_BYTE: &str = "ASR.B (A)";
    pub const ASR_ADDR_WORD: &str = "ASR.W (A)";
    pub const LSR_REG_NUM_BYTE: &str = "LSR.B (R,N)";
    pub const LSR_REG_REG_BYTE: &str = "LSR.B (R,R)";
    pub const LSR_REG_NUM_WORD: &str = "LSR.W (R,N)";
    pub const LSR_REG_REG_WORD: &str = "LSR.W (R,R)";
    pub const LSR_ADDR_BYTE: &str = "LSR.B (A)";
    pub const LSR_ADDR_WORD: &str = "LSR.W (A)";
    pub const ROL_REG_NUM_BYTE: &str = "ROL.B (R,N)";
    pub const ROL_REG_REG_BYTE: &str = "ROL.B (R,R)";
    pub const ROL_REG_NUM_WORD: &str = "ROL.W (R,N)";
    pub const ROL_REG_REG_WORD: &str = "ROL.W (R,R)";
    pub const ROL_ADDR_BYTE: &str = "ROL.B (A)";
    pub const ROL_ADDR_WORD: &str = "ROL.W (A)";
    pub const ROR_REG_NUM_BYTE: &str = "ROR.B (R,N)";
    pub const ROR_REG_REG_BYTE: &str = "ROR.B (R,R)";
    pub const ROR_REG_NUM_WORD: &str = "ROR.W (R,N)";
    pub const ROR_REG_REG_WORD: &str = "ROR.W (R,R)";
    pub const ROR_ADDR_BYTE: &str = "ROR.B (A)";
    pub const ROR_ADDR_WORD: &str = "ROR.W (A)";
    pub const MUL_REG_REG_BYTE: &str = "MUL.B (R,R)";
    pub const MUL_REG_REG_WORD: &str = "MUL.W (R,R)";
    pub const MUL_REG_NUM_BYTE: &str = "MUL.B (R,N)";
    pub const MUL_REG_NUM_WORD: &str = "MUL.W (R,N)";
    pub const MUL_REG_ADDR_BYTE: &str = "MUL.B (R,A)";
    pub const MUL_REG_ADDR_WORD: &str = "MUL.W (R,A)";
    pub const MUL_ADDR_REG_BYTE: &str = "MUL.B (A,R)";
    pub const MUL_ADDR_REG_WORD: &str = "MUL.W (A,R)";
    pub const MUL_ADDR_NUM_BYTE: &str = "MUL.B (A,N)";
    pub const MUL_ADDR_NUM_WORD: &str = "MUL.W (A,N)";
    pub const MUL_ADDR_ADDR_BYTE: &str = "MUL.B (A,A)";
    pub const MUL_ADDR_ADDR_WORD: &str = "MUL.W (A,A)";
    pub const MULS_REG_REG_BYTE: &str = "MULS.B (R,R)";
    pub const MULS_REG_REG_WORD: &str = "MULS.W (R,R)";
    pub const MULS_REG_NUM_BYTE: &str = "MULS.B (R,N)";
    pub const MULS_REG_NUM_WORD: &str = "MULS.W (R,N)";
    pub const MULS_REG_ADDR_BYTE: &str = "MULS.B (R,A)";
    pub const MULS_REG_ADDR_WORD: &str = "MULS.W (R,A)";
    pub const MULS_ADDR_REG_BYTE: &str = "MULS.B (A,R)";
    pub const MULS_ADDR_REG_WORD: &str = "MULS.W (A,R)";
    pub const MULS_ADDR_NUM_BYTE: &str = "MULS.B (A,N)";
    pub const MULS_ADDR_NUM_WORD: &str = "MULS.W (A,N)";
    pub const MULS_ADDR_ADDR_BYTE: &str = "MULS.B (A,A)";
    pub const MULS_ADDR_ADDR_WORD: &str = "MULS.W (A,A)";
    pub const DIV_REG_REG_BYTE: &str = "DIV.B (R,R)";
    pub const DIV_REG_REG_WORD: &str = "DIV.W (R,R)";
    pub const DIV_REG_NUM_BYTE: &str = "DIV.B (R,N)";
    pub const DIV_REG_NUM_WORD: &str = "DIV.W (R,N)";
    pub const DIV_REG_ADDR_BYTE: &str = "DIV.B (R,A)";
    pub const DIV_REG_ADDR_WORD: &str = "DIV.W (R,A)";
    pub const DIV_ADDR_REG_BYTE: &str = "DIV.B (A,R)";
    pub const DIV_ADDR_REG_WORD: &str = "DIV.W (A,R)";
    pub const DIV_ADDR_NUM_BYTE: &str = "DIV.B (A,N)";
    pub const DIV_ADDR_NUM_WORD: &str = "DIV.W (A,N)";
    pub const DIV_ADDR_ADDR_BYTE: &str = "DIV.B (A,A)";
    pub const DIV_ADDR_ADDR_WORD: &str = "DIV.W (A,A)";
    pub const DIVS_REG_REG_BYTE: &str = "DIVS.B (R,R)";
    pub const DIVS_REG_NUM_BYTE: &str = "DIVS.B (R,N)";
    pub const DIVS_REG_ADDR_BYTE: &str = "DIVS.B (R,A)";
    pub const DIVS_ADDR_REG_BYTE: &str = "DIVS.B (A,R)";
    pub const DIVS_REG_REG_WORD: &str = "DIVS.W (R,R)";
    pub const DIVS_REG_NUM_WORD: &str = "DIVS.W (R,N)";
    pub const DIVS_REG_ADDR_WORD: &str = "DIVS.W (R,A)";
    pub const DIVS_ADDR_REG_WORD: &str = "DIVS.W (A,R)";
    pub const DIVS_ADDR_NUM_BYTE: &str = "DIVS.B (A,N)";
    pub const DIVS_ADDR_NUM_WORD: &str = "DIVS.W (A,N)";
    pub const DIVS_ADDR_ADDR_BYTE: &str = "DIVS.B (A,A)";
    pub const DIVS_ADDR_ADDR_WORD: &str = "DIVS.W (A,A)";
    pub const JMP_REG: &str = "JMP.B (R)";
    pub const JMP_ADDR: &str = "JMP.B (A)";
    pub const JL_REG: &str = "JL.B (R)";
    pub const JL_ADDR: &str = "JL.B (A)";
    pub const JLE_REG: &str = "JLE.B (R)";
    pub const JLE_ADDR: &str = "JLE.B (A)";
    pub const JG_REG: &str = "JG.B (R)";
    pub const JG_ADDR: &str = "JG.B (A)";
    pub const JGE_REG: &str = "JGE.B (R)";
    pub const JGE_ADDR: &str = "JGE.B (A)";
    pub const JE_REG: &str = "JE.B (R)";
    pub const JE_ADDR: &str = "JE.B (A)";
    pub const JNE_REG: &str = "JNE.B (R)";
    pub const JNE_ADDR: &str = "JNE.B (A)";
    pub const CMP_REG_NUM_BYTE: &str = "CMP.B (R,N)";
    pub const CMP_REG_NUM_WORD: &str = "CMP.W (R,N)";
    pub const CMP_REG_REG_BYTE: &str = "CMP.B (R,R)";
    pub const CMP_REG_REG_WORD: &str = "CMP.W (R,R)";
    pub const CMPS_REG_NUM_BYTE: &str = "CMPS.B (R,N)";
    pub const CMPS_REG_NUM_WORD: &str = "CMPS.W (R,N)";
    pub const CMPS_REG_REG_BYTE: &str = "CMPS.B (R,R)";
    pub const CMPS_REG_REG_WORD: &str = "CMPS.W (R,R)";
    pub const JBS_REG_REG: &str = "JBS (R,R)";
    pub const JBS_REG_NUM: &str = "JBS (R,N)";
    pub const JBS_ADDR_REG: &str = "JBS (A,R)";
    pub const JBS_ADDR_NUM: &str = "JBS (A,N)";
    pub const JBC_REG_REG: &str = "JBC (R,R)";
    pub const JBC_REG_NUM: &str = "JBC (R,N)";
    pub const JBC_ADDR_REG: &str = "JBC (A,R)";
    pub const JBC_ADDR_NUM: &str = "JBC (A,N)";
    pub const CMP_REG_ADDR_BYTE: &str = "CMP.B (R,A)";
    pub const CMP_REG_ADDR_WORD: &str = "CMP.W (R,A)";
    pub const CMPS_REG_ADDR_BYTE: &str = "CMPS.B (R,A)";
    pub const CMPS_REG_ADDR_WORD: &str = "CMPS.W (R,A)";
    pub const JRB_BYTE: &str = "JRB (N)";
    pub const JRF_BYTE: &str = "JRF (N)";
    pub const ADDC_REG_REG_BYTE: &str = "ADDC.B (R,R)";
    pub const ADDC_REG_REG_WORD: &str = "ADDC.W (R,R)";
    pub const ADDC_REG_NUM_BYTE: &str = "ADDC.B (R,N)";
    pub const ADDC_REG_NUM_WORD: &str = "ADDC.W (R,N)";
    pub const ADDC_REG_ADDR_BYTE: &str = "ADDC.B (R,A)";
    pub const ADDC_REG_ADDR_WORD: &str = "ADDC.W (R,A)";
    pub const ADDC_ADDR_REG_BYTE: &str = "ADDC.B (A,R)";
    pub const ADDC_ADDR_REG_WORD: &str = "ADDC.W (A,R)";
    pub const ADDC_ADDR_NUM_BYTE: &str = "ADDC.B (A,N)";
    pub const ADDC_ADDR_NUM_WORD: &str = "ADDC.W (A,N)";
    pub const ADDC_ADDR_ADDR_BYTE: &str = "ADDC.B (A,A)";
    pub const ADDC_ADDR_ADDR_WORD: &str = "ADDC.W (A,A)";
    pub const SUBC_REG_REG_BYTE: &str = "SUBC.B (R,R)";
    pub const SUBC_REG_REG_WORD: &str = "SUBC.W (R,R)";
    pub const SUBC_REG_NUM_BYTE: &str = "SUBC.B (R,N)";
    pub const SUBC_REG_NUM_WORD: &str = "SUBC.W (R,N)";
    pub const SUBC_REG_ADDR_BYTE: &str = "SUBC.B (R,A)";
    pub const SUBC_REG_ADDR_WORD: &str = "SUBC.W (R,A)";
    pub const SUBC_ADDR_REG_BYTE: &str = "SUBC.B (A,R)";
    pub const SUBC_ADDR_REG_WORD: &str = "SUBC.W (A,R)";
    pub const SUBC_ADDR_NUM_BYTE: &str = "SUBC.B (A,N)";
    pub const SUBC_ADDR_NUM_WORD: &str = "SUBC.W (A,N)";
    pub const SUBC_ADDR_ADDR_BYTE: &str = "SUBC.B (A,A)";
    pub const SUBC_ADDR_ADDR_WORD: &str = "SUBC.W (A,A)";
}
