pub mod sizes {
    pub const CODE_BANK: u16 = 8192;
    pub const RAM_BANK: u16 = 8192;
    pub const CODE: u16 = CODE_BANK * 2;
    pub const RAM: u16 = RAM_BANK * 2;
    pub const SOUND: u16 = 25;
    //Byte 0 is direction, byte 1 is action
    pub const INPUT: u16 = 2;
    pub const CODE_BANK_ID: u16 = 1;
    pub const RAM_BANK_ID: u16 = 1;
    pub const SAVE_BANK_ID: u16 = 1;
    pub const SAVE_BANK: u16 = 4096;
    pub const SPRITE: u16 = 4;
    //255 sprites, each taking 4 bytes
    //(8b X, 8b Y, 9b tile id, 1b flipV, 1b flipH, 2b palette, 1b src size, 2b order, [1b half alpha, 1b double dst size, 2b rotation])
    pub const SPRITE_TABLE: u16 = 255 * 4;
    //4 layers, each header is made of 3 bytes (8b X, 8b Y, 1b visible, 7b?)
    pub const LAYERS_HEADER: u16 = 3 * 4;
    //4 layers, each made of 1320 (44x30) tiles, each made of 2 bytes (9b tile id, 1b flipV, 1b flipH, 2b palette, 1b half alpha, 2b rotation)
    pub const LAYERS_CONTENT: u16 = 1320 * 2 * 4;
    //4 palettes, each made of 15 colors, each color is 3 bytes
    pub const PALETTE: u16 = 15 * 3;
    pub const PALETTES_TOTAL: u16 = 15 * 3 * 4;
    //25x20 (tiles) 200x160 (pixels) 100x160 (bytes) atlas of palette index (two colour IDs per byte)
    pub const ATLAS: u16 = 100 * 80;
    pub const ATLAS1_BANK_ID: u16 = 1;
    pub const ATLAS2_BANK_ID: u16 = 1;
    pub const STACK: u16 = 863;
    pub const SP: u16 = 2;
    pub const FP: u16 = 2;
    pub const ATLAS_TOTAL: u16 = ATLAS + ATLAS + ATLAS1_BANK_ID + ATLAS2_BANK_ID;
    pub const LAYER_TOTAL: u16 = LAYERS_CONTENT + LAYERS_HEADER;
    pub const GRAPHICS_TOTAL: u16 = LAYER_TOTAL + SPRITE_TABLE + PALETTES_TOTAL + ATLAS_TOTAL;
    pub const SYSTEM_TOTAL: u16 = CODE + RAM + CODE_BANK_ID + RAM_BANK_ID + STACK + SP + FP;
    pub const HARDWARE_TOTAL: u16 = SOUND + INPUT + SAVE_BANK_ID + SAVE_BANK;
    pub const TOTAL: u16 = GRAPHICS_TOTAL + SYSTEM_TOTAL + HARDWARE_TOTAL;
}

pub mod address {
    pub const CODE: u16 = 0x0;
    pub const CODE_BANK: u16 = 0x2000;
    pub const RAM: u16 = 0x4000;
    pub const RAM_BANK: u16 = 0x6000;
    pub const INPUT: u16 = 0x8000;
    pub const SOUND: u16 = 0x8002;
    pub const SAVE_BANK_ID: u16 = 0x801B;
    pub const SAVE_BANK: u16 = 0x801C;
    pub const ATLAS1: u16 = 0x901C;
    pub const ATLAS2: u16 = 0xAF5C;
    pub const PALETTES: u16 = 0xCE9C;
    pub const SPRITE_TABLE: u16 = 0xCF50;
    pub const LAYER_HEADERS: u16 = 0xD34C;
    pub const LAYERS: u16 = 0xD358;
    pub const CODE_BANK_ID: u16 = 0xFC98;
    pub const RAM_BANK_ID: u16 = 0xFC99;
    pub const ATLAS1_BANK_ID: u16 = 0xFC9A;
    pub const ATLAS2_BANK_ID: u16 = 0xFC9B;
    pub const SP: u16 = 0xFC9C;
    pub const FP: u16 = 0xFC9E;
    pub const STACK: u16 = 0xFCA0;

    pub const MAX: u16 = 0xFFFF;
}

pub const TOTAL: usize = 0xFFFF;
