pub mod constants;
pub mod input;
pub mod mem;
pub mod names;
pub mod op_params;
pub mod ops;
pub mod registers;

pub const SAVE_COUNT: usize = 16;
pub const MAIKOR_VER: [u8; 2] = [0, 1];

pub fn op_name(op: u8) -> &'static str {
    match op {
        ops::NOP => names::op::NOP,
        ops::HALT => names::op::HALT,
        ops::CALL_ADDR => names::op::CALL_ADDR,
        ops::CALL_REG => names::op::CALL_REG,
        ops::RET => names::op::RET,
        ops::RETI => names::op::RETI,
        ops::CPY_REG_REG_BYTE => names::op::CPY_REG_REG_BYTE,
        ops::CPY_REG_REG_WORD => names::op::CPY_REG_REG_WORD,
        ops::CPY_ADDR_REG_BYTE => names::op::CPY_ADDR_REG_BYTE,
        ops::CPY_ADDR_REG_WORD => names::op::CPY_ADDR_REG_WORD,
        ops::CPY_REG_ADDR_BYTE => names::op::CPY_REG_ADDR_BYTE,
        ops::CPY_REG_ADDR_WORD => names::op::CPY_REG_ADDR_WORD,
        ops::CPY_ADDR_ADDR_BYTE => names::op::CPY_ADDR_ADDR_BYTE,
        ops::CPY_ADDR_ADDR_WORD => names::op::CPY_ADDR_ADDR_WORD,
        ops::CPY_REG_NUM_BYTE => names::op::CPY_REG_NUM_BYTE,
        ops::CPY_REG_NUM_WORD => names::op::CPY_REG_NUM_WORD,
        ops::CPY_ADDR_NUM_BYTE => names::op::CPY_ADDR_NUM_BYTE,
        ops::CPY_ADDR_NUM_WORD => names::op::CPY_ADDR_NUM_WORD,
        ops::ADD_REG_REG_BYTE => names::op::ADD_REG_REG_BYTE,
        ops::ADD_REG_REG_WORD => names::op::ADD_REG_REG_WORD,
        ops::ADD_REG_NUM_BYTE => names::op::ADD_REG_NUM_BYTE,
        ops::ADD_REG_NUM_WORD => names::op::ADD_REG_NUM_WORD,
        ops::ADD_REG_ADDR_BYTE => names::op::ADD_REG_ADDR_BYTE,
        ops::ADD_REG_ADDR_WORD => names::op::ADD_REG_ADDR_WORD,
        ops::ADD_ADDR_REG_BYTE => names::op::ADD_ADDR_REG_BYTE,
        ops::ADD_ADDR_REG_WORD => names::op::ADD_ADDR_REG_WORD,
        ops::ADD_ADDR_NUM_BYTE => names::op::ADD_ADDR_NUM_BYTE,
        ops::ADD_ADDR_NUM_WORD => names::op::ADD_ADDR_NUM_WORD,
        ops::ADD_ADDR_ADDR_BYTE => names::op::ADD_ADDR_ADDR_BYTE,
        ops::ADD_ADDR_ADDR_WORD => names::op::ADD_ADDR_ADDR_WORD,
        ops::INC_REG_BYTE => names::op::INC_REG_BYTE,
        ops::INC_REG_WORD => names::op::INC_REG_WORD,
        ops::INC_ADDR_BYTE => names::op::INC_ADDR_BYTE,
        ops::INC_ADDR_WORD => names::op::INC_ADDR_WORD,
        ops::SUB_REG_REG_BYTE => names::op::SUB_REG_REG_BYTE,
        ops::SUB_REG_REG_WORD => names::op::SUB_REG_REG_WORD,
        ops::SUB_REG_NUM_BYTE => names::op::SUB_REG_NUM_BYTE,
        ops::SUB_REG_NUM_WORD => names::op::SUB_REG_NUM_WORD,
        ops::SUB_REG_ADDR_BYTE => names::op::SUB_REG_ADDR_BYTE,
        ops::SUB_REG_ADDR_WORD => names::op::SUB_REG_ADDR_WORD,
        ops::SUB_ADDR_REG_BYTE => names::op::SUB_ADDR_REG_BYTE,
        ops::SUB_ADDR_REG_WORD => names::op::SUB_ADDR_REG_WORD,
        ops::SUB_ADDR_NUM_BYTE => names::op::SUB_ADDR_NUM_BYTE,
        ops::SUB_ADDR_NUM_WORD => names::op::SUB_ADDR_NUM_WORD,
        ops::SUB_ADDR_ADDR_BYTE => names::op::SUB_ADDR_ADDR_BYTE,
        ops::SUB_ADDR_ADDR_WORD => names::op::SUB_ADDR_ADDR_WORD,
        ops::DEC_REG_BYTE => names::op::DEC_REG_BYTE,
        ops::DEC_REG_WORD => names::op::DEC_REG_WORD,
        ops::DEC_ADDR_BYTE => names::op::DEC_ADDR_BYTE,
        ops::DEC_ADDR_WORD => names::op::DEC_ADDR_WORD,
        ops::SWAP_REG_REG_BYTE => names::op::SWAP_REG_REG_BYTE,
        ops::SWAP_REG_REG_WORD => names::op::SWAP_REG_REG_WORD,
        ops::MEM_CPY_ADDR_ADDR_BYTE => names::op::MEM_CPY_ADDR_ADDR_BYTE,
        ops::MEM_CPY_ADDR_REG_BYTE => names::op::MEM_CPY_ADDR_REG_BYTE,
        ops::MEM_CPY_REG_ADDR_BYTE => names::op::MEM_CPY_REG_ADDR_BYTE,
        ops::MEM_CPY_REG_REG_BYTE => names::op::MEM_CPY_REG_REG_BYTE,
        ops::MEM_CPY_ADDR_ADDR_REG => names::op::MEM_CPY_ADDR_ADDR_REG,
        ops::MEM_CPY_ADDR_REG_REG => names::op::MEM_CPY_ADDR_REG_REG,
        ops::MEM_CPY_REG_ADDR_REG => names::op::MEM_CPY_REG_ADDR_REG,
        ops::MEM_CPY_REG_REG_REG => names::op::MEM_CPY_REG_REG_REG,
        ops::NOT_REG_BYTE => names::op::NOT_REG_BYTE,
        ops::NOT_REG_WORD => names::op::NOT_REG_WORD,
        ops::OR_REG_REG_BYTE => names::op::OR_REG_REG_BYTE,
        ops::OR_REG_REG_WORD => names::op::OR_REG_REG_WORD,
        ops::OR_REG_NUM_BYTE => names::op::OR_REG_NUM_BYTE,
        ops::OR_REG_NUM_WORD => names::op::OR_REG_NUM_WORD,
        ops::XOR_REG_REG_BYTE => names::op::XOR_REG_REG_BYTE,
        ops::XOR_REG_REG_WORD => names::op::XOR_REG_REG_WORD,
        ops::XOR_REG_NUM_BYTE => names::op::XOR_REG_NUM_BYTE,
        ops::XOR_REG_NUM_WORD => names::op::XOR_REG_NUM_WORD,
        ops::AND_REG_REG_BYTE => names::op::AND_REG_REG_BYTE,
        ops::AND_REG_REG_WORD => names::op::AND_REG_REG_WORD,
        ops::AND_REG_NUM_BYTE => names::op::AND_REG_NUM_BYTE,
        ops::AND_REG_NUM_WORD => names::op::AND_REG_NUM_WORD,
        ops::ASL_REG_NUM_BYTE => names::op::ASL_REG_NUM_BYTE,
        ops::ASL_REG_REG_BYTE => names::op::ASL_REG_REG_BYTE,
        ops::ASL_REG_NUM_WORD => names::op::ASL_REG_NUM_WORD,
        ops::ASL_REG_REG_WORD => names::op::ASL_REG_REG_WORD,
        ops::ASL_ADDR_BYTE => names::op::ASL_ADDR_BYTE,
        ops::ASL_ADDR_WORD => names::op::ASL_ADDR_WORD,
        ops::ASR_REG_NUM_BYTE => names::op::ASR_REG_NUM_BYTE,
        ops::ASR_REG_REG_BYTE => names::op::ASR_REG_REG_BYTE,
        ops::ASR_REG_NUM_WORD => names::op::ASR_REG_NUM_WORD,
        ops::ASR_REG_REG_WORD => names::op::ASR_REG_REG_WORD,
        ops::ASR_ADDR_BYTE => names::op::ASR_ADDR_BYTE,
        ops::ASR_ADDR_WORD => names::op::ASR_ADDR_WORD,
        ops::LSR_REG_NUM_BYTE => names::op::LSR_REG_NUM_BYTE,
        ops::LSR_REG_REG_BYTE => names::op::LSR_REG_REG_BYTE,
        ops::LSR_REG_NUM_WORD => names::op::LSR_REG_NUM_WORD,
        ops::LSR_REG_REG_WORD => names::op::LSR_REG_REG_WORD,
        ops::LSR_ADDR_BYTE => names::op::LSR_ADDR_BYTE,
        ops::LSR_ADDR_WORD => names::op::LSR_ADDR_WORD,
        ops::ROL_REG_NUM_BYTE => names::op::ROL_REG_NUM_BYTE,
        ops::ROL_REG_REG_BYTE => names::op::ROL_REG_REG_BYTE,
        ops::ROL_REG_NUM_WORD => names::op::ROL_REG_NUM_WORD,
        ops::ROL_REG_REG_WORD => names::op::ROL_REG_REG_WORD,
        ops::ROL_ADDR_BYTE => names::op::ROL_ADDR_BYTE,
        ops::ROL_ADDR_WORD => names::op::ROL_ADDR_WORD,
        ops::ROR_REG_NUM_BYTE => names::op::ROR_REG_NUM_BYTE,
        ops::ROR_REG_REG_BYTE => names::op::ROR_REG_REG_BYTE,
        ops::ROR_REG_NUM_WORD => names::op::ROR_REG_NUM_WORD,
        ops::ROR_REG_REG_WORD => names::op::ROR_REG_REG_WORD,
        ops::ROR_ADDR_BYTE => names::op::ROR_ADDR_BYTE,
        ops::ROR_ADDR_WORD => names::op::ROR_ADDR_WORD,
        ops::MUL_REG_REG_BYTE => names::op::MUL_REG_REG_BYTE,
        ops::MUL_REG_REG_WORD => names::op::MUL_REG_REG_WORD,
        ops::MUL_REG_NUM_BYTE => names::op::MUL_REG_NUM_BYTE,
        ops::MUL_REG_NUM_WORD => names::op::MUL_REG_NUM_WORD,
        ops::MUL_REG_ADDR_BYTE => names::op::MUL_REG_ADDR_BYTE,
        ops::MUL_REG_ADDR_WORD => names::op::MUL_REG_ADDR_WORD,
        ops::MUL_ADDR_REG_BYTE => names::op::MUL_ADDR_REG_BYTE,
        ops::MUL_ADDR_REG_WORD => names::op::MUL_ADDR_REG_WORD,
        ops::MUL_ADDR_NUM_BYTE => names::op::MUL_ADDR_NUM_BYTE,
        ops::MUL_ADDR_NUM_WORD => names::op::MUL_ADDR_NUM_WORD,
        ops::MUL_ADDR_ADDR_BYTE => names::op::MUL_ADDR_ADDR_BYTE,
        ops::MUL_ADDR_ADDR_WORD => names::op::MUL_ADDR_ADDR_WORD,
        ops::MULS_REG_REG_BYTE => names::op::MULS_REG_REG_BYTE,
        ops::MULS_REG_REG_WORD => names::op::MULS_REG_REG_WORD,
        ops::MULS_REG_NUM_BYTE => names::op::MULS_REG_NUM_BYTE,
        ops::MULS_REG_NUM_WORD => names::op::MULS_REG_NUM_WORD,
        ops::MULS_REG_ADDR_BYTE => names::op::MULS_REG_ADDR_BYTE,
        ops::MULS_REG_ADDR_WORD => names::op::MULS_REG_ADDR_WORD,
        ops::MULS_ADDR_REG_BYTE => names::op::MULS_ADDR_REG_BYTE,
        ops::MULS_ADDR_REG_WORD => names::op::MULS_ADDR_REG_WORD,
        ops::MULS_ADDR_NUM_BYTE => names::op::MULS_ADDR_NUM_BYTE,
        ops::MULS_ADDR_NUM_WORD => names::op::MULS_ADDR_NUM_WORD,
        ops::MULS_ADDR_ADDR_BYTE => names::op::MULS_ADDR_ADDR_BYTE,
        ops::MULS_ADDR_ADDR_WORD => names::op::MULS_ADDR_ADDR_WORD,
        ops::DIV_REG_REG_BYTE => names::op::DIV_REG_REG_BYTE,
        ops::DIV_REG_REG_WORD => names::op::DIV_REG_REG_WORD,
        ops::DIV_REG_NUM_BYTE => names::op::DIV_REG_NUM_BYTE,
        ops::DIV_REG_NUM_WORD => names::op::DIV_REG_NUM_WORD,
        ops::DIV_REG_ADDR_BYTE => names::op::DIV_REG_ADDR_BYTE,
        ops::DIV_REG_ADDR_WORD => names::op::DIV_REG_ADDR_WORD,
        ops::DIV_ADDR_REG_BYTE => names::op::DIV_ADDR_REG_BYTE,
        ops::DIV_ADDR_REG_WORD => names::op::DIV_ADDR_REG_WORD,
        ops::DIV_ADDR_NUM_BYTE => names::op::DIV_ADDR_NUM_BYTE,
        ops::DIV_ADDR_NUM_WORD => names::op::DIV_ADDR_NUM_WORD,
        ops::DIV_ADDR_ADDR_BYTE => names::op::DIV_ADDR_ADDR_BYTE,
        ops::DIV_ADDR_ADDR_WORD => names::op::DIV_ADDR_ADDR_WORD,
        ops::DIVS_REG_REG_BYTE => names::op::DIVS_REG_REG_BYTE,
        ops::DIVS_REG_NUM_BYTE => names::op::DIVS_REG_NUM_BYTE,
        ops::DIVS_REG_ADDR_BYTE => names::op::DIVS_REG_ADDR_BYTE,
        ops::DIVS_ADDR_REG_BYTE => names::op::DIVS_ADDR_REG_BYTE,
        ops::DIVS_REG_REG_WORD => names::op::DIVS_REG_REG_WORD,
        ops::DIVS_REG_NUM_WORD => names::op::DIVS_REG_NUM_WORD,
        ops::DIVS_REG_ADDR_WORD => names::op::DIVS_REG_ADDR_WORD,
        ops::DIVS_ADDR_REG_WORD => names::op::DIVS_ADDR_REG_WORD,
        ops::DIVS_ADDR_NUM_BYTE => names::op::DIVS_ADDR_NUM_BYTE,
        ops::DIVS_ADDR_NUM_WORD => names::op::DIVS_ADDR_NUM_WORD,
        ops::DIVS_ADDR_ADDR_BYTE => names::op::DIVS_ADDR_ADDR_BYTE,
        ops::DIVS_ADDR_ADDR_WORD => names::op::DIVS_ADDR_ADDR_WORD,
        ops::JMP_REG => names::op::JMP_REG,
        ops::JMP_ADDR => names::op::JMP_ADDR,
        ops::JL_REG => names::op::JL_REG,
        ops::JL_ADDR => names::op::JL_ADDR,
        ops::JLE_REG => names::op::JLE_REG,
        ops::JLE_ADDR => names::op::JLE_ADDR,
        ops::JG_REG => names::op::JG_REG,
        ops::JG_ADDR => names::op::JG_ADDR,
        ops::JGE_REG => names::op::JGE_REG,
        ops::JGE_ADDR => names::op::JGE_ADDR,
        ops::JE_REG => names::op::JE_REG,
        ops::JE_ADDR => names::op::JE_ADDR,
        ops::JNE_REG => names::op::JNE_REG,
        ops::JNE_ADDR => names::op::JNE_ADDR,
        ops::CMP_REG_NUM_BYTE => names::op::CMP_REG_NUM_BYTE,
        ops::CMP_REG_NUM_WORD => names::op::CMP_REG_NUM_WORD,
        ops::CMP_REG_REG_BYTE => names::op::CMP_REG_REG_BYTE,
        ops::CMP_REG_REG_WORD => names::op::CMP_REG_REG_WORD,
        ops::CMPS_REG_NUM_BYTE => names::op::CMPS_REG_NUM_BYTE,
        ops::CMPS_REG_NUM_WORD => names::op::CMPS_REG_NUM_WORD,
        ops::CMPS_REG_REG_BYTE => names::op::CMPS_REG_REG_BYTE,
        ops::CMPS_REG_REG_WORD => names::op::CMPS_REG_REG_WORD,
        ops::JBS_REG_REG => names::op::JBS_REG_REG,
        ops::JBS_REG_NUM => names::op::JBS_REG_NUM,
        ops::JBS_ADDR_REG => names::op::JBS_ADDR_REG,
        ops::JBS_ADDR_NUM => names::op::JBS_ADDR_NUM,
        ops::JBC_REG_REG => names::op::JBC_REG_REG,
        ops::JBC_REG_NUM => names::op::JBC_REG_NUM,
        ops::JBC_ADDR_REG => names::op::JBC_ADDR_REG,
        ops::JBC_ADDR_NUM => names::op::JBC_ADDR_NUM,
        ops::CMP_REG_ADDR_BYTE => names::op::CMP_REG_ADDR_BYTE,
        ops::CMP_REG_ADDR_WORD => names::op::CMP_REG_ADDR_WORD,
        ops::CMPS_REG_ADDR_BYTE => names::op::CMPS_REG_ADDR_BYTE,
        ops::CMPS_REG_ADDR_WORD => names::op::CMPS_REG_ADDR_WORD,
        ops::JRF_BYTE => names::op::JRF_BYTE,
        ops::JRB_BYTE => names::op::JRB_BYTE,
        _ => panic!("Unknown: {:02X}", op),
    }
}

pub fn op_desc(op: u8) -> &'static str {
    match op {
        ops::NOP => names::full::NOP,
        ops::HALT => names::full::HALT,
        ops::CALL_ADDR => names::full::CALL_ADDR,
        ops::CALL_REG => names::full::CALL_REG,
        ops::RET => names::full::RET,
        ops::RETI => names::full::RETI,
        ops::CPY_REG_REG_BYTE => names::full::CPY_REG_REG_BYTE,
        ops::CPY_REG_REG_WORD => names::full::CPY_REG_REG_WORD,
        ops::CPY_ADDR_REG_BYTE => names::full::CPY_ADDR_REG_BYTE,
        ops::CPY_ADDR_REG_WORD => names::full::CPY_ADDR_REG_WORD,
        ops::CPY_REG_ADDR_BYTE => names::full::CPY_REG_ADDR_BYTE,
        ops::CPY_REG_ADDR_WORD => names::full::CPY_REG_ADDR_WORD,
        ops::CPY_ADDR_ADDR_BYTE => names::full::CPY_ADDR_ADDR_BYTE,
        ops::CPY_ADDR_ADDR_WORD => names::full::CPY_ADDR_ADDR_WORD,
        ops::CPY_REG_NUM_BYTE => names::full::CPY_REG_NUM_BYTE,
        ops::CPY_REG_NUM_WORD => names::full::CPY_REG_NUM_WORD,
        ops::CPY_ADDR_NUM_BYTE => names::full::CPY_ADDR_NUM_BYTE,
        ops::CPY_ADDR_NUM_WORD => names::full::CPY_ADDR_NUM_WORD,
        ops::ADD_REG_REG_BYTE => names::full::ADD_REG_REG_BYTE,
        ops::ADD_REG_REG_WORD => names::full::ADD_REG_REG_WORD,
        ops::ADD_REG_NUM_BYTE => names::full::ADD_REG_NUM_BYTE,
        ops::ADD_REG_NUM_WORD => names::full::ADD_REG_NUM_WORD,
        ops::ADD_REG_ADDR_BYTE => names::full::ADD_REG_ADDR_BYTE,
        ops::ADD_REG_ADDR_WORD => names::full::ADD_REG_ADDR_WORD,
        ops::ADD_ADDR_REG_BYTE => names::full::ADD_ADDR_REG_BYTE,
        ops::ADD_ADDR_REG_WORD => names::full::ADD_ADDR_REG_WORD,
        ops::ADD_ADDR_NUM_BYTE => names::full::ADD_ADDR_NUM_BYTE,
        ops::ADD_ADDR_NUM_WORD => names::full::ADD_ADDR_NUM_WORD,
        ops::ADD_ADDR_ADDR_BYTE => names::full::ADD_ADDR_ADDR_BYTE,
        ops::ADD_ADDR_ADDR_WORD => names::full::ADD_ADDR_ADDR_WORD,
        ops::INC_REG_BYTE => names::full::INC_REG_BYTE,
        ops::INC_REG_WORD => names::full::INC_REG_WORD,
        ops::INC_ADDR_BYTE => names::full::INC_ADDR_BYTE,
        ops::INC_ADDR_WORD => names::full::INC_ADDR_WORD,
        ops::SUB_REG_REG_BYTE => names::full::SUB_REG_REG_BYTE,
        ops::SUB_REG_REG_WORD => names::full::SUB_REG_REG_WORD,
        ops::SUB_REG_NUM_BYTE => names::full::SUB_REG_NUM_BYTE,
        ops::SUB_REG_NUM_WORD => names::full::SUB_REG_NUM_WORD,
        ops::SUB_REG_ADDR_BYTE => names::full::SUB_REG_ADDR_BYTE,
        ops::SUB_REG_ADDR_WORD => names::full::SUB_REG_ADDR_WORD,
        ops::SUB_ADDR_REG_BYTE => names::full::SUB_ADDR_REG_BYTE,
        ops::SUB_ADDR_REG_WORD => names::full::SUB_ADDR_REG_WORD,
        ops::SUB_ADDR_NUM_BYTE => names::full::SUB_ADDR_NUM_BYTE,
        ops::SUB_ADDR_NUM_WORD => names::full::SUB_ADDR_NUM_WORD,
        ops::SUB_ADDR_ADDR_BYTE => names::full::SUB_ADDR_ADDR_BYTE,
        ops::SUB_ADDR_ADDR_WORD => names::full::SUB_ADDR_ADDR_WORD,
        ops::DEC_REG_BYTE => names::full::DEC_REG_BYTE,
        ops::DEC_REG_WORD => names::full::DEC_REG_WORD,
        ops::DEC_ADDR_BYTE => names::full::DEC_ADDR_BYTE,
        ops::DEC_ADDR_WORD => names::full::DEC_ADDR_WORD,
        ops::SWAP_REG_REG_BYTE => names::full::SWAP_REG_REG_BYTE,
        ops::SWAP_REG_REG_WORD => names::full::SWAP_REG_REG_WORD,
        ops::MEM_CPY_ADDR_ADDR_BYTE => names::full::MEM_CPY_ADDR_ADDR_BYTE,
        ops::MEM_CPY_ADDR_REG_BYTE => names::full::MEM_CPY_ADDR_REG_BYTE,
        ops::MEM_CPY_REG_ADDR_BYTE => names::full::MEM_CPY_REG_ADDR_BYTE,
        ops::MEM_CPY_REG_REG_BYTE => names::full::MEM_CPY_REG_REG_BYTE,
        ops::MEM_CPY_ADDR_ADDR_REG => names::full::MEM_CPY_ADDR_ADDR_REG,
        ops::MEM_CPY_ADDR_REG_REG => names::full::MEM_CPY_ADDR_REG_REG,
        ops::MEM_CPY_REG_ADDR_REG => names::full::MEM_CPY_REG_ADDR_REG,
        ops::MEM_CPY_REG_REG_REG => names::full::MEM_CPY_REG_REG_REG,
        ops::NOT_REG_BYTE => names::full::NOT_REG_BYTE,
        ops::NOT_REG_WORD => names::full::NOT_REG_WORD,
        ops::OR_REG_REG_BYTE => names::full::OR_REG_REG_BYTE,
        ops::OR_REG_REG_WORD => names::full::OR_REG_REG_WORD,
        ops::OR_REG_NUM_BYTE => names::full::OR_REG_NUM_BYTE,
        ops::OR_REG_NUM_WORD => names::full::OR_REG_NUM_WORD,
        ops::XOR_REG_REG_BYTE => names::full::XOR_REG_REG_BYTE,
        ops::XOR_REG_REG_WORD => names::full::XOR_REG_REG_WORD,
        ops::XOR_REG_NUM_BYTE => names::full::XOR_REG_NUM_BYTE,
        ops::XOR_REG_NUM_WORD => names::full::XOR_REG_NUM_WORD,
        ops::AND_REG_REG_BYTE => names::full::AND_REG_REG_BYTE,
        ops::AND_REG_REG_WORD => names::full::AND_REG_REG_WORD,
        ops::AND_REG_NUM_BYTE => names::full::AND_REG_NUM_BYTE,
        ops::AND_REG_NUM_WORD => names::full::AND_REG_NUM_WORD,
        ops::ASL_REG_NUM_BYTE => names::full::ASL_REG_NUM_BYTE,
        ops::ASL_REG_REG_BYTE => names::full::ASL_REG_REG_BYTE,
        ops::ASL_REG_NUM_WORD => names::full::ASL_REG_NUM_WORD,
        ops::ASL_REG_REG_WORD => names::full::ASL_REG_REG_WORD,
        ops::ASL_ADDR_BYTE => names::full::ASL_ADDR_BYTE,
        ops::ASL_ADDR_WORD => names::full::ASL_ADDR_WORD,
        ops::ASR_REG_NUM_BYTE => names::full::ASR_REG_NUM_BYTE,
        ops::ASR_REG_REG_BYTE => names::full::ASR_REG_REG_BYTE,
        ops::ASR_REG_NUM_WORD => names::full::ASR_REG_NUM_WORD,
        ops::ASR_REG_REG_WORD => names::full::ASR_REG_REG_WORD,
        ops::ASR_ADDR_BYTE => names::full::ASR_ADDR_BYTE,
        ops::ASR_ADDR_WORD => names::full::ASR_ADDR_WORD,
        ops::LSR_REG_NUM_BYTE => names::full::LSR_REG_NUM_BYTE,
        ops::LSR_REG_REG_BYTE => names::full::LSR_REG_REG_BYTE,
        ops::LSR_REG_NUM_WORD => names::full::LSR_REG_NUM_WORD,
        ops::LSR_REG_REG_WORD => names::full::LSR_REG_REG_WORD,
        ops::LSR_ADDR_BYTE => names::full::LSR_ADDR_BYTE,
        ops::LSR_ADDR_WORD => names::full::LSR_ADDR_WORD,
        ops::ROL_REG_NUM_BYTE => names::full::ROL_REG_NUM_BYTE,
        ops::ROL_REG_REG_BYTE => names::full::ROL_REG_REG_BYTE,
        ops::ROL_REG_NUM_WORD => names::full::ROL_REG_NUM_WORD,
        ops::ROL_REG_REG_WORD => names::full::ROL_REG_REG_WORD,
        ops::ROL_ADDR_BYTE => names::full::ROL_ADDR_BYTE,
        ops::ROL_ADDR_WORD => names::full::ROL_ADDR_WORD,
        ops::ROR_REG_NUM_BYTE => names::full::ROR_REG_NUM_BYTE,
        ops::ROR_REG_REG_BYTE => names::full::ROR_REG_REG_BYTE,
        ops::ROR_REG_NUM_WORD => names::full::ROR_REG_NUM_WORD,
        ops::ROR_REG_REG_WORD => names::full::ROR_REG_REG_WORD,
        ops::ROR_ADDR_BYTE => names::full::ROR_ADDR_BYTE,
        ops::ROR_ADDR_WORD => names::full::ROR_ADDR_WORD,
        ops::MUL_REG_REG_BYTE => names::full::MUL_REG_REG_BYTE,
        ops::MUL_REG_REG_WORD => names::full::MUL_REG_REG_WORD,
        ops::MUL_REG_NUM_BYTE => names::full::MUL_REG_NUM_BYTE,
        ops::MUL_REG_NUM_WORD => names::full::MUL_REG_NUM_WORD,
        ops::MUL_REG_ADDR_BYTE => names::full::MUL_REG_ADDR_BYTE,
        ops::MUL_REG_ADDR_WORD => names::full::MUL_REG_ADDR_WORD,
        ops::MUL_ADDR_REG_BYTE => names::full::MUL_ADDR_REG_BYTE,
        ops::MUL_ADDR_REG_WORD => names::full::MUL_ADDR_REG_WORD,
        ops::MUL_ADDR_NUM_BYTE => names::full::MUL_ADDR_NUM_BYTE,
        ops::MUL_ADDR_NUM_WORD => names::full::MUL_ADDR_NUM_WORD,
        ops::MUL_ADDR_ADDR_BYTE => names::full::MUL_ADDR_ADDR_BYTE,
        ops::MUL_ADDR_ADDR_WORD => names::full::MUL_ADDR_ADDR_WORD,
        ops::MULS_REG_REG_BYTE => names::full::MULS_REG_REG_BYTE,
        ops::MULS_REG_REG_WORD => names::full::MULS_REG_REG_WORD,
        ops::MULS_REG_NUM_BYTE => names::full::MULS_REG_NUM_BYTE,
        ops::MULS_REG_NUM_WORD => names::full::MULS_REG_NUM_WORD,
        ops::MULS_REG_ADDR_BYTE => names::full::MULS_REG_ADDR_BYTE,
        ops::MULS_REG_ADDR_WORD => names::full::MULS_REG_ADDR_WORD,
        ops::MULS_ADDR_REG_BYTE => names::full::MULS_ADDR_REG_BYTE,
        ops::MULS_ADDR_REG_WORD => names::full::MULS_ADDR_REG_WORD,
        ops::MULS_ADDR_NUM_BYTE => names::full::MULS_ADDR_NUM_BYTE,
        ops::MULS_ADDR_NUM_WORD => names::full::MULS_ADDR_NUM_WORD,
        ops::MULS_ADDR_ADDR_BYTE => names::full::MULS_ADDR_ADDR_BYTE,
        ops::MULS_ADDR_ADDR_WORD => names::full::MULS_ADDR_ADDR_WORD,
        ops::DIV_REG_REG_BYTE => names::full::DIV_REG_REG_BYTE,
        ops::DIV_REG_REG_WORD => names::full::DIV_REG_REG_WORD,
        ops::DIV_REG_NUM_BYTE => names::full::DIV_REG_NUM_BYTE,
        ops::DIV_REG_NUM_WORD => names::full::DIV_REG_NUM_WORD,
        ops::DIV_REG_ADDR_BYTE => names::full::DIV_REG_ADDR_BYTE,
        ops::DIV_REG_ADDR_WORD => names::full::DIV_REG_ADDR_WORD,
        ops::DIV_ADDR_REG_BYTE => names::full::DIV_ADDR_REG_BYTE,
        ops::DIV_ADDR_REG_WORD => names::full::DIV_ADDR_REG_WORD,
        ops::DIV_ADDR_NUM_BYTE => names::full::DIV_ADDR_NUM_BYTE,
        ops::DIV_ADDR_NUM_WORD => names::full::DIV_ADDR_NUM_WORD,
        ops::DIV_ADDR_ADDR_BYTE => names::full::DIV_ADDR_ADDR_BYTE,
        ops::DIV_ADDR_ADDR_WORD => names::full::DIV_ADDR_ADDR_WORD,
        ops::DIVS_REG_REG_BYTE => names::full::DIVS_REG_REG_BYTE,
        ops::DIVS_REG_NUM_BYTE => names::full::DIVS_REG_NUM_BYTE,
        ops::DIVS_REG_ADDR_BYTE => names::full::DIVS_REG_ADDR_BYTE,
        ops::DIVS_ADDR_REG_BYTE => names::full::DIVS_ADDR_REG_BYTE,
        ops::DIVS_REG_REG_WORD => names::full::DIVS_REG_REG_WORD,
        ops::DIVS_REG_NUM_WORD => names::full::DIVS_REG_NUM_WORD,
        ops::DIVS_REG_ADDR_WORD => names::full::DIVS_REG_ADDR_WORD,
        ops::DIVS_ADDR_REG_WORD => names::full::DIVS_ADDR_REG_WORD,
        ops::DIVS_ADDR_NUM_BYTE => names::full::DIVS_ADDR_NUM_BYTE,
        ops::DIVS_ADDR_NUM_WORD => names::full::DIVS_ADDR_NUM_WORD,
        ops::DIVS_ADDR_ADDR_BYTE => names::full::DIVS_ADDR_ADDR_BYTE,
        ops::DIVS_ADDR_ADDR_WORD => names::full::DIVS_ADDR_ADDR_WORD,
        ops::JMP_REG => names::full::JMP_REG,
        ops::JMP_ADDR => names::full::JMP_ADDR,
        ops::JL_REG => names::full::JL_REG,
        ops::JL_ADDR => names::full::JL_ADDR,
        ops::JLE_REG => names::full::JLE_REG,
        ops::JLE_ADDR => names::full::JLE_ADDR,
        ops::JG_REG => names::full::JG_REG,
        ops::JG_ADDR => names::full::JG_ADDR,
        ops::JGE_REG => names::full::JGE_REG,
        ops::JGE_ADDR => names::full::JGE_ADDR,
        ops::JE_REG => names::full::JE_REG,
        ops::JE_ADDR => names::full::JE_ADDR,
        ops::JNE_REG => names::full::JNE_REG,
        ops::JNE_ADDR => names::full::JNE_ADDR,
        ops::CMP_REG_NUM_BYTE => names::full::CMP_REG_NUM_BYTE,
        ops::CMP_REG_NUM_WORD => names::full::CMP_REG_NUM_WORD,
        ops::CMP_REG_REG_BYTE => names::full::CMP_REG_REG_BYTE,
        ops::CMP_REG_REG_WORD => names::full::CMP_REG_REG_WORD,
        ops::CMPS_REG_NUM_BYTE => names::full::CMPS_REG_NUM_BYTE,
        ops::CMPS_REG_NUM_WORD => names::full::CMPS_REG_NUM_WORD,
        ops::CMPS_REG_REG_BYTE => names::full::CMPS_REG_REG_BYTE,
        ops::CMPS_REG_REG_WORD => names::full::CMPS_REG_REG_WORD,
        ops::JBS_REG_REG => names::full::JBS_REG_REG,
        ops::JBS_REG_NUM => names::full::JBS_REG_NUM,
        ops::JBS_ADDR_REG => names::full::JBS_ADDR_REG,
        ops::JBS_ADDR_NUM => names::full::JBS_ADDR_NUM,
        ops::JBC_REG_REG => names::full::JBC_REG_REG,
        ops::JBC_REG_NUM => names::full::JBC_REG_NUM,
        ops::JBC_ADDR_REG => names::full::JBC_ADDR_REG,
        ops::JBC_ADDR_NUM => names::full::JBC_ADDR_NUM,
        ops::CMP_REG_ADDR_BYTE => names::full::CMP_REG_ADDR_BYTE,
        ops::CMP_REG_ADDR_WORD => names::full::CMP_REG_ADDR_WORD,
        ops::CMPS_REG_ADDR_BYTE => names::full::CMPS_REG_ADDR_BYTE,
        ops::CMPS_REG_ADDR_WORD => names::full::CMPS_REG_ADDR_WORD,
        ops::JRF_BYTE => names::full::JRF_BYTE,
        ops::JRB_BYTE => names::full::JRB_BYTE,
        _ => panic!("Unknown: {:02X}", op),
    }
}

#[cfg(test)]
mod test {
    use crate::ops::ALL;
    use crate::{op_desc, op_name};

    #[test]
    fn check_have_names() {
        for op in ALL {
            assert!(!op_name(op).is_empty(), "{:02X}", op);
            assert!(!op_desc(op).is_empty(), "{:02X}", op);
            assert!(op_desc(op).starts_with(op_name(op)), "{:02X}", op);
        }
    }
}
