/* automatically generated by rust-bindgen 0.59.2 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub type va_list = __builtin_va_list;
pub type size_t = ::std::os::raw::c_ulonglong;
pub type ssize_t = ::std::os::raw::c_longlong;
pub type wchar_t = ::std::os::raw::c_ushort;
pub type __time64_t = ::std::os::raw::c_longlong;
pub type time_t = __time64_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _iobuf {
    pub _ptr: *mut ::std::os::raw::c_char,
    pub _cnt: ::std::os::raw::c_int,
    pub _base: *mut ::std::os::raw::c_char,
    pub _flag: ::std::os::raw::c_int,
    pub _file: ::std::os::raw::c_int,
    pub _charbuf: ::std::os::raw::c_int,
    pub _bufsiz: ::std::os::raw::c_int,
    pub _tmpfname: *mut ::std::os::raw::c_char,
}
pub type FILE = _iobuf;
pub type _dev_t = ::std::os::raw::c_uint;
pub type _pid_t = ::std::os::raw::c_longlong;
pub type pid_t = _pid_t;
pub type _mode_t = ::std::os::raw::c_ushort;
pub type mode_t = _mode_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: time_t,
    pub tv_nsec: ::std::os::raw::c_long,
}
extern "C" {
    pub fn ruby_xmalloc(size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn ruby_xmalloc2(nelems: size_t, elemsiz: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn ruby_xcalloc(nelems: size_t, elemsiz: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn ruby_xrealloc(
        ptr: *mut ::std::os::raw::c_void,
        newsiz: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn ruby_xrealloc2(
        ptr: *mut ::std::os::raw::c_void,
        newelems: size_t,
        newsiz: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn ruby_xfree(ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn rb_assert_failure(
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        name: *const ::std::os::raw::c_char,
        expr: *const ::std::os::raw::c_char,
    );
}
pub type ULONG = ::std::os::raw::c_ulong;
pub type USHORT = ::std::os::raw::c_ushort;
pub type UCHAR = ::std::os::raw::c_uchar;
pub type WINBOOL = ::std::os::raw::c_int;
pub type BYTE = ::std::os::raw::c_uchar;
pub type WORD = ::std::os::raw::c_ushort;
pub type DWORD = ::std::os::raw::c_ulong;
pub type LPDWORD = *mut DWORD;
pub type LPVOID = *mut ::std::os::raw::c_void;
pub type UINT = ::std::os::raw::c_uint;
pub type UINT_PTR = ::std::os::raw::c_ulonglong;
pub type LONG_PTR = ::std::os::raw::c_longlong;
pub type ULONG_PTR = ::std::os::raw::c_ulonglong;
pub type SIZE_T = ULONG_PTR;
pub type DWORD_PTR = ULONG_PTR;
pub type ULONG64 = ::std::os::raw::c_ulonglong;
pub type PVOID = *mut ::std::os::raw::c_void;
pub type CHAR = ::std::os::raw::c_char;
pub type LONG = ::std::os::raw::c_long;
pub type WCHAR = wchar_t;
pub type PWCHAR = *mut WCHAR;
pub type LPWSTR = *mut WCHAR;
pub type PWSTR = *mut WCHAR;
pub type LPCWSTR = *const WCHAR;
pub type PCHAR = *mut CHAR;
pub type LPSTR = *mut CHAR;
pub type LPCSTR = *const CHAR;
pub type PCSTR = *const CHAR;
pub type HANDLE = *mut ::std::os::raw::c_void;
pub type LONGLONG = ::std::os::raw::c_longlong;
pub type ULONGLONG = ::std::os::raw::c_ulonglong;
pub type USN = LONGLONG;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _LARGE_INTEGER {
    pub __bindgen_anon_1: _LARGE_INTEGER__bindgen_ty_1,
    pub u: _LARGE_INTEGER__bindgen_ty_2,
    pub QuadPart: LONGLONG,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _LARGE_INTEGER__bindgen_ty_1 {
    pub LowPart: DWORD,
    pub HighPart: LONG,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _LARGE_INTEGER__bindgen_ty_2 {
    pub LowPart: DWORD,
    pub HighPart: LONG,
}
pub type LARGE_INTEGER = _LARGE_INTEGER;
pub type DWORDLONG = ULONGLONG;
pub type BOOLEAN = BYTE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _LIST_ENTRY {
    pub Flink: *mut _LIST_ENTRY,
    pub Blink: *mut _LIST_ENTRY,
}
pub type LIST_ENTRY = _LIST_ENTRY;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GUID {
    pub Data1: ::std::os::raw::c_ulong,
    pub Data2: ::std::os::raw::c_ushort,
    pub Data3: ::std::os::raw::c_ushort,
    pub Data4: [::std::os::raw::c_uchar; 8usize],
}
pub type GUID = _GUID;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RUNTIME_FUNCTION {
    pub BeginAddress: DWORD,
    pub EndAddress: DWORD,
    pub UnwindData: DWORD,
}
pub type RUNTIME_FUNCTION = _RUNTIME_FUNCTION;
pub type ACCESS_MASK = DWORD;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _RATE_QUOTA_LIMIT {
    pub RateData: DWORD,
    pub __bindgen_anon_1: _RATE_QUOTA_LIMIT__bindgen_ty_1,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _RATE_QUOTA_LIMIT__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl _RATE_QUOTA_LIMIT__bindgen_ty_1 {
    #[inline]
    pub fn RatePercent(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_RatePercent(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn Reserved0(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 25u8) as u32) }
    }
    #[inline]
    pub fn set_Reserved0(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 25u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        RatePercent: DWORD,
        Reserved0: DWORD,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 7u8, {
            let RatePercent: u32 = unsafe { ::std::mem::transmute(RatePercent) };
            RatePercent as u64
        });
        __bindgen_bitfield_unit.set(7usize, 25u8, {
            let Reserved0: u32 = unsafe { ::std::mem::transmute(Reserved0) };
            Reserved0 as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type RATE_QUOTA_LIMIT = _RATE_QUOTA_LIMIT;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _REPARSE_GUID_DATA_BUFFER {
    pub ReparseTag: DWORD,
    pub ReparseDataLength: WORD,
    pub Reserved: WORD,
    pub ReparseGuid: GUID,
    pub GenericReparseBuffer: _REPARSE_GUID_DATA_BUFFER__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _REPARSE_GUID_DATA_BUFFER__bindgen_ty_1 {
    pub DataBuffer: [BYTE; 1usize],
}
pub type REPARSE_GUID_DATA_BUFFER = _REPARSE_GUID_DATA_BUFFER;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RESUME_PERFORMANCE {
    pub PostTimeMs: DWORD,
    pub TotalResumeTimeMs: ULONGLONG,
    pub ResumeCompleteTimestamp: ULONGLONG,
}
pub type RESUME_PERFORMANCE = _RESUME_PERFORMANCE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RTL_RUN_ONCE {
    pub Ptr: PVOID,
}
pub type RTL_RUN_ONCE = _RTL_RUN_ONCE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RTL_BARRIER {
    pub Reserved1: DWORD,
    pub Reserved2: DWORD,
    pub Reserved3: [ULONG_PTR; 2usize],
    pub Reserved4: DWORD,
    pub Reserved5: DWORD,
}
pub type RTL_BARRIER = _RTL_BARRIER;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _OSVERSIONINFOW {
    pub dwOSVersionInfoSize: DWORD,
    pub dwMajorVersion: DWORD,
    pub dwMinorVersion: DWORD,
    pub dwBuildNumber: DWORD,
    pub dwPlatformId: DWORD,
    pub szCSDVersion: [WCHAR; 128usize],
}
pub type RTL_OSVERSIONINFOW = _OSVERSIONINFOW;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _OSVERSIONINFOEXW {
    pub dwOSVersionInfoSize: DWORD,
    pub dwMajorVersion: DWORD,
    pub dwMinorVersion: DWORD,
    pub dwBuildNumber: DWORD,
    pub dwPlatformId: DWORD,
    pub szCSDVersion: [WCHAR; 128usize],
    pub wServicePackMajor: WORD,
    pub wServicePackMinor: WORD,
    pub wSuiteMask: WORD,
    pub wProductType: BYTE,
    pub wReserved: BYTE,
}
pub type RTL_OSVERSIONINFOEXW = _OSVERSIONINFOEXW;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _RTL_UMS_THREAD_INFO_CLASS {
    UmsThreadInvalidInfoClass = 0,
    UmsThreadUserContext = 1,
    UmsThreadPriority = 2,
    UmsThreadAffinity = 3,
    UmsThreadTeb = 4,
    UmsThreadIsSuspended = 5,
    UmsThreadIsTerminated = 6,
    UmsThreadMaxInfoClass = 7,
}
pub use self::_RTL_UMS_THREAD_INFO_CLASS as RTL_UMS_THREAD_INFO_CLASS;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _RTL_UMS_SCHEDULER_REASON {
    UmsSchedulerStartup = 0,
    UmsSchedulerThreadBlocked = 1,
    UmsSchedulerThreadYield = 2,
}
pub use self::_RTL_UMS_SCHEDULER_REASON as RTL_UMS_SCHEDULER_REASON;
pub type RTL_UMS_SCHEDULER_ENTRY_POINT = ::std::option::Option<
    unsafe extern "C" fn(
        Reason: RTL_UMS_SCHEDULER_REASON,
        ActivationPayload: ULONG_PTR,
        SchedulerParam: PVOID,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RTL_CRITICAL_SECTION_DEBUG {
    pub Type: WORD,
    pub CreatorBackTraceIndex: WORD,
    pub CriticalSection: *mut _RTL_CRITICAL_SECTION,
    pub ProcessLocksList: LIST_ENTRY,
    pub EntryCount: DWORD,
    pub ContentionCount: DWORD,
    pub Flags: DWORD,
    pub CreatorBackTraceIndexHigh: WORD,
    pub SpareWORD: WORD,
}
pub type RTL_CRITICAL_SECTION_DEBUG = _RTL_CRITICAL_SECTION_DEBUG;
pub type PRTL_CRITICAL_SECTION_DEBUG = *mut _RTL_CRITICAL_SECTION_DEBUG;
pub type RTL_RESOURCE_DEBUG = _RTL_CRITICAL_SECTION_DEBUG;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RTL_CRITICAL_SECTION {
    pub DebugInfo: PRTL_CRITICAL_SECTION_DEBUG,
    pub LockCount: LONG,
    pub RecursionCount: LONG,
    pub OwningThread: HANDLE,
    pub LockSemaphore: HANDLE,
    pub SpinCount: ULONG_PTR,
}
pub type RTL_CRITICAL_SECTION = _RTL_CRITICAL_SECTION;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RTL_SRWLOCK {
    pub Ptr: PVOID,
}
pub type RTL_SRWLOCK = _RTL_SRWLOCK;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RTL_CONDITION_VARIABLE {
    pub Ptr: PVOID,
}
pub type RTL_CONDITION_VARIABLE = _RTL_CONDITION_VARIABLE;
pub type RTL_VERIFIER_DLL_LOAD_CALLBACK = ::std::option::Option<
    unsafe extern "C" fn(DllName: PWSTR, DllBase: PVOID, DllSize: SIZE_T, Reserved: PVOID),
>;
pub type RTL_VERIFIER_DLL_UNLOAD_CALLBACK = ::std::option::Option<
    unsafe extern "C" fn(DllName: PWSTR, DllBase: PVOID, DllSize: SIZE_T, Reserved: PVOID),
>;
pub type RTL_VERIFIER_NTDLLHEAPFREE_CALLBACK =
    ::std::option::Option<unsafe extern "C" fn(AllocationBase: PVOID, AllocationSize: SIZE_T)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RTL_VERIFIER_THUNK_DESCRIPTOR {
    pub ThunkName: PCHAR,
    pub ThunkOldAddress: PVOID,
    pub ThunkNewAddress: PVOID,
}
pub type RTL_VERIFIER_THUNK_DESCRIPTOR = _RTL_VERIFIER_THUNK_DESCRIPTOR;
pub type PRTL_VERIFIER_THUNK_DESCRIPTOR = *mut _RTL_VERIFIER_THUNK_DESCRIPTOR;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RTL_VERIFIER_DLL_DESCRIPTOR {
    pub DllName: PWCHAR,
    pub DllFlags: DWORD,
    pub DllAddress: PVOID,
    pub DllThunks: PRTL_VERIFIER_THUNK_DESCRIPTOR,
}
pub type RTL_VERIFIER_DLL_DESCRIPTOR = _RTL_VERIFIER_DLL_DESCRIPTOR;
pub type PRTL_VERIFIER_DLL_DESCRIPTOR = *mut _RTL_VERIFIER_DLL_DESCRIPTOR;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RTL_VERIFIER_PROVIDER_DESCRIPTOR {
    pub Length: DWORD,
    pub ProviderDlls: PRTL_VERIFIER_DLL_DESCRIPTOR,
    pub ProviderDllLoadCallback: RTL_VERIFIER_DLL_LOAD_CALLBACK,
    pub ProviderDllUnloadCallback: RTL_VERIFIER_DLL_UNLOAD_CALLBACK,
    pub VerifierImage: PWSTR,
    pub VerifierFlags: DWORD,
    pub VerifierDebug: DWORD,
    pub RtlpGetStackTraceAddress: PVOID,
    pub RtlpDebugPageHeapCreate: PVOID,
    pub RtlpDebugPageHeapDestroy: PVOID,
    pub ProviderNtdllHeapFreeCallback: RTL_VERIFIER_NTDLLHEAPFREE_CALLBACK,
}
pub type RTL_VERIFIER_PROVIDER_DESCRIPTOR = _RTL_VERIFIER_PROVIDER_DESCRIPTOR;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RESOURCEMANAGER_BASIC_INFORMATION {
    pub ResourceManagerId: GUID,
    pub DescriptionLength: DWORD,
    pub Description: [WCHAR; 1usize],
}
pub type RESOURCEMANAGER_BASIC_INFORMATION = _RESOURCEMANAGER_BASIC_INFORMATION;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RESOURCEMANAGER_COMPLETION_INFORMATION {
    pub IoCompletionPortHandle: HANDLE,
    pub CompletionKey: ULONG_PTR,
}
pub type RESOURCEMANAGER_COMPLETION_INFORMATION = _RESOURCEMANAGER_COMPLETION_INFORMATION;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _RESOURCEMANAGER_INFORMATION_CLASS {
    ResourceManagerBasicInformation = 0,
    ResourceManagerCompletionInformation = 1,
}
pub use self::_RESOURCEMANAGER_INFORMATION_CLASS as RESOURCEMANAGER_INFORMATION_CLASS;
pub type WPARAM = UINT_PTR;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HINSTANCE__ {
    pub unused: ::std::os::raw::c_int,
}
pub type HINSTANCE = *mut HINSTANCE__;
pub type HMODULE = HINSTANCE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _FILETIME {
    pub dwLowDateTime: DWORD,
    pub dwHighDateTime: DWORD,
}
pub type FILETIME = _FILETIME;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HWND__ {
    pub unused: ::std::os::raw::c_int,
}
pub type HWND = *mut HWND__;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRECT {
    pub left: LONG,
    pub top: LONG,
    pub right: LONG,
    pub bottom: LONG,
}
pub type RECT = tagRECT;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RECTL {
    pub left: LONG,
    pub top: LONG,
    pub right: LONG,
    pub bottom: LONG,
}
pub type RECTL = _RECTL;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _OVERLAPPED {
    pub Internal: ULONG_PTR,
    pub InternalHigh: ULONG_PTR,
    pub __bindgen_anon_1: _OVERLAPPED__bindgen_ty_1,
    pub hEvent: HANDLE,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _OVERLAPPED__bindgen_ty_1 {
    pub __bindgen_anon_1: _OVERLAPPED__bindgen_ty_1__bindgen_ty_1,
    pub Pointer: PVOID,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _OVERLAPPED__bindgen_ty_1__bindgen_ty_1 {
    pub Offset: DWORD,
    pub OffsetHigh: DWORD,
}
pub type LPOVERLAPPED = *mut _OVERLAPPED;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _SYSTEMTIME {
    pub wYear: WORD,
    pub wMonth: WORD,
    pub wDayOfWeek: WORD,
    pub wDay: WORD,
    pub wHour: WORD,
    pub wMinute: WORD,
    pub wSecond: WORD,
    pub wMilliseconds: WORD,
}
pub type SYSTEMTIME = _SYSTEMTIME;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _REASON_CONTEXT {
    pub Version: ULONG,
    pub Flags: DWORD,
    pub Reason: _REASON_CONTEXT__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _REASON_CONTEXT__bindgen_ty_1 {
    pub Detailed: _REASON_CONTEXT__bindgen_ty_1__bindgen_ty_1,
    pub SimpleReasonString: LPWSTR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _REASON_CONTEXT__bindgen_ty_1__bindgen_ty_1 {
    pub LocalizedReasonModule: HMODULE,
    pub LocalizedReasonId: ULONG,
    pub ReasonStringCount: ULONG,
    pub ReasonStrings: *mut LPWSTR,
}
pub type REASON_CONTEXT = _REASON_CONTEXT;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RIP_INFO {
    pub dwError: DWORD,
    pub dwType: DWORD,
}
pub type RIP_INFO = _RIP_INFO;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _REDIRECTION_FUNCTION_DESCRIPTOR {
    pub DllName: PCSTR,
    pub FunctionName: PCSTR,
    pub RedirectionTarget: PVOID,
}
pub type REDIRECTION_FUNCTION_DESCRIPTOR = _REDIRECTION_FUNCTION_DESCRIPTOR;
pub type PCREDIRECTION_FUNCTION_DESCRIPTOR = *const REDIRECTION_FUNCTION_DESCRIPTOR;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _REDIRECTION_DESCRIPTOR {
    pub Version: ULONG,
    pub FunctionCount: ULONG,
    pub Redirections: PCREDIRECTION_FUNCTION_DESCRIPTOR,
}
pub type REDIRECTION_DESCRIPTOR = _REDIRECTION_DESCRIPTOR;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRGBTRIPLE {
    pub rgbtBlue: BYTE,
    pub rgbtGreen: BYTE,
    pub rgbtRed: BYTE,
}
pub type RGBTRIPLE = tagRGBTRIPLE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRGBQUAD {
    pub rgbBlue: BYTE,
    pub rgbGreen: BYTE,
    pub rgbRed: BYTE,
    pub rgbReserved: BYTE,
}
pub type RGBQUAD = tagRGBQUAD;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RGNDATAHEADER {
    pub dwSize: DWORD,
    pub iType: DWORD,
    pub nCount: DWORD,
    pub nRgnSize: DWORD,
    pub rcBound: RECT,
}
pub type RGNDATAHEADER = _RGNDATAHEADER;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RGNDATA {
    pub rdh: RGNDATAHEADER,
    pub Buffer: [::std::os::raw::c_char; 1usize],
}
pub type RGNDATA = _RGNDATA;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RASTERIZER_STATUS {
    pub nSize: ::std::os::raw::c_short,
    pub wFlags: ::std::os::raw::c_short,
    pub nLanguageID: ::std::os::raw::c_short,
}
pub type RASTERIZER_STATUS = _RASTERIZER_STATUS;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRAWINPUTHEADER {
    pub dwType: DWORD,
    pub dwSize: DWORD,
    pub hDevice: HANDLE,
    pub wParam: WPARAM,
}
pub type RAWINPUTHEADER = tagRAWINPUTHEADER;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct tagRAWMOUSE {
    pub usFlags: USHORT,
    pub __bindgen_anon_1: tagRAWMOUSE__bindgen_ty_1,
    pub ulRawButtons: ULONG,
    pub lLastX: LONG,
    pub lLastY: LONG,
    pub ulExtraInformation: ULONG,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union tagRAWMOUSE__bindgen_ty_1 {
    pub ulButtons: ULONG,
    pub __bindgen_anon_1: tagRAWMOUSE__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRAWMOUSE__bindgen_ty_1__bindgen_ty_1 {
    pub usButtonFlags: USHORT,
    pub usButtonData: USHORT,
}
pub type RAWMOUSE = tagRAWMOUSE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRAWKEYBOARD {
    pub MakeCode: USHORT,
    pub Flags: USHORT,
    pub Reserved: USHORT,
    pub VKey: USHORT,
    pub Message: UINT,
    pub ExtraInformation: ULONG,
}
pub type RAWKEYBOARD = tagRAWKEYBOARD;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRAWHID {
    pub dwSizeHid: DWORD,
    pub dwCount: DWORD,
    pub bRawData: [BYTE; 1usize],
}
pub type RAWHID = tagRAWHID;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct tagRAWINPUT {
    pub header: RAWINPUTHEADER,
    pub data: tagRAWINPUT__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union tagRAWINPUT__bindgen_ty_1 {
    pub mouse: RAWMOUSE,
    pub keyboard: RAWKEYBOARD,
    pub hid: RAWHID,
}
pub type RAWINPUT = tagRAWINPUT;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRID_DEVICE_INFO_MOUSE {
    pub dwId: DWORD,
    pub dwNumberOfButtons: DWORD,
    pub dwSampleRate: DWORD,
    pub fHasHorizontalWheel: WINBOOL,
}
pub type RID_DEVICE_INFO_MOUSE = tagRID_DEVICE_INFO_MOUSE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRID_DEVICE_INFO_KEYBOARD {
    pub dwType: DWORD,
    pub dwSubType: DWORD,
    pub dwKeyboardMode: DWORD,
    pub dwNumberOfFunctionKeys: DWORD,
    pub dwNumberOfIndicators: DWORD,
    pub dwNumberOfKeysTotal: DWORD,
}
pub type RID_DEVICE_INFO_KEYBOARD = tagRID_DEVICE_INFO_KEYBOARD;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRID_DEVICE_INFO_HID {
    pub dwVendorId: DWORD,
    pub dwProductId: DWORD,
    pub dwVersionNumber: DWORD,
    pub usUsagePage: USHORT,
    pub usUsage: USHORT,
}
pub type RID_DEVICE_INFO_HID = tagRID_DEVICE_INFO_HID;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct tagRID_DEVICE_INFO {
    pub cbSize: DWORD,
    pub dwType: DWORD,
    pub __bindgen_anon_1: tagRID_DEVICE_INFO__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union tagRID_DEVICE_INFO__bindgen_ty_1 {
    pub mouse: RID_DEVICE_INFO_MOUSE,
    pub keyboard: RID_DEVICE_INFO_KEYBOARD,
    pub hid: RID_DEVICE_INFO_HID,
}
pub type RID_DEVICE_INFO = tagRID_DEVICE_INFO;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRAWINPUTDEVICE {
    pub usUsagePage: USHORT,
    pub usUsage: USHORT,
    pub dwFlags: DWORD,
    pub hwndTarget: HWND,
}
pub type RAWINPUTDEVICE = tagRAWINPUTDEVICE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRAWINPUTDEVICELIST {
    pub hDevice: HANDLE,
    pub dwType: DWORD,
}
pub type RAWINPUTDEVICELIST = tagRAWINPUTDEVICELIST;
pub type REGSAM = ACCESS_MASK;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct val_context {
    pub valuelen: ::std::os::raw::c_int,
    pub value_context: LPVOID,
    pub val_buff_ptr: LPVOID,
}
pub type PVALCONTEXT = *mut val_context;
pub type PQUERYHANDLER = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: LPVOID,
        arg2: PVALCONTEXT,
        arg3: DWORD,
        arg4: LPVOID,
        arg5: *mut DWORD,
        arg6: DWORD,
    ) -> DWORD,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct provider_info {
    pub pi_R0_1val: PQUERYHANDLER,
    pub pi_R0_allvals: PQUERYHANDLER,
    pub pi_R3_1val: PQUERYHANDLER,
    pub pi_R3_allvals: PQUERYHANDLER,
    pub pi_flags: DWORD,
    pub pi_key_context: LPVOID,
}
pub type REG_PROVIDER = provider_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _REMOTE_NAME_INFOA {
    pub lpUniversalName: LPSTR,
    pub lpConnectionName: LPSTR,
    pub lpRemainingPath: LPSTR,
}
pub type REMOTE_NAME_INFOA = _REMOTE_NAME_INFOA;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _REMOTE_NAME_INFOW {
    pub lpUniversalName: LPWSTR,
    pub lpConnectionName: LPWSTR,
    pub lpRemainingPath: LPWSTR,
}
pub type REMOTE_NAME_INFOW = _REMOTE_NAME_INFOW;
pub type REMOTE_NAME_INFO = REMOTE_NAME_INFOA;
pub type I_RPC_HANDLE = *mut ::std::os::raw::c_void;
pub type RPC_STATUS = ::std::os::raw::c_long;
pub type RPC_CSTR = *mut ::std::os::raw::c_uchar;
pub type RPC_WSTR = *mut ::std::os::raw::c_ushort;
pub type RPC_BINDING_HANDLE = I_RPC_HANDLE;
pub type UUID = GUID;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_BINDING_VECTOR {
    pub Count: ::std::os::raw::c_ulong,
    pub BindingH: [RPC_BINDING_HANDLE; 1usize],
}
pub type RPC_BINDING_VECTOR = _RPC_BINDING_VECTOR;
pub type RPC_IF_HANDLE = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_IF_ID {
    pub Uuid: UUID,
    pub VersMajor: ::std::os::raw::c_ushort,
    pub VersMinor: ::std::os::raw::c_ushort,
}
pub type RPC_IF_ID = _RPC_IF_ID;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_PROTSEQ_VECTORA {
    pub Count: ::std::os::raw::c_uint,
    pub Protseq: [*mut ::std::os::raw::c_uchar; 1usize],
}
pub type RPC_PROTSEQ_VECTORA = _RPC_PROTSEQ_VECTORA;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_PROTSEQ_VECTORW {
    pub Count: ::std::os::raw::c_uint,
    pub Protseq: [*mut ::std::os::raw::c_ushort; 1usize],
}
pub type RPC_PROTSEQ_VECTORW = _RPC_PROTSEQ_VECTORW;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_POLICY {
    pub Length: ::std::os::raw::c_uint,
    pub EndpointFlags: ::std::os::raw::c_ulong,
    pub NICFlags: ::std::os::raw::c_ulong,
}
pub type RPC_POLICY = _RPC_POLICY;
pub type RPC_OBJECT_INQ_FN = ::std::option::Option<
    unsafe extern "C" fn(ObjectUuid: *mut UUID, TypeUuid: *mut UUID, Status: *mut RPC_STATUS),
>;
pub type RPC_IF_CALLBACK_FN = ::std::option::Option<
    unsafe extern "C" fn(
        InterfaceUuid: RPC_IF_HANDLE,
        Context: *mut ::std::os::raw::c_void,
    ) -> RPC_STATUS,
>;
pub type RPC_SECURITY_CALLBACK_FN =
    ::std::option::Option<unsafe extern "C" fn(Context: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RPC_STATS_VECTOR {
    pub Count: ::std::os::raw::c_uint,
    pub Stats: [::std::os::raw::c_ulong; 1usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RPC_IF_ID_VECTOR {
    pub Count: ::std::os::raw::c_ulong,
    pub IfId: [*mut RPC_IF_ID; 1usize],
}
pub type RPC_AUTH_IDENTITY_HANDLE = *mut ::std::os::raw::c_void;
pub type RPC_AUTHZ_HANDLE = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_SECURITY_QOS {
    pub Version: ::std::os::raw::c_ulong,
    pub Capabilities: ::std::os::raw::c_ulong,
    pub IdentityTracking: ::std::os::raw::c_ulong,
    pub ImpersonationType: ::std::os::raw::c_ulong,
}
pub type RPC_SECURITY_QOS = _RPC_SECURITY_QOS;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _SEC_WINNT_AUTH_IDENTITY_W {
    pub User: *mut ::std::os::raw::c_ushort,
    pub UserLength: ::std::os::raw::c_ulong,
    pub Domain: *mut ::std::os::raw::c_ushort,
    pub DomainLength: ::std::os::raw::c_ulong,
    pub Password: *mut ::std::os::raw::c_ushort,
    pub PasswordLength: ::std::os::raw::c_ulong,
    pub Flags: ::std::os::raw::c_ulong,
}
pub type SEC_WINNT_AUTH_IDENTITY_W = _SEC_WINNT_AUTH_IDENTITY_W;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _SEC_WINNT_AUTH_IDENTITY_A {
    pub User: *mut ::std::os::raw::c_uchar,
    pub UserLength: ::std::os::raw::c_ulong,
    pub Domain: *mut ::std::os::raw::c_uchar,
    pub DomainLength: ::std::os::raw::c_ulong,
    pub Password: *mut ::std::os::raw::c_uchar,
    pub PasswordLength: ::std::os::raw::c_ulong,
    pub Flags: ::std::os::raw::c_ulong,
}
pub type SEC_WINNT_AUTH_IDENTITY_A = _SEC_WINNT_AUTH_IDENTITY_A;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_HTTP_TRANSPORT_CREDENTIALS_W {
    pub TransportCredentials: *mut SEC_WINNT_AUTH_IDENTITY_W,
    pub Flags: ::std::os::raw::c_ulong,
    pub AuthenticationTarget: ::std::os::raw::c_ulong,
    pub NumberOfAuthnSchemes: ::std::os::raw::c_ulong,
    pub AuthnSchemes: *mut ::std::os::raw::c_ulong,
    pub ServerCertificateSubject: *mut ::std::os::raw::c_ushort,
}
pub type RPC_HTTP_TRANSPORT_CREDENTIALS_W = _RPC_HTTP_TRANSPORT_CREDENTIALS_W;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_HTTP_TRANSPORT_CREDENTIALS_A {
    pub TransportCredentials: *mut SEC_WINNT_AUTH_IDENTITY_A,
    pub Flags: ::std::os::raw::c_ulong,
    pub AuthenticationTarget: ::std::os::raw::c_ulong,
    pub NumberOfAuthnSchemes: ::std::os::raw::c_ulong,
    pub AuthnSchemes: *mut ::std::os::raw::c_ulong,
    pub ServerCertificateSubject: *mut ::std::os::raw::c_uchar,
}
pub type RPC_HTTP_TRANSPORT_CREDENTIALS_A = _RPC_HTTP_TRANSPORT_CREDENTIALS_A;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _RPC_SECURITY_QOS_V2_W {
    pub Version: ::std::os::raw::c_ulong,
    pub Capabilities: ::std::os::raw::c_ulong,
    pub IdentityTracking: ::std::os::raw::c_ulong,
    pub ImpersonationType: ::std::os::raw::c_ulong,
    pub AdditionalSecurityInfoType: ::std::os::raw::c_ulong,
    pub u: _RPC_SECURITY_QOS_V2_W__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _RPC_SECURITY_QOS_V2_W__bindgen_ty_1 {
    pub HttpCredentials: *mut RPC_HTTP_TRANSPORT_CREDENTIALS_W,
}
pub type RPC_SECURITY_QOS_V2_W = _RPC_SECURITY_QOS_V2_W;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _RPC_SECURITY_QOS_V2_A {
    pub Version: ::std::os::raw::c_ulong,
    pub Capabilities: ::std::os::raw::c_ulong,
    pub IdentityTracking: ::std::os::raw::c_ulong,
    pub ImpersonationType: ::std::os::raw::c_ulong,
    pub AdditionalSecurityInfoType: ::std::os::raw::c_ulong,
    pub u: _RPC_SECURITY_QOS_V2_A__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _RPC_SECURITY_QOS_V2_A__bindgen_ty_1 {
    pub HttpCredentials: *mut RPC_HTTP_TRANSPORT_CREDENTIALS_A,
}
pub type RPC_SECURITY_QOS_V2_A = _RPC_SECURITY_QOS_V2_A;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _RPC_SECURITY_QOS_V3_W {
    pub Version: ::std::os::raw::c_ulong,
    pub Capabilities: ::std::os::raw::c_ulong,
    pub IdentityTracking: ::std::os::raw::c_ulong,
    pub ImpersonationType: ::std::os::raw::c_ulong,
    pub AdditionalSecurityInfoType: ::std::os::raw::c_ulong,
    pub u: _RPC_SECURITY_QOS_V3_W__bindgen_ty_1,
    pub Sid: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _RPC_SECURITY_QOS_V3_W__bindgen_ty_1 {
    pub HttpCredentials: *mut RPC_HTTP_TRANSPORT_CREDENTIALS_W,
}
pub type RPC_SECURITY_QOS_V3_W = _RPC_SECURITY_QOS_V3_W;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _RPC_SECURITY_QOS_V3_A {
    pub Version: ::std::os::raw::c_ulong,
    pub Capabilities: ::std::os::raw::c_ulong,
    pub IdentityTracking: ::std::os::raw::c_ulong,
    pub ImpersonationType: ::std::os::raw::c_ulong,
    pub AdditionalSecurityInfoType: ::std::os::raw::c_ulong,
    pub u: _RPC_SECURITY_QOS_V3_A__bindgen_ty_1,
    pub Sid: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _RPC_SECURITY_QOS_V3_A__bindgen_ty_1 {
    pub HttpCredentials: *mut RPC_HTTP_TRANSPORT_CREDENTIALS_A,
}
pub type RPC_SECURITY_QOS_V3_A = _RPC_SECURITY_QOS_V3_A;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _RPC_HTTP_REDIRECTOR_STAGE {
    RPCHTTP_RS_REDIRECT = 1,
    RPCHTTP_RS_ACCESS_1 = 2,
    RPCHTTP_RS_SESSION = 3,
    RPCHTTP_RS_ACCESS_2 = 4,
    RPCHTTP_RS_INTERFACE = 5,
}
pub use self::_RPC_HTTP_REDIRECTOR_STAGE as RPC_HTTP_REDIRECTOR_STAGE;
pub type RPC_NEW_HTTP_PROXY_CHANNEL = ::std::option::Option<
    unsafe extern "C" fn(
        RedirectorStage: RPC_HTTP_REDIRECTOR_STAGE,
        ServerName: *mut ::std::os::raw::c_ushort,
        ServerPort: *mut ::std::os::raw::c_ushort,
        RemoteUser: *mut ::std::os::raw::c_ushort,
        AuthType: *mut ::std::os::raw::c_ushort,
        ResourceUuid: *mut ::std::os::raw::c_void,
        Metadata: *mut ::std::os::raw::c_void,
        SessionId: *mut ::std::os::raw::c_void,
        Interface: *mut ::std::os::raw::c_void,
        Reserved: *mut ::std::os::raw::c_void,
        Flags: ::std::os::raw::c_ulong,
        NewServerName: *mut *mut ::std::os::raw::c_ushort,
        NewServerPort: *mut *mut ::std::os::raw::c_ushort,
    ) -> RPC_STATUS,
>;
pub type RPC_HTTP_PROXY_FREE_STRING =
    ::std::option::Option<unsafe extern "C" fn(String: *mut ::std::os::raw::c_ushort)>;
pub type RPC_AUTH_KEY_RETRIEVAL_FN = ::std::option::Option<
    unsafe extern "C" fn(
        Arg: *mut ::std::os::raw::c_void,
        ServerPrincName: *mut ::std::os::raw::c_ushort,
        KeyVer: ::std::os::raw::c_ulong,
        Key: *mut *mut ::std::os::raw::c_void,
        Status: *mut RPC_STATUS,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RPC_CLIENT_INFORMATION1 {
    pub UserName: *mut ::std::os::raw::c_uchar,
    pub ComputerName: *mut ::std::os::raw::c_uchar,
    pub Privilege: ::std::os::raw::c_ushort,
    pub AuthFlags: ::std::os::raw::c_ulong,
}
pub type RPC_EP_INQ_HANDLE = *mut I_RPC_HANDLE;
pub type RPC_MGMT_AUTHORIZATION_FN = ::std::option::Option<
    unsafe extern "C" fn(
        ClientBinding: RPC_BINDING_HANDLE,
        RequestedMgmtOperation: ::std::os::raw::c_ulong,
        Status: *mut RPC_STATUS,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_BINDING_HANDLE_OPTIONS_V1 {
    pub Version: ::std::os::raw::c_ulong,
    pub Flags: ::std::os::raw::c_ulong,
    pub ComTimeout: ::std::os::raw::c_ulong,
    pub CallTimeout: ::std::os::raw::c_ulong,
}
pub type RPC_BINDING_HANDLE_OPTIONS_V1 = _RPC_BINDING_HANDLE_OPTIONS_V1;
pub type RPC_BINDING_HANDLE_OPTIONS = _RPC_BINDING_HANDLE_OPTIONS_V1;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RPC_BINDING_HANDLE_SECURITY_V1 {
    pub Version: ::std::os::raw::c_ulong,
    pub ServerPrincName: *mut ::std::os::raw::c_ushort,
    pub AuthnLevel: ::std::os::raw::c_ulong,
    pub AuthnSvc: ::std::os::raw::c_ulong,
    pub AuthIdentity: *mut SEC_WINNT_AUTH_IDENTITY_A,
    pub SecurityQos: *mut RPC_SECURITY_QOS,
}
pub type RPC_BINDING_HANDLE_SECURITY = RPC_BINDING_HANDLE_SECURITY_V1;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _RPC_BINDING_HANDLE_TEMPLATE {
    pub Version: ::std::os::raw::c_ulong,
    pub Flags: ::std::os::raw::c_ulong,
    pub ProtocolSequence: ::std::os::raw::c_ulong,
    pub NetworkAddress: *mut ::std::os::raw::c_ushort,
    pub StringEndpoint: *mut ::std::os::raw::c_ushort,
    pub u1: _RPC_BINDING_HANDLE_TEMPLATE__bindgen_ty_1,
    pub ObjectUuid: UUID,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _RPC_BINDING_HANDLE_TEMPLATE__bindgen_ty_1 {
    pub Reserved: *mut ::std::os::raw::c_ushort,
}
pub type RPC_BINDING_HANDLE_TEMPLATE_V1 = _RPC_BINDING_HANDLE_TEMPLATE;
pub type RPC_BINDING_HANDLE_TEMPLATE = _RPC_BINDING_HANDLE_TEMPLATE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_VERSION {
    pub MajorVersion: ::std::os::raw::c_ushort,
    pub MinorVersion: ::std::os::raw::c_ushort,
}
pub type RPC_VERSION = _RPC_VERSION;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_SYNTAX_IDENTIFIER {
    pub SyntaxGUID: GUID,
    pub SyntaxVersion: RPC_VERSION,
}
pub type RPC_SYNTAX_IDENTIFIER = _RPC_SYNTAX_IDENTIFIER;
pub type PRPC_SYNTAX_IDENTIFIER = *mut _RPC_SYNTAX_IDENTIFIER;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_MESSAGE {
    pub Handle: RPC_BINDING_HANDLE,
    pub DataRepresentation: ::std::os::raw::c_ulong,
    pub Buffer: *mut ::std::os::raw::c_void,
    pub BufferLength: ::std::os::raw::c_uint,
    pub ProcNum: ::std::os::raw::c_uint,
    pub TransferSyntax: PRPC_SYNTAX_IDENTIFIER,
    pub RpcInterfaceInformation: *mut ::std::os::raw::c_void,
    pub ReservedForRuntime: *mut ::std::os::raw::c_void,
    pub ManagerEpv: *mut ::std::os::raw::c_void,
    pub ImportContext: *mut ::std::os::raw::c_void,
    pub RpcFlags: ::std::os::raw::c_ulong,
}
pub type RPC_MESSAGE = _RPC_MESSAGE;
pub type PRPC_MESSAGE = *mut _RPC_MESSAGE;
pub type RPC_FORWARD_FUNCTION = ::std::option::Option<
    unsafe extern "C" fn(
        InterfaceId: *mut UUID,
        InterfaceVersion: *mut RPC_VERSION,
        ObjectId: *mut UUID,
        Rpcpro: *mut ::std::os::raw::c_uchar,
        ppDestEndpoint: *mut *mut ::std::os::raw::c_void,
    ) -> RPC_STATUS,
>;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RPC_ADDRESS_CHANGE_TYPE {
    PROTOCOL_NOT_LOADED = 1,
    PROTOCOL_LOADED = 2,
    PROTOCOL_ADDRESS_CHANGE = 3,
}
pub type RPC_ADDRESS_CHANGE_FN =
    ::std::option::Option<unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void)>;
pub type RPC_DISPATCH_FUNCTION = ::std::option::Option<unsafe extern "C" fn(Message: PRPC_MESSAGE)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RPC_DISPATCH_TABLE {
    pub DispatchTableCount: ::std::os::raw::c_uint,
    pub DispatchTable: *mut RPC_DISPATCH_FUNCTION,
    pub Reserved: LONG_PTR,
}
pub type PRPC_DISPATCH_TABLE = *mut RPC_DISPATCH_TABLE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_PROTSEQ_ENDPOINT {
    pub RpcProtocolSequence: *mut ::std::os::raw::c_uchar,
    pub Endpoint: *mut ::std::os::raw::c_uchar,
}
pub type RPC_PROTSEQ_ENDPOINT = _RPC_PROTSEQ_ENDPOINT;
pub type PRPC_PROTSEQ_ENDPOINT = *mut _RPC_PROTSEQ_ENDPOINT;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_SERVER_INTERFACE {
    pub Length: ::std::os::raw::c_uint,
    pub InterfaceId: RPC_SYNTAX_IDENTIFIER,
    pub TransferSyntax: RPC_SYNTAX_IDENTIFIER,
    pub DispatchTable: PRPC_DISPATCH_TABLE,
    pub RpcProtseqEndpointCount: ::std::os::raw::c_uint,
    pub RpcProtseqEndpoint: PRPC_PROTSEQ_ENDPOINT,
    pub DefaultManagerEpv: *mut ::std::os::raw::c_void,
    pub InterpreterInfo: *const ::std::os::raw::c_void,
    pub Flags: ::std::os::raw::c_uint,
}
pub type RPC_SERVER_INTERFACE = _RPC_SERVER_INTERFACE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_CLIENT_INTERFACE {
    pub Length: ::std::os::raw::c_uint,
    pub InterfaceId: RPC_SYNTAX_IDENTIFIER,
    pub TransferSyntax: RPC_SYNTAX_IDENTIFIER,
    pub DispatchTable: PRPC_DISPATCH_TABLE,
    pub RpcProtseqEndpointCount: ::std::os::raw::c_uint,
    pub RpcProtseqEndpoint: PRPC_PROTSEQ_ENDPOINT,
    pub Reserved: ULONG_PTR,
    pub InterpreterInfo: *const ::std::os::raw::c_void,
    pub Flags: ::std::os::raw::c_uint,
}
pub type RPC_CLIENT_INTERFACE = _RPC_CLIENT_INTERFACE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_TRANSFER_SYNTAX {
    pub Uuid: UUID,
    pub VersMajor: ::std::os::raw::c_ushort,
    pub VersMinor: ::std::os::raw::c_ushort,
}
pub type RPC_TRANSFER_SYNTAX = _RPC_TRANSFER_SYNTAX;
pub type RPCLT_PDU_FILTER_FUNC = ::std::option::Option<
    unsafe extern "C" fn(
        Buffer: *mut ::std::os::raw::c_void,
        BufferLength: ::std::os::raw::c_uint,
        fDatagram: ::std::os::raw::c_int,
    ),
>;
pub type RPC_SETFILTER_FUNC =
    ::std::option::Option<unsafe extern "C" fn(pfnFilter: RPCLT_PDU_FILTER_FUNC)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_C_OPT_METADATA_DESCRIPTOR {
    pub BufferSize: ::std::os::raw::c_ulong,
    pub Buffer: *mut ::std::os::raw::c_char,
}
pub type RPC_C_OPT_METADATA_DESCRIPTOR = _RPC_C_OPT_METADATA_DESCRIPTOR;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RDR_CALLOUT_STATE {
    pub LastError: RPC_STATUS,
    pub LastEEInfo: *mut ::std::os::raw::c_void,
    pub LastCalledStage: RPC_HTTP_REDIRECTOR_STAGE,
    pub ServerName: *mut ::std::os::raw::c_ushort,
    pub ServerPort: *mut ::std::os::raw::c_ushort,
    pub RemoteUser: *mut ::std::os::raw::c_ushort,
    pub AuthType: *mut ::std::os::raw::c_ushort,
    pub ResourceTypePresent: ::std::os::raw::c_uchar,
    pub MetadataPresent: ::std::os::raw::c_uchar,
    pub SessionIdPresent: ::std::os::raw::c_uchar,
    pub InterfacePresent: ::std::os::raw::c_uchar,
    pub ResourceType: UUID,
    pub Metadata: RPC_C_OPT_METADATA_DESCRIPTOR,
    pub SessionId: UUID,
    pub Interface: RPC_SYNTAX_IDENTIFIER,
    pub CertContext: *mut ::std::os::raw::c_void,
}
pub type RDR_CALLOUT_STATE = _RDR_CALLOUT_STATE;
pub type RPC_NS_HANDLE = *mut ::std::os::raw::c_void;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _RPC_NOTIFICATION_TYPES {
    RpcNotificationTypeNone = 0,
    RpcNotificationTypeEvent = 1,
    RpcNotificationTypeApc = 2,
    RpcNotificationTypeIoc = 3,
    RpcNotificationTypeHwnd = 4,
    RpcNotificationTypeCallback = 5,
}
pub use self::_RPC_NOTIFICATION_TYPES as RPC_NOTIFICATION_TYPES;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _RPC_ASYNC_EVENT {
    RpcCallComplete = 0,
    RpcSendComplete = 1,
    RpcReceiveComplete = 2,
}
pub use self::_RPC_ASYNC_EVENT as RPC_ASYNC_EVENT;
pub type RPCNOTIFICATION_ROUTINE = ::std::option::Option<
    unsafe extern "C" fn(
        pAsync: *mut _RPC_ASYNC_STATE,
        Context: *mut ::std::os::raw::c_void,
        Event: RPC_ASYNC_EVENT,
    ),
>;
pub type PFN_RPCNOTIFICATION_ROUTINE = RPCNOTIFICATION_ROUTINE;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _RPC_ASYNC_STATE {
    pub Size: ::std::os::raw::c_uint,
    pub Signature: ::std::os::raw::c_ulong,
    pub Lock: ::std::os::raw::c_long,
    pub Flags: ::std::os::raw::c_ulong,
    pub StubInfo: *mut ::std::os::raw::c_void,
    pub UserInfo: *mut ::std::os::raw::c_void,
    pub RuntimeInfo: *mut ::std::os::raw::c_void,
    pub Event: RPC_ASYNC_EVENT,
    pub NotificationType: RPC_NOTIFICATION_TYPES,
    pub u: _RPC_ASYNC_STATE__bindgen_ty_1,
    pub Reserved: [LONG_PTR; 4usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _RPC_ASYNC_STATE__bindgen_ty_1 {
    pub APC: _RPC_ASYNC_STATE__bindgen_ty_1__bindgen_ty_1,
    pub IOC: _RPC_ASYNC_STATE__bindgen_ty_1__bindgen_ty_2,
    pub HWND: _RPC_ASYNC_STATE__bindgen_ty_1__bindgen_ty_3,
    pub hEvent: HANDLE,
    pub NotificationRoutine: PFN_RPCNOTIFICATION_ROUTINE,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_ASYNC_STATE__bindgen_ty_1__bindgen_ty_1 {
    pub NotificationRoutine: PFN_RPCNOTIFICATION_ROUTINE,
    pub hThread: HANDLE,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_ASYNC_STATE__bindgen_ty_1__bindgen_ty_2 {
    pub hIOPort: HANDLE,
    pub dwNumberOfBytesTransferred: DWORD,
    pub dwCompletionKey: DWORD_PTR,
    pub lpOverlapped: LPOVERLAPPED,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_ASYNC_STATE__bindgen_ty_1__bindgen_ty_3 {
    pub hWnd: HWND,
    pub Msg: UINT,
}
pub type RPC_ASYNC_STATE = _RPC_ASYNC_STATE;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum tagExtendedErrorParamTypes {
    eeptAnsiString = 1,
    eeptUnicodeString = 2,
    eeptLongVal = 3,
    eeptShortVal = 4,
    eeptPointerVal = 5,
    eeptNone = 6,
    eeptBinary = 7,
}
pub use self::tagExtendedErrorParamTypes as ExtendedErrorParamTypes;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagBinaryParam {
    pub Buffer: *mut ::std::os::raw::c_void,
    pub Size: ::std::os::raw::c_short,
}
pub type BinaryParam = tagBinaryParam;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct tagRPC_EE_INFO_PARAM {
    pub ParameterType: ExtendedErrorParamTypes,
    pub u: tagRPC_EE_INFO_PARAM__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union tagRPC_EE_INFO_PARAM__bindgen_ty_1 {
    pub AnsiString: LPSTR,
    pub UnicodeString: LPWSTR,
    pub LVal: ::std::os::raw::c_long,
    pub SVal: ::std::os::raw::c_short,
    pub PVal: ULONGLONG,
    pub BVal: BinaryParam,
}
pub type RPC_EE_INFO_PARAM = tagRPC_EE_INFO_PARAM;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct tagRPC_EXTENDED_ERROR_INFO {
    pub Version: ULONG,
    pub ComputerName: LPWSTR,
    pub ProcessID: ULONG,
    pub u: tagRPC_EXTENDED_ERROR_INFO__bindgen_ty_1,
    pub GeneratingComponent: ULONG,
    pub Status: ULONG,
    pub DetectionLocation: USHORT,
    pub Flags: USHORT,
    pub NumberOfParameters: ::std::os::raw::c_int,
    pub Parameters: [RPC_EE_INFO_PARAM; 4usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union tagRPC_EXTENDED_ERROR_INFO__bindgen_ty_1 {
    pub SystemTime: SYSTEMTIME,
    pub FileTime: FILETIME,
}
pub type RPC_EXTENDED_ERROR_INFO = tagRPC_EXTENDED_ERROR_INFO;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRPC_ERROR_ENUM_HANDLE {
    pub Signature: ULONG,
    pub CurrentPos: *mut ::std::os::raw::c_void,
    pub Head: *mut ::std::os::raw::c_void,
}
pub type RPC_ERROR_ENUM_HANDLE = tagRPC_ERROR_ENUM_HANDLE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRPC_CALL_ATTRIBUTES_V1_W {
    pub Version: ::std::os::raw::c_uint,
    pub Flags: ::std::os::raw::c_ulong,
    pub ServerPrincipalNameBufferLength: ::std::os::raw::c_ulong,
    pub ServerPrincipalName: *mut ::std::os::raw::c_ushort,
    pub ClientPrincipalNameBufferLength: ::std::os::raw::c_ulong,
    pub ClientPrincipalName: *mut ::std::os::raw::c_ushort,
    pub AuthenticationLevel: ::std::os::raw::c_ulong,
    pub AuthenticationService: ::std::os::raw::c_ulong,
    pub NullSession: WINBOOL,
}
pub type RPC_CALL_ATTRIBUTES_V1_W = tagRPC_CALL_ATTRIBUTES_V1_W;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRPC_CALL_ATTRIBUTES_V1_A {
    pub Version: ::std::os::raw::c_uint,
    pub Flags: ::std::os::raw::c_ulong,
    pub ServerPrincipalNameBufferLength: ::std::os::raw::c_ulong,
    pub ServerPrincipalName: *mut ::std::os::raw::c_uchar,
    pub ClientPrincipalNameBufferLength: ::std::os::raw::c_ulong,
    pub ClientPrincipalName: *mut ::std::os::raw::c_uchar,
    pub AuthenticationLevel: ::std::os::raw::c_ulong,
    pub AuthenticationService: ::std::os::raw::c_ulong,
    pub NullSession: WINBOOL,
}
pub type RPC_CALL_ATTRIBUTES_V1_A = tagRPC_CALL_ATTRIBUTES_V1_A;
pub type RPC_CALL_ATTRIBUTES = RPC_CALL_ATTRIBUTES_V1_A;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _RPC_ASYNC_NOTIFICATION_INFO {
    pub APC: _RPC_ASYNC_NOTIFICATION_INFO__bindgen_ty_1,
    pub IOC: _RPC_ASYNC_NOTIFICATION_INFO__bindgen_ty_2,
    pub HWND: _RPC_ASYNC_NOTIFICATION_INFO__bindgen_ty_3,
    pub hEvent: HANDLE,
    pub NotificationRoutine: PFN_RPCNOTIFICATION_ROUTINE,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_ASYNC_NOTIFICATION_INFO__bindgen_ty_1 {
    pub NotificationRoutine: PFN_RPCNOTIFICATION_ROUTINE,
    pub hThread: HANDLE,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_ASYNC_NOTIFICATION_INFO__bindgen_ty_2 {
    pub hIOPort: HANDLE,
    pub dwNumberOfBytesTransferred: DWORD,
    pub dwCompletionKey: DWORD_PTR,
    pub lpOverlapped: LPOVERLAPPED,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RPC_ASYNC_NOTIFICATION_INFO__bindgen_ty_3 {
    pub hWnd: HWND,
    pub Msg: UINT,
}
pub type RPC_ASYNC_NOTIFICATION_INFO = _RPC_ASYNC_NOTIFICATION_INFO;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _RpcCallType {
    rctInvalid = 0,
    rctNormal = 1,
    rctTraining = 2,
    rctGuaranteed = 3,
}
pub use self::_RpcCallType as RpcCallType;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _RpcLocalAddressFormat {
    rlafInvalid = 0,
    rlafIPv4 = 1,
    rlafIPv6 = 2,
}
pub use self::_RpcLocalAddressFormat as RpcLocalAddressFormat;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _RPC_NOTIFICATIONS {
    RpcNotificationCallNone = 0,
    RpcNotificationClientDisconnect = 1,
    RpcNotificationCallCancel = 2,
}
pub use self::_RPC_NOTIFICATIONS as RPC_NOTIFICATIONS;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _RpcCallClientLocality {
    rcclInvalid = 0,
    rcclLocal = 1,
    rcclRemote = 2,
    rcclClientUnknownLocality = 3,
}
pub use self::_RpcCallClientLocality as RpcCallClientLocality;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRPC_CALL_LOCAL_ADDRESS_V1_A {
    pub Version: ::std::os::raw::c_uint,
    pub Buffer: *mut ::std::os::raw::c_void,
    pub BufferSize: ::std::os::raw::c_ulong,
    pub AddressFormat: RpcLocalAddressFormat,
}
pub type RPC_CALL_LOCAL_ADDRESS_V1_A = tagRPC_CALL_LOCAL_ADDRESS_V1_A;
pub type RPC_CALL_LOCAL_ADDRESS_A = tagRPC_CALL_LOCAL_ADDRESS_V1_A;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRPC_CALL_LOCAL_ADDRESS_V1_W {
    pub Version: ::std::os::raw::c_uint,
    pub Buffer: *mut ::std::os::raw::c_void,
    pub BufferSize: ::std::os::raw::c_ulong,
    pub AddressFormat: RpcLocalAddressFormat,
}
pub type RPC_CALL_LOCAL_ADDRESS_V1_W = tagRPC_CALL_LOCAL_ADDRESS_V1_W;
pub type RPC_CALL_LOCAL_ADDRESS_W = tagRPC_CALL_LOCAL_ADDRESS_V1_W;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRPC_CALL_ATTRIBUTES_V2A {
    pub Version: ::std::os::raw::c_uint,
    pub Flags: ::std::os::raw::c_ulong,
    pub ServerPrincipalNameBufferLength: ::std::os::raw::c_ulong,
    pub ServerPrincipalName: *mut ::std::os::raw::c_ushort,
    pub ClientPrincipalNameBufferLength: ::std::os::raw::c_ulong,
    pub ClientPrincipalName: *mut ::std::os::raw::c_ushort,
    pub AuthenticationLevel: ::std::os::raw::c_ulong,
    pub AuthenticationService: ::std::os::raw::c_ulong,
    pub NullSession: WINBOOL,
    pub KernelMode: WINBOOL,
    pub ProtocolSequence: ::std::os::raw::c_ulong,
    pub IsClientLocal: RpcCallClientLocality,
    pub ClientPID: HANDLE,
    pub CallStatus: ::std::os::raw::c_ulong,
    pub CallType: RpcCallType,
    pub CallLocalAddress: *mut RPC_CALL_LOCAL_ADDRESS_A,
    pub OpNum: ::std::os::raw::c_ushort,
    pub InterfaceUuid: UUID,
}
pub type RPC_CALL_ATTRIBUTES_V2_A = tagRPC_CALL_ATTRIBUTES_V2A;
pub type RPC_CALL_ATTRIBUTES_A = tagRPC_CALL_ATTRIBUTES_V2A;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRPC_CALL_ATTRIBUTES_V2W {
    pub Version: ::std::os::raw::c_uint,
    pub Flags: ::std::os::raw::c_ulong,
    pub ServerPrincipalNameBufferLength: ::std::os::raw::c_ulong,
    pub ServerPrincipalName: *mut ::std::os::raw::c_ushort,
    pub ClientPrincipalNameBufferLength: ::std::os::raw::c_ulong,
    pub ClientPrincipalName: *mut ::std::os::raw::c_ushort,
    pub AuthenticationLevel: ::std::os::raw::c_ulong,
    pub AuthenticationService: ::std::os::raw::c_ulong,
    pub NullSession: WINBOOL,
    pub KernelMode: WINBOOL,
    pub ProtocolSequence: ::std::os::raw::c_ulong,
    pub IsClientLocal: RpcCallClientLocality,
    pub ClientPID: HANDLE,
    pub CallStatus: ::std::os::raw::c_ulong,
    pub CallType: RpcCallType,
    pub CallLocalAddress: *mut RPC_CALL_LOCAL_ADDRESS_W,
    pub OpNum: ::std::os::raw::c_ushort,
    pub InterfaceUuid: UUID,
}
pub type RPC_CALL_ATTRIBUTES_V2_W = tagRPC_CALL_ATTRIBUTES_V2W;
pub type RPC_CALL_ATTRIBUTES_W = tagRPC_CALL_ATTRIBUTES_V2W;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RSAPUBKEY {
    pub magic: DWORD,
    pub bitlen: DWORD,
    pub pubexp: DWORD,
}
pub type RSAPUBKEY = _RSAPUBKEY;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ROOT_INFO_LUID {
    pub LowPart: DWORD,
    pub HighPart: LONG,
}
pub type ROOT_INFO_LUID = _ROOT_INFO_LUID;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RPC_IMPORT_CONTEXT_P {
    pub LookupContext: RPC_NS_HANDLE,
    pub ProposedHandle: RPC_BINDING_HANDLE,
    pub Bindings: *mut RPC_BINDING_VECTOR,
}
pub type RPC_BUFPTR = *mut ::std::os::raw::c_uchar;
pub type RPC_LENGTH = ::std::os::raw::c_ulong;
pub type RPC_SS_THREAD_HANDLE = *mut ::std::os::raw::c_void;
pub type RPC_CLIENT_ALLOC =
    ::std::option::Option<unsafe extern "C" fn(Size: size_t) -> *mut ::std::os::raw::c_void>;
pub type RPC_CLIENT_FREE =
    ::std::option::Option<unsafe extern "C" fn(Ptr: *mut ::std::os::raw::c_void)>;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum tagREGCLS {
    REGCLS_SINGLEUSE = 0,
    REGCLS_MULTIPLEUSE = 1,
    REGCLS_MULTI_SEPARATE = 2,
    REGCLS_SUSPENDED = 4,
    REGCLS_SURROGATE = 8,
}
pub use self::tagREGCLS as REGCLS;
pub type RPCOLEDATAREP = ULONG;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRPCOLEMESSAGE {
    pub reserved1: *mut ::std::os::raw::c_void,
    pub dataRepresentation: RPCOLEDATAREP,
    pub Buffer: *mut ::std::os::raw::c_void,
    pub cbBuffer: ULONG,
    pub iMethod: ULONG,
    pub reserved2: [*mut ::std::os::raw::c_void; 5usize],
    pub rpcFlags: ULONG,
}
pub type RPCOLEMESSAGE = tagRPCOLEMESSAGE;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum tagRPCOPT_PROPERTIES {
    COMBND_RPCTIMEOUT = 1,
    COMBND_SERVER_LOCALITY = 2,
    COMBND_RESERVED1 = 4,
}
pub use self::tagRPCOPT_PROPERTIES as RPCOPT_PROPERTIES;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum tagRPCOPT_SERVER_LOCALITY_VALUES {
    SERVER_LOCALITY_PROCESS_LOCAL = 0,
    SERVER_LOCALITY_MACHINE_LOCAL = 1,
    SERVER_LOCALITY_REMOTE = 2,
}
pub use self::tagRPCOPT_SERVER_LOCALITY_VALUES as RPCOPT_SERVER_LOCALITY_VALUES;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _REMSECURITY_ATTRIBUTES {
    pub nLength: DWORD,
    pub lpSecurityDescriptor: DWORD,
    pub bInheritHandle: WINBOOL,
}
pub type REMSECURITY_ATTRIBUTES = _REMSECURITY_ATTRIBUTES;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum tagREGKIND {
    REGKIND_DEFAULT = 0,
    REGKIND_REGISTER = 1,
    REGKIND_NONE = 2,
}
pub use self::tagREGKIND as REGKIND;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _REASSIGN_BLOCKS {
    pub Reserved: WORD,
    pub Count: WORD,
    pub BlockNumber: [DWORD; 1usize],
}
pub type REASSIGN_BLOCKS = _REASSIGN_BLOCKS;
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct _REASSIGN_BLOCKS_EX {
    pub Reserved: WORD,
    pub Count: WORD,
    pub BlockNumber: [LARGE_INTEGER; 1usize],
}
pub type REASSIGN_BLOCKS_EX = _REASSIGN_BLOCKS_EX;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _ELEMENT_TYPE {
    AllElements = 0,
    ChangerTransport = 1,
    ChangerSlot = 2,
    ChangerIEPort = 3,
    ChangerDrive = 4,
    ChangerDoor = 5,
    ChangerKeypad = 6,
    ChangerMaxElement = 7,
}
pub use self::_ELEMENT_TYPE as ELEMENT_TYPE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _CHANGER_ELEMENT {
    pub ElementType: ELEMENT_TYPE,
    pub ElementAddress: DWORD,
}
pub type CHANGER_ELEMENT = _CHANGER_ELEMENT;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _CHANGER_ELEMENT_STATUS {
    pub Element: CHANGER_ELEMENT,
    pub SrcElementAddress: CHANGER_ELEMENT,
    pub Flags: DWORD,
    pub ExceptionCode: DWORD,
    pub TargetId: BYTE,
    pub Lun: BYTE,
    pub Reserved: WORD,
    pub PrimaryVolumeID: [BYTE; 36usize],
    pub AlternateVolumeID: [BYTE; 36usize],
}
pub type CHANGER_ELEMENT_STATUS = _CHANGER_ELEMENT_STATUS;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _READ_ELEMENT_ADDRESS_INFO {
    pub NumberOfElements: DWORD,
    pub ElementStatus: [CHANGER_ELEMENT_STATUS; 1usize],
}
pub type READ_ELEMENT_ADDRESS_INFO = _READ_ELEMENT_ADDRESS_INFO;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RETRIEVAL_POINTERS_BUFFER {
    pub ExtentCount: DWORD,
    pub StartingVcn: LARGE_INTEGER,
    pub Extents: [RETRIEVAL_POINTERS_BUFFER__bindgen_ty_1; 1usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RETRIEVAL_POINTERS_BUFFER__bindgen_ty_1 {
    pub NextVcn: LARGE_INTEGER,
    pub Lcn: LARGE_INTEGER,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct READ_USN_JOURNAL_DATA {
    pub StartUsn: USN,
    pub ReasonMask: DWORD,
    pub ReturnOnlyOnClose: DWORD,
    pub Timeout: DWORDLONG,
    pub BytesToWaitFor: DWORDLONG,
    pub UsnJournalID: DWORDLONG,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _REQUEST_RAW_ENCRYPTED_DATA {
    pub FileOffset: LONGLONG,
    pub Length: DWORD,
}
pub type REQUEST_RAW_ENCRYPTED_DATA = _REQUEST_RAW_ENCRYPTED_DATA;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _REQUEST_OPLOCK_INPUT_BUFFER {
    pub StructureVersion: WORD,
    pub StructureLength: WORD,
    pub RequestedOplockLevel: DWORD,
    pub Flags: DWORD,
}
pub type REQUEST_OPLOCK_INPUT_BUFFER = _REQUEST_OPLOCK_INPUT_BUFFER;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _REQUEST_OPLOCK_OUTPUT_BUFFER {
    pub StructureVersion: WORD,
    pub StructureLength: WORD,
    pub OriginalOplockLevel: DWORD,
    pub NewOplockLevel: DWORD,
    pub Flags: DWORD,
    pub AccessMode: ACCESS_MASK,
    pub ShareMode: WORD,
}
pub type REQUEST_OPLOCK_OUTPUT_BUFFER = _REQUEST_OPLOCK_OUTPUT_BUFFER;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _RETRIEVAL_POINTER_BASE {
    pub FileAreaOffset: LARGE_INTEGER,
}
pub type RETRIEVAL_POINTER_BASE = _RETRIEVAL_POINTER_BASE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagREGISTERWORDA {
    pub lpReading: LPSTR,
    pub lpWord: LPSTR,
}
pub type REGISTERWORDA = tagREGISTERWORDA;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagREGISTERWORDW {
    pub lpReading: LPWSTR,
    pub lpWord: LPWSTR,
}
pub type REGISTERWORDW = tagREGISTERWORDW;
pub type REGISTERWORD = REGISTERWORDA;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagRECONVERTSTRING {
    pub dwSize: DWORD,
    pub dwVersion: DWORD,
    pub dwStrLen: DWORD,
    pub dwStrOffset: DWORD,
    pub dwCompStrLen: DWORD,
    pub dwCompStrOffset: DWORD,
    pub dwTargetStrLen: DWORD,
    pub dwTargetStrOffset: DWORD,
}
pub type RECONVERTSTRING = tagRECONVERTSTRING;
pub type REGISTERWORDENUMPROCA = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: LPCSTR,
        arg2: DWORD,
        arg3: LPCSTR,
        arg4: LPVOID,
    ) -> ::std::os::raw::c_int,
>;
pub type REGISTERWORDENUMPROCW = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: LPCWSTR,
        arg2: DWORD,
        arg3: LPCWSTR,
        arg4: LPVOID,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: ::std::os::raw::c_long,
    pub tv_usec: ::std::os::raw::c_long,
}
pub type u_char = ::std::os::raw::c_uchar;
pub type u_short = ::std::os::raw::c_ushort;
pub type u_int = ::std::os::raw::c_uint;
pub type u_long = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in_addr {
    pub S_un: in_addr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union in_addr__bindgen_ty_1 {
    pub S_un_b: in_addr__bindgen_ty_1__bindgen_ty_1,
    pub S_un_w: in_addr__bindgen_ty_1__bindgen_ty_2,
    pub S_addr: u_long,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct in_addr__bindgen_ty_1__bindgen_ty_1 {
    pub s_b1: u_char,
    pub s_b2: u_char,
    pub s_b3: u_char,
    pub s_b4: u_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct in_addr__bindgen_ty_1__bindgen_ty_2 {
    pub s_w1: u_short,
    pub s_w2: u_short,
}
pub type SOCKET = UINT_PTR;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub fd_count: u_int,
    pub fd_array: [SOCKET; 64usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hostent {
    pub h_name: *mut ::std::os::raw::c_char,
    pub h_aliases: *mut *mut ::std::os::raw::c_char,
    pub h_addrtype: ::std::os::raw::c_short,
    pub h_length: ::std::os::raw::c_short,
    pub h_addr_list: *mut *mut ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct servent {
    pub s_name: *mut ::std::os::raw::c_char,
    pub s_aliases: *mut *mut ::std::os::raw::c_char,
    pub s_proto: *mut ::std::os::raw::c_char,
    pub s_port: ::std::os::raw::c_short,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct protoent {
    pub p_name: *mut ::std::os::raw::c_char,
    pub p_aliases: *mut *mut ::std::os::raw::c_char,
    pub p_proto: ::std::os::raw::c_short,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr {
    pub sa_family: u_short,
    pub sa_data: [::std::os::raw::c_char; 14usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in6_addr {
    pub u: in6_addr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union in6_addr__bindgen_ty_1 {
    pub Byte: [u_char; 16usize],
    pub Word: [u_short; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TRANSPORT_SETTING_ID {
    pub Guid: GUID,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum CONTROL_CHANNEL_TRIGGER_STATUS {
    CONTROL_CHANNEL_TRIGGER_STATUS_INVALID = 0,
    CONTROL_CHANNEL_TRIGGER_STATUS_SOFTWARE_SLOT_ALLOCATED = 1,
    CONTROL_CHANNEL_TRIGGER_STATUS_HARDWARE_SLOT_ALLOCATED = 2,
    CONTROL_CHANNEL_TRIGGER_STATUS_POLICY_ERROR = 3,
    CONTROL_CHANNEL_TRIGGER_STATUS_SYSTEM_ERROR = 4,
    CONTROL_CHANNEL_TRIGGER_STATUS_TRANSPORT_DISCONNECTED = 5,
    CONTROL_CHANNEL_TRIGGER_STATUS_SERVICE_UNAVAILABLE = 6,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _REAL_TIME_NOTIFICATION_SETTING_INPUT {
    pub TransportSettingId: TRANSPORT_SETTING_ID,
    pub BrokerEventGuid: GUID,
}
pub type REAL_TIME_NOTIFICATION_SETTING_INPUT = _REAL_TIME_NOTIFICATION_SETTING_INPUT;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _REAL_TIME_NOTIFICATION_SETTING_INPUT_EX {
    pub TransportSettingId: TRANSPORT_SETTING_ID,
    pub BrokerEventGuid: GUID,
    pub Unmark: BOOLEAN,
}
pub type REAL_TIME_NOTIFICATION_SETTING_INPUT_EX = _REAL_TIME_NOTIFICATION_SETTING_INPUT_EX;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _REAL_TIME_NOTIFICATION_SETTING_OUTPUT {
    pub ChannelStatus: CONTROL_CHANNEL_TRIGGER_STATUS,
}
pub type REAL_TIME_NOTIFICATION_SETTING_OUTPUT = _REAL_TIME_NOTIFICATION_SETTING_OUTPUT;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RCVALL_VALUE {
    RCVALL_OFF = 0,
    RCVALL_ON = 1,
    RCVALL_SOCKETLEVELONLY = 2,
    RCVALL_IPLEVEL = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RCVALL_IF {
    pub Mode: RCVALL_VALUE,
    pub Interface: ULONG,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum tagREADYSTATE {
    READYSTATE_UNINITIALIZED = 0,
    READYSTATE_LOADING = 1,
    READYSTATE_LOADED = 2,
    READYSTATE_INTERACTIVE = 3,
    READYSTATE_COMPLETE = 4,
}
pub use self::tagREADYSTATE as READYSTATE;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum tagIsolationState {
    isolationStateNotRestricted = 1,
    isolationStateInProbation = 2,
    isolationStateRestrictedAccess = 3,
}
pub use self::tagIsolationState as IsolationState;
pub type ProbationTime = FILETIME;
pub type RASIPV4ADDR = in_addr;
pub type RASIPV6ADDR = in6_addr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HRASCONN__ {
    pub unused: ::std::os::raw::c_int,
}
pub type HRASCONN = *mut HRASCONN__;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum tagRASCONNSTATE {
    RASCS_OpenPort = 0,
    RASCS_PortOpened = 1,
    RASCS_ConnectDevice = 2,
    RASCS_DeviceConnected = 3,
    RASCS_AllDevicesConnected = 4,
    RASCS_Authenticate = 5,
    RASCS_AuthNotify = 6,
    RASCS_AuthRetry = 7,
    RASCS_AuthCallback = 8,
    RASCS_AuthChangePassword = 9,
    RASCS_AuthProject = 10,
    RASCS_AuthLinkSpeed = 11,
    RASCS_AuthAck = 12,
    RASCS_ReAuthenticate = 13,
    RASCS_Authenticated = 14,
    RASCS_PrepareForCallback = 15,
    RASCS_WaitForModemReset = 16,
    RASCS_WaitForCallback = 17,
    RASCS_Projected = 18,
    RASCS_StartAuthentication = 19,
    RASCS_CallbackComplete = 20,
    RASCS_LogonNetwork = 21,
    RASCS_SubEntryConnected = 22,
    RASCS_SubEntryDisconnected = 23,
    RASCS_Interactive = 4096,
    RASCS_RetryAuthentication = 4097,
    RASCS_CallbackSetByCaller = 4098,
    RASCS_PasswordExpired = 4099,
    RASCS_InvokeEapUI = 4100,
    RASCS_Connected = 8192,
    RASCS_Disconnected = 8193,
}
pub type RASDIALFUNC =
    ::std::option::Option<unsafe extern "C" fn(arg1: UINT, arg2: tagRASCONNSTATE, arg3: DWORD)>;
pub type RASDIALFUNC1 = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: HRASCONN,
        arg2: UINT,
        arg3: tagRASCONNSTATE,
        arg4: DWORD,
        arg5: DWORD,
    ),
>;
pub type RASDIALFUNC2 = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: ULONG_PTR,
        arg2: DWORD,
        arg3: HRASCONN,
        arg4: UINT,
        arg5: tagRASCONNSTATE,
        arg6: DWORD,
        arg7: DWORD,
    ) -> DWORD,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RASCTRYINFO {
    pub dwSize: DWORD,
    pub dwCountryID: DWORD,
    pub dwNextCountryID: DWORD,
    pub dwCountryCode: DWORD,
    pub dwCountryNameOffset: DWORD,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RASIPADDR {
    pub a: BYTE,
    pub b: BYTE,
    pub c: BYTE,
    pub d: BYTE,
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct tagRASADPARAMS {
    pub dwSize: DWORD,
    pub hwndOwner: HWND,
    pub dwFlags: DWORD,
    pub xDlg: LONG,
    pub yDlg: LONG,
}
pub type RASADFUNCA = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: LPSTR,
        arg2: LPSTR,
        arg3: *mut tagRASADPARAMS,
        arg4: LPDWORD,
    ) -> WINBOOL,
>;
pub type RASADFUNCW = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: LPWSTR,
        arg2: LPWSTR,
        arg3: *mut tagRASADPARAMS,
        arg4: LPDWORD,
    ) -> WINBOOL,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RAS_STATS {
    pub dwSize: DWORD,
    pub dwBytesXmited: DWORD,
    pub dwBytesRcved: DWORD,
    pub dwFramesXmited: DWORD,
    pub dwFramesRcved: DWORD,
    pub dwCrcErr: DWORD,
    pub dwTimeoutErr: DWORD,
    pub dwAlignmentErr: DWORD,
    pub dwHardwareOverrunErr: DWORD,
    pub dwFramingErr: DWORD,
    pub dwBufferOverrunErr: DWORD,
    pub dwCompressionRatioIn: DWORD,
    pub dwCompressionRatioOut: DWORD,
    pub dwBps: DWORD,
    pub dwConnectDuration: DWORD,
}
pub type RAS_STATS = _RAS_STATS;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _tagRasNapState {
    pub dwSize: DWORD,
    pub dwFlags: DWORD,
    pub isolationState: IsolationState,
    pub probationTime: ProbationTime,
}
pub type RASNAPSTATE = _tagRasNapState;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RASPPPIPV6 {
    pub dwSize: DWORD,
    pub dwError: DWORD,
    pub bLocalInterfaceIdentifier: [BYTE; 8usize],
    pub bPeerInterfaceIdentifier: [BYTE; 8usize],
    pub bLocalCompressionProtocol: [BYTE; 2usize],
    pub bPeerCompressionProtocol: [BYTE; 2usize],
}
pub type RASPPPIPV6 = _RASPPPIPV6;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RASAPIVERSION {
    RASAPIVERSION_500 = 1,
    RASAPIVERSION_501 = 2,
    RASAPIVERSION_600 = 3,
    RASAPIVERSION_601 = 4,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _RASTUNNELENDPOINT {
    pub dwType: DWORD,
    pub __bindgen_anon_1: _RASTUNNELENDPOINT__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _RASTUNNELENDPOINT__bindgen_ty_1 {
    pub ipv4: RASIPV4ADDR,
    pub ipv6: RASIPV6ADDR,
}
pub type RASTUNNELENDPOINT = _RASTUNNELENDPOINT;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _RASUPDATECONN {
    pub version: RASAPIVERSION,
    pub dwSize: DWORD,
    pub dwFlags: DWORD,
    pub dwIfIndex: DWORD,
    pub localEndPoint: RASTUNNELENDPOINT,
    pub remoteEndPoint: RASTUNNELENDPOINT,
}
pub type RASUPDATECONN = _RASUPDATECONN;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _ROUTER_INTERFACE_TYPE {
    ROUTER_IF_TYPE_CLIENT = 0,
    ROUTER_IF_TYPE_HOME_ROUTER = 1,
    ROUTER_IF_TYPE_FULL_ROUTER = 2,
    ROUTER_IF_TYPE_DEDICATED = 3,
    ROUTER_IF_TYPE_INTERNAL = 4,
    ROUTER_IF_TYPE_LOOPBACK = 5,
    ROUTER_IF_TYPE_TUNNEL1 = 6,
    ROUTER_IF_TYPE_DIALOUT = 7,
}
pub use self::_ROUTER_INTERFACE_TYPE as ROUTER_INTERFACE_TYPE;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _ROUTER_CONNECTION_STATE {
    ROUTER_IF_STATE_UNREACHABLE = 0,
    ROUTER_IF_STATE_DISCONNECTED = 1,
    ROUTER_IF_STATE_CONNECTING = 2,
    ROUTER_IF_STATE_CONNECTED = 3,
}
pub use self::_ROUTER_CONNECTION_STATE as ROUTER_CONNECTION_STATE;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _RAS_PORT_CONDITION {
    RAS_PORT_NON_OPERATIONAL = 0,
    RAS_PORT_DISCONNECTED = 1,
    RAS_PORT_CALLING_BACK = 2,
    RAS_PORT_LISTENING = 3,
    RAS_PORT_AUTHENTICATING = 4,
    RAS_PORT_AUTHENTICATED = 5,
    RAS_PORT_INITIALIZING = 6,
}
pub use self::_RAS_PORT_CONDITION as RAS_PORT_CONDITION;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _RAS_HARDWARE_CONDITION {
    RAS_HARDWARE_OPERATIONAL = 0,
    RAS_HARDWARE_FAILURE = 1,
}
pub use self::_RAS_HARDWARE_CONDITION as RAS_HARDWARE_CONDITION;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RAS_PORT_0 {
    pub hPort: HANDLE,
    pub hConnection: HANDLE,
    pub dwPortCondition: RAS_PORT_CONDITION,
    pub dwTotalNumberOfCalls: DWORD,
    pub dwConnectDuration: DWORD,
    pub wszPortName: [WCHAR; 17usize],
    pub wszMediaName: [WCHAR; 17usize],
    pub wszDeviceName: [WCHAR; 129usize],
    pub wszDeviceType: [WCHAR; 17usize],
}
pub type RAS_PORT_0 = _RAS_PORT_0;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RAS_PORT_1 {
    pub hPort: HANDLE,
    pub hConnection: HANDLE,
    pub dwHardwareCondition: RAS_HARDWARE_CONDITION,
    pub dwLineSpeed: DWORD,
    pub dwBytesXmited: DWORD,
    pub dwBytesRcved: DWORD,
    pub dwFramesXmited: DWORD,
    pub dwFramesRcved: DWORD,
    pub dwCrcErr: DWORD,
    pub dwTimeoutErr: DWORD,
    pub dwAlignmentErr: DWORD,
    pub dwHardwareOverrunErr: DWORD,
    pub dwFramingErr: DWORD,
    pub dwBufferOverrunErr: DWORD,
    pub dwCompressionRatioIn: DWORD,
    pub dwCompressionRatioOut: DWORD,
}
pub type RAS_PORT_1 = _RAS_PORT_1;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _PPP_NBFCP_INFO {
    pub dwError: DWORD,
    pub wszWksta: [WCHAR; 17usize],
}
pub type PPP_NBFCP_INFO = _PPP_NBFCP_INFO;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _PPP_IPCP_INFO {
    pub dwError: DWORD,
    pub wszAddress: [WCHAR; 16usize],
    pub wszRemoteAddress: [WCHAR; 16usize],
}
pub type PPP_IPCP_INFO = _PPP_IPCP_INFO;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _PPP_IPCP_INFO2 {
    pub dwError: DWORD,
    pub wszAddress: [WCHAR; 16usize],
    pub wszRemoteAddress: [WCHAR; 16usize],
    pub dwOptions: DWORD,
    pub dwRemoteOptions: DWORD,
}
pub type PPP_IPCP_INFO2 = _PPP_IPCP_INFO2;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _PPP_IPXCP_INFO {
    pub dwError: DWORD,
    pub wszAddress: [WCHAR; 23usize],
}
pub type PPP_IPXCP_INFO = _PPP_IPXCP_INFO;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _PPP_ATCP_INFO {
    pub dwError: DWORD,
    pub wszAddress: [WCHAR; 33usize],
}
pub type PPP_ATCP_INFO = _PPP_ATCP_INFO;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _PPP_INFO {
    pub nbf: PPP_NBFCP_INFO,
    pub ip: PPP_IPCP_INFO,
    pub ipx: PPP_IPXCP_INFO,
    pub at: PPP_ATCP_INFO,
}
pub type PPP_INFO = _PPP_INFO;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _PPP_CCP_INFO {
    pub dwError: DWORD,
    pub dwCompressionAlgorithm: DWORD,
    pub dwOptions: DWORD,
    pub dwRemoteCompressionAlgorithm: DWORD,
    pub dwRemoteOptions: DWORD,
}
pub type PPP_CCP_INFO = _PPP_CCP_INFO;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _PPP_LCP_INFO {
    pub dwError: DWORD,
    pub dwAuthenticationProtocol: DWORD,
    pub dwAuthenticationData: DWORD,
    pub dwRemoteAuthenticationProtocol: DWORD,
    pub dwRemoteAuthenticationData: DWORD,
    pub dwTerminateReason: DWORD,
    pub dwRemoteTerminateReason: DWORD,
    pub dwOptions: DWORD,
    pub dwRemoteOptions: DWORD,
    pub dwEapTypeId: DWORD,
    pub dwRemoteEapTypeId: DWORD,
}
pub type PPP_LCP_INFO = _PPP_LCP_INFO;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _PPP_INFO_2 {
    pub nbf: PPP_NBFCP_INFO,
    pub ip: PPP_IPCP_INFO2,
    pub ipx: PPP_IPXCP_INFO,
    pub at: PPP_ATCP_INFO,
    pub ccp: PPP_CCP_INFO,
    pub lcp: PPP_LCP_INFO,
}
pub type PPP_INFO_2 = _PPP_INFO_2;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RAS_CONNECTION_0 {
    pub hConnection: HANDLE,
    pub hInterface: HANDLE,
    pub dwConnectDuration: DWORD,
    pub dwInterfaceType: ROUTER_INTERFACE_TYPE,
    pub dwConnectionFlags: DWORD,
    pub wszInterfaceName: [WCHAR; 257usize],
    pub wszUserName: [WCHAR; 257usize],
    pub wszLogonDomain: [WCHAR; 16usize],
    pub wszRemoteComputer: [WCHAR; 17usize],
}
pub type RAS_CONNECTION_0 = _RAS_CONNECTION_0;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RAS_CONNECTION_1 {
    pub hConnection: HANDLE,
    pub hInterface: HANDLE,
    pub PppInfo: PPP_INFO,
    pub dwBytesXmited: DWORD,
    pub dwBytesRcved: DWORD,
    pub dwFramesXmited: DWORD,
    pub dwFramesRcved: DWORD,
    pub dwCrcErr: DWORD,
    pub dwTimeoutErr: DWORD,
    pub dwAlignmentErr: DWORD,
    pub dwHardwareOverrunErr: DWORD,
    pub dwFramingErr: DWORD,
    pub dwBufferOverrunErr: DWORD,
    pub dwCompressionRatioIn: DWORD,
    pub dwCompressionRatioOut: DWORD,
}
pub type RAS_CONNECTION_1 = _RAS_CONNECTION_1;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RAS_CONNECTION_2 {
    pub hConnection: HANDLE,
    pub wszUserName: [WCHAR; 257usize],
    pub dwInterfaceType: ROUTER_INTERFACE_TYPE,
    pub guid: GUID,
    pub PppInfo2: PPP_INFO_2,
}
pub type RAS_CONNECTION_2 = _RAS_CONNECTION_2;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RAS_USER_0 {
    pub bfPrivilege: BYTE,
    pub wszPhoneNumber: [WCHAR; 129usize],
}
pub type RAS_USER_0 = _RAS_USER_0;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RAS_USER_1 {
    pub bfPrivilege: BYTE,
    pub wszPhoneNumber: [WCHAR; 129usize],
    pub bfPrivilege2: BYTE,
}
pub type RAS_USER_1 = _RAS_USER_1;
pub type RAS_SERVER_HANDLE = HANDLE;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _RAS_QUARANTINE_STATE {
    RAS_QUAR_STATE_NORMAL = 0,
    RAS_QUAR_STATE_QUARANTINE = 1,
    RAS_QUAR_STATE_PROBATION = 2,
    RAS_QUAR_STATE_NOT_CAPABLE = 3,
}
pub use self::_RAS_QUARANTINE_STATE as RAS_QUARANTINE_STATE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _PPP_IPV6CP_INFO {
    pub dwVersion: DWORD,
    pub dwSize: DWORD,
    pub dwError: DWORD,
    pub bInterfaceIdentifier: [BYTE; 8usize],
    pub bRemoteInterfaceIdentifier: [BYTE; 8usize],
    pub dwOptions: DWORD,
    pub dwRemoteOptions: DWORD,
    pub bPrefix: [BYTE; 8usize],
    pub dwPrefixLength: DWORD,
}
pub type PPP_IPV6_CP_INFO = _PPP_IPV6CP_INFO;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _PPP_INFO_3 {
    pub nbf: PPP_NBFCP_INFO,
    pub ip: PPP_IPCP_INFO2,
    pub ipv6: PPP_IPV6_CP_INFO,
    pub ccp: PPP_CCP_INFO,
    pub lcp: PPP_LCP_INFO,
}
pub type PPP_INFO_3 = _PPP_INFO_3;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RAS_CONNECTION_3 {
    pub dwVersion: DWORD,
    pub dwSize: DWORD,
    pub hConnection: HANDLE,
    pub wszUserName: [WCHAR; 257usize],
    pub dwInterfaceType: ROUTER_INTERFACE_TYPE,
    pub guid: GUID,
    pub PppInfo3: PPP_INFO_3,
    pub rasQuarState: RAS_QUARANTINE_STATE,
    pub timer: FILETIME,
}
pub type RAS_CONNECTION_3 = _RAS_CONNECTION_3;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _MPRAPI_OBJECT_HEADER {
    pub revision: UCHAR,
    pub type_: UCHAR,
    pub size: USHORT,
}
pub type MPRAPI_OBJECT_HEADER = _MPRAPI_OBJECT_HEADER;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _PPP_PROJECTION_INFO {
    pub dwIPv4NegotiationError: DWORD,
    pub wszAddress: [WCHAR; 16usize],
    pub wszRemoteAddress: [WCHAR; 16usize],
    pub dwIPv4Options: DWORD,
    pub dwIPv4RemoteOptions: DWORD,
    pub IPv4SubInterfaceIndex: ULONG64,
    pub dwIPv6NegotiationError: DWORD,
    pub bInterfaceIdentifier: [BYTE; 8usize],
    pub bRemoteInterfaceIdentifier: [BYTE; 8usize],
    pub bPrefix: [BYTE; 8usize],
    pub dwPrefixLength: DWORD,
    pub IPv6SubInterfaceIndex: ULONG64,
    pub dwLcpError: DWORD,
    pub dwAuthenticationProtocol: DWORD,
    pub dwAuthenticationData: DWORD,
    pub dwRemoteAuthenticationProtocol: DWORD,
    pub dwRemoteAuthenticationData: DWORD,
    pub dwLcpTerminateReason: DWORD,
    pub dwLcpRemoteTerminateReason: DWORD,
    pub dwLcpOptions: DWORD,
    pub dwLcpRemoteOptions: DWORD,
    pub dwEapTypeId: DWORD,
    pub dwRemoteEapTypeId: DWORD,
    pub dwCcpError: DWORD,
    pub dwCompressionAlgorithm: DWORD,
    pub dwCcpOptions: DWORD,
    pub dwRemoteCompressionAlgorithm: DWORD,
    pub dwCcpRemoteOptions: DWORD,
}
pub type PPP_PROJECTION_INFO = _PPP_PROJECTION_INFO;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IKEV2_PROJECTION_INFO {
    pub dwIPv4NegotiationError: DWORD,
    pub wszAddress: [WCHAR; 16usize],
    pub wszRemoteAddress: [WCHAR; 16usize],
    pub IPv4SubInterfaceIndex: ULONG64,
    pub dwIPv6NegotiationError: DWORD,
    pub bInterfaceIdentifier: [BYTE; 8usize],
    pub bRemoteInterfaceIdentifier: [BYTE; 8usize],
    pub bPrefix: [BYTE; 8usize],
    pub dwPrefixLength: DWORD,
    pub IPv6SubInterfaceIndex: ULONG64,
    pub dwOptions: DWORD,
    pub dwAuthenticationProtocol: DWORD,
    pub dwEapTypeId: DWORD,
    pub dwCompressionAlgorithm: DWORD,
    pub dwEncryptionMethod: DWORD,
}
pub type IKEV2_PROJECTION_INFO = _IKEV2_PROJECTION_INFO;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _PROJECTION_INFO {
    pub projectionInfoType: UCHAR,
    pub __bindgen_anon_1: _PROJECTION_INFO__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _PROJECTION_INFO__bindgen_ty_1 {
    pub Ikev2ProjectionInfo: IKEV2_PROJECTION_INFO,
    pub PppProjectionInfo: PPP_PROJECTION_INFO,
}
pub type PROJECTION_INFO = _PROJECTION_INFO;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _RAS_CONNECTION_EX {
    pub Header: MPRAPI_OBJECT_HEADER,
    pub dwConnectDuration: DWORD,
    pub dwInterfaceType: ROUTER_INTERFACE_TYPE,
    pub dwConnectionFlags: DWORD,
    pub wszInterfaceName: [WCHAR; 257usize],
    pub wszUserName: [WCHAR; 257usize],
    pub wszLogonDomain: [WCHAR; 16usize],
    pub wszRemoteComputer: [WCHAR; 17usize],
    pub guid: GUID,
    pub rasQuarState: RAS_QUARANTINE_STATE,
    pub probationTime: FILETIME,
    pub dwBytesXmited: DWORD,
    pub dwBytesRcved: DWORD,
    pub dwFramesXmited: DWORD,
    pub dwFramesRcved: DWORD,
    pub dwCrcErr: DWORD,
    pub dwTimeoutErr: DWORD,
    pub dwAlignmentErr: DWORD,
    pub dwHardwareOverrunErr: DWORD,
    pub dwFramingErr: DWORD,
    pub dwBufferOverrunErr: DWORD,
    pub dwCompressionRatioIn: DWORD,
    pub dwCompressionRatioOut: DWORD,
    pub dwNumSwitchOvers: DWORD,
    pub wszRemoteEndpointAddress: [WCHAR; 65usize],
    pub wszLocalEndpointAddress: [WCHAR; 65usize],
    pub ProjectionInfo: PROJECTION_INFO,
    pub hConnection: HANDLE,
    pub hInterface: HANDLE,
}
pub type RAS_CONNECTION_EX = _RAS_CONNECTION_EX;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RAS_UPDATE_CONNECTION {
    pub Header: MPRAPI_OBJECT_HEADER,
    pub dwIfIndex: DWORD,
    pub wszLocalEndpointAddress: [WCHAR; 65usize],
    pub wszRemoteEndpointAddress: [WCHAR; 65usize],
}
pub type RAS_UPDATE_CONNECTION = _RAS_UPDATE_CONNECTION;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct utimbuf {
    pub actime: time_t,
    pub modtime: time_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stati128 {
    pub st_dev: _dev_t,
    pub st_ino: ::std::os::raw::c_ulonglong,
    pub st_inohigh: ::std::os::raw::c_longlong,
    pub st_mode: ::std::os::raw::c_ushort,
    pub st_nlink: ::std::os::raw::c_short,
    pub st_uid: ::std::os::raw::c_short,
    pub st_gid: ::std::os::raw::c_short,
    pub st_rdev: _dev_t,
    pub st_size: ::std::os::raw::c_longlong,
    pub st_atime: __time64_t,
    pub st_atimensec: ::std::os::raw::c_long,
    pub st_mtime: __time64_t,
    pub st_mtimensec: ::std::os::raw::c_long,
    pub st_ctime: __time64_t,
    pub st_ctimensec: ::std::os::raw::c_long,
}
extern "C" {
    pub fn rb_w32_sysinit(
        arg1: *mut ::std::os::raw::c_int,
        arg2: *mut *mut *mut ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn rb_w32_osid() -> DWORD;
}
extern "C" {
    pub fn rb_w32_io_cancelable_p(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_is_socket(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_accept(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
        arg3: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_bind(
        arg1: ::std::os::raw::c_int,
        arg2: *const sockaddr,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_connect(
        arg1: ::std::os::raw::c_int,
        arg2: *const sockaddr,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_fdset(arg1: ::std::os::raw::c_int, arg2: *mut fd_set);
}
extern "C" {
    pub fn rb_w32_fdclr(arg1: ::std::os::raw::c_int, arg2: *mut fd_set);
}
extern "C" {
    pub fn rb_w32_fdisset(arg1: ::std::os::raw::c_int, arg2: *mut fd_set) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_select(
        arg1: ::std::os::raw::c_int,
        arg2: *mut fd_set,
        arg3: *mut fd_set,
        arg4: *mut fd_set,
        arg5: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_getpeername(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
        arg3: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_getsockname(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sockaddr,
        arg3: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_getsockopt(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_char,
        arg5: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_ioctlsocket(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_long,
        arg3: *mut u_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_listen(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_recv(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_recvfrom(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
        arg5: *mut sockaddr,
        arg6: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_send(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_sendto(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
        arg5: *const sockaddr,
        arg6: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_setsockopt(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
        arg5: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_shutdown(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_socket(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_get_osfhandle(arg1: ::std::os::raw::c_int) -> SOCKET;
}
extern "C" {
    pub fn rb_w32_gethostbyaddr(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> *mut hostent;
}
extern "C" {
    pub fn rb_w32_gethostbyname(arg1: *const ::std::os::raw::c_char) -> *mut hostent;
}
extern "C" {
    pub fn rb_w32_gethostname(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_getprotobyname(arg1: *const ::std::os::raw::c_char) -> *mut protoent;
}
extern "C" {
    pub fn rb_w32_getprotobynumber(arg1: ::std::os::raw::c_int) -> *mut protoent;
}
extern "C" {
    pub fn rb_w32_getservbyname(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut servent;
}
extern "C" {
    pub fn rb_w32_getservbyport(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut servent;
}
extern "C" {
    pub fn rb_w32_ugetcwd(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_w32_ugetenv(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_w32_urename(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_get_environ() -> *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_w32_free_environ(arg1: *mut *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn rb_w32_map_errno(arg1: DWORD) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_inet_ntop(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: *mut ::std::os::raw::c_char,
        arg4: size_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_w32_inet_pton(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_osver() -> DWORD;
}
extern "C" {
    pub fn rb_w32_uchown(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_ulink(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_ureadlink(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_char,
        arg3: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn rb_w32_wreadlink(arg1: *const WCHAR, arg2: *mut WCHAR, arg3: size_t) -> ssize_t;
}
extern "C" {
    pub fn rb_w32_usymlink(
        src: *const ::std::os::raw::c_char,
        link: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_uspawn(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    ) -> pid_t;
}
extern "C" {
    pub fn rb_w32_uaspawn(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const *mut ::std::os::raw::c_char,
    ) -> pid_t;
}
extern "C" {
    pub fn rb_w32_uaspawn_flags(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const *mut ::std::os::raw::c_char,
        arg4: DWORD,
    ) -> pid_t;
}
extern "C" {
    pub fn rb_w32_set_nonblock(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_getpid() -> pid_t;
}
extern "C" {
    pub fn rb_w32_getppid() -> pid_t;
}
extern "C" {
    pub fn rb_w32_isatty(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_uchdir(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_umkdir(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_urmdir(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_uunlink(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_uchmod(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_ustati128(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut stati128,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_ulstati128(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut stati128,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_uaccess(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_fd_is_text(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_w32_fstati128(
        arg1: ::std::os::raw::c_int,
        arg2: *mut stati128,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_dup2(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_ftruncate(
        fd: ::std::os::raw::c_int,
        length: ::std::os::raw::c_longlong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_truncate(
        path: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_longlong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_utruncate(
        path: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_longlong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_strerror(arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tms {
    pub tms_utime: ::std::os::raw::c_long,
    pub tms_stime: ::std::os::raw::c_long,
    pub tms_cutime: ::std::os::raw::c_long,
    pub tms_cstime: ::std::os::raw::c_long,
}
extern "C" {
    pub fn rb_w32_times(arg1: *mut tms) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_sleep(msec: ::std::os::raw::c_ulong) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_uopen(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_wopen(
        arg1: *const WCHAR,
        arg2: ::std::os::raw::c_int,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_close(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_fclose(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_pipe(arg1: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_read(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn rb_w32_write(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn rb_w32_lseek(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_longlong,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn rb_w32_uutime(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const utimbuf,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_uutimes(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_uutimensat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const timespec,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_write_console(arg1: usize, arg2: ::std::os::raw::c_int)
        -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rb_w32_Sleep(msec: ::std::os::raw::c_ulong) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_wait_events_blocking(
        events: *mut HANDLE,
        num: ::std::os::raw::c_int,
        timeout: DWORD,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_time_subtract(rest: *mut timeval, wait: *const timeval) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_wrap_io_handle(
        arg1: HANDLE,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_unwrap_io_handle(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_mbstr_to_wstr(
        arg1: UINT,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_long,
    ) -> *mut WCHAR;
}
extern "C" {
    pub fn rb_w32_wstr_to_mbstr(
        arg1: UINT,
        arg2: *const WCHAR,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_long,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_w32_getcwd(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_w32_getenv(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_w32_rename(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_open(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_mkdir(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_rmdir(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_unlink(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_utime(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const utimbuf,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_utimes(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_utimensat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const timespec,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_stati128(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut stati128,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_lstati128(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut stati128,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_access(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_w32_spawn(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    ) -> pid_t;
}
extern "C" {
    pub fn rb_w32_aspawn(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const *mut ::std::os::raw::c_char,
    ) -> pid_t;
}
extern "C" {
    pub fn rb_w32_aspawn_flags(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const *mut ::std::os::raw::c_char,
        arg4: DWORD,
    ) -> pid_t;
}
pub type asynchronous_func_t = ::std::option::Option<
    unsafe extern "C" fn(self_: usize, argc: ::std::os::raw::c_int, argv: *mut usize) -> usize,
>;
extern "C" {
    pub fn rb_w32_asynchronize(
        func: asynchronous_func_t,
        self_: usize,
        argc: ::std::os::raw::c_int,
        argv: *mut usize,
        intrval: usize,
    ) -> usize;
}
pub type VALUE = ::std::os::raw::c_ulonglong;
pub type ID = ::std::os::raw::c_ulonglong;
extern "C" {
    pub fn rb_class_new(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_mod_init_copy(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_singleton_class_clone(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_singleton_class_attached(arg1: VALUE, arg2: VALUE);
}
extern "C" {
    pub fn rb_check_inheritable(arg1: VALUE);
}
extern "C" {
    pub fn rb_define_class_id(arg1: ID, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_define_class_id_under(arg1: VALUE, arg2: ID, arg3: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_module_new() -> VALUE;
}
extern "C" {
    pub fn rb_define_module_id(arg1: ID) -> VALUE;
}
extern "C" {
    pub fn rb_define_module_id_under(arg1: VALUE, arg2: ID) -> VALUE;
}
extern "C" {
    pub fn rb_mod_included_modules(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_mod_include_p(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_mod_ancestors(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_class_instance_methods(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_class_public_instance_methods(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_class_protected_instance_methods(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_class_private_instance_methods(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_obj_singleton_methods(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_define_method_id(
        arg1: VALUE,
        arg2: ID,
        arg3: ::std::option::Option<unsafe extern "C" fn() -> VALUE>,
        arg4: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn rb_undef(arg1: VALUE, arg2: ID);
}
extern "C" {
    pub fn rb_define_protected_method(
        arg1: VALUE,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::option::Option<unsafe extern "C" fn() -> VALUE>,
        arg4: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn rb_define_private_method(
        arg1: VALUE,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::option::Option<unsafe extern "C" fn() -> VALUE>,
        arg4: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn rb_define_singleton_method(
        arg1: VALUE,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::option::Option<unsafe extern "C" fn() -> VALUE>,
        arg4: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn rb_singleton_class(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_sourceline() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_sourcefile() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_frame_method_id_and_class(idp: *mut ID, klassp: *mut VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_check_funcall(
        arg1: VALUE,
        arg2: ID,
        arg3: ::std::os::raw::c_int,
        arg4: *const VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_check_funcall_kw(
        arg1: VALUE,
        arg2: ID,
        arg3: ::std::os::raw::c_int,
        arg4: *const VALUE,
        arg5: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_remove_method(arg1: VALUE, arg2: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn rb_remove_method_id(arg1: VALUE, arg2: ID);
}
extern "C" {
    pub fn rb_eval_cmd_kw(arg1: VALUE, arg2: VALUE, arg3: ::std::os::raw::c_int) -> VALUE;
}
extern "C" {
    pub fn rb_apply(arg1: VALUE, arg2: ID, arg3: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_instance_eval(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_obj_instance_exec(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_mod_module_eval(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_mod_module_exec(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: VALUE,
    ) -> VALUE;
}
pub type rb_alloc_func_t = ::std::option::Option<unsafe extern "C" fn(arg1: VALUE) -> VALUE>;
extern "C" {
    pub fn rb_define_alloc_func(arg1: VALUE, arg2: rb_alloc_func_t);
}
extern "C" {
    pub fn rb_undef_alloc_func(arg1: VALUE);
}
extern "C" {
    pub fn rb_get_alloc_func(arg1: VALUE) -> rb_alloc_func_t;
}
extern "C" {
    pub fn rb_clear_constant_cache();
}
extern "C" {
    pub fn rb_clear_method_cache_by_class(arg1: VALUE);
}
extern "C" {
    pub fn rb_alias(arg1: VALUE, arg2: ID, arg3: ID);
}
extern "C" {
    pub fn rb_attr(
        arg1: VALUE,
        arg2: ID,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn rb_method_boundp(
        arg1: VALUE,
        arg2: ID,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_method_basic_definition_p(arg1: VALUE, arg2: ID) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_obj_respond_to(
        arg1: VALUE,
        arg2: ID,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_respond_to(arg1: VALUE, arg2: ID) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_f_notimplement(
        argc: ::std::os::raw::c_int,
        argv: *const VALUE,
        obj: VALUE,
        marker: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub static rb_f_notimplement_: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *const VALUE,
            arg3: VALUE,
            marker: VALUE,
        ) -> VALUE,
    >;
}
extern "C" {
    pub fn rb_backtrace();
}
extern "C" {
    pub fn rb_make_backtrace() -> VALUE;
}
extern "C" {
    pub fn rb_define_method(
        arg1: VALUE,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::option::Option<unsafe extern "C" fn() -> VALUE>,
        arg4: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn rb_define_module_function(
        arg1: VALUE,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::option::Option<unsafe extern "C" fn() -> VALUE>,
        arg4: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn rb_define_global_function(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::option::Option<unsafe extern "C" fn() -> VALUE>,
        arg3: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn rb_undef_method(arg1: VALUE, arg2: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn rb_define_alias(
        arg1: VALUE,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn rb_define_attr(
        arg1: VALUE,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn rb_int2big(i: isize) -> VALUE;
}
extern "C" {
    pub fn rb_int2inum(i: isize) -> VALUE;
}
extern "C" {
    pub fn rb_uint2big(i: usize) -> VALUE;
}
extern "C" {
    pub fn rb_uint2inum(i: usize) -> VALUE;
}
impl ruby_special_consts {
    pub const RUBY_SPECIAL_SHIFT: ruby_special_consts = ruby_special_consts::RUBY_Qnil;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ruby_special_consts {
    RUBY_Qfalse = 0,
    RUBY_Qtrue = 20,
    RUBY_Qnil = 8,
    RUBY_Qundef = 52,
    RUBY_IMMEDIATE_MASK = 7,
    RUBY_FIXNUM_FLAG = 1,
    RUBY_FLONUM_MASK = 3,
    RUBY_FLONUM_FLAG = 2,
    RUBY_SYMBOL_FLAG = 12,
}
extern "C" {
    pub fn rb_out_of_int(num: ::std::os::raw::c_longlong);
}
extern "C" {
    pub fn rb_num2long(num: VALUE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rb_num2ulong(num: VALUE) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn rb_num2int(arg1: VALUE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rb_fix2int(arg1: VALUE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rb_num2uint(arg1: VALUE) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn rb_fix2uint(arg1: VALUE) -> ::std::os::raw::c_ulong;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ruby_rvalue_flags {
    RVALUE_EMBED_LEN_MAX = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RBasic {
    pub flags: VALUE,
    pub klass: VALUE,
}
extern "C" {
    pub fn rb_obj_hide(obj: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_reveal(obj: VALUE, klass: VALUE) -> VALUE;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ruby_value_type {
    RUBY_T_NONE = 0,
    RUBY_T_OBJECT = 1,
    RUBY_T_CLASS = 2,
    RUBY_T_MODULE = 3,
    RUBY_T_FLOAT = 4,
    RUBY_T_STRING = 5,
    RUBY_T_REGEXP = 6,
    RUBY_T_ARRAY = 7,
    RUBY_T_HASH = 8,
    RUBY_T_STRUCT = 9,
    RUBY_T_BIGNUM = 10,
    RUBY_T_FILE = 11,
    RUBY_T_DATA = 12,
    RUBY_T_MATCH = 13,
    RUBY_T_COMPLEX = 14,
    RUBY_T_RATIONAL = 15,
    RUBY_T_NIL = 17,
    RUBY_T_TRUE = 18,
    RUBY_T_FALSE = 19,
    RUBY_T_SYMBOL = 20,
    RUBY_T_FIXNUM = 21,
    RUBY_T_UNDEF = 22,
    RUBY_T_IMEMO = 26,
    RUBY_T_NODE = 27,
    RUBY_T_ICLASS = 28,
    RUBY_T_ZOMBIE = 29,
    RUBY_T_MOVED = 30,
    RUBY_T_MASK = 31,
}
extern "C" {
    pub fn rb_check_type(obj: VALUE, t: ::std::os::raw::c_int);
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ruby_fl_ushift {
    RUBY_FL_USHIFT = 12,
}
impl ruby_fl_type {
    pub const RUBY_FL_PROMOTED0: ruby_fl_type = ruby_fl_type::RUBY_FL_WB_PROTECTED;
}
impl ruby_fl_type {
    pub const RUBY_FL_SHAREABLE: ruby_fl_type = ruby_fl_type::RUBY_FL_TAINT;
}
impl ruby_fl_type {
    pub const RUBY_FL_UNTRUSTED: ruby_fl_type = ruby_fl_type::RUBY_FL_TAINT;
}
impl ruby_fl_type {
    pub const RUBY_ELTS_SHARED: ruby_fl_type = ruby_fl_type::RUBY_FL_USER2;
}
impl ruby_fl_type {
    pub const RUBY_FL_SINGLETON: ruby_fl_type = ruby_fl_type::RUBY_FL_USER0;
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ruby_fl_type {
    RUBY_FL_WB_PROTECTED = 32,
    RUBY_FL_PROMOTED1 = 64,
    RUBY_FL_PROMOTED = 96,
    RUBY_FL_FINALIZE = 128,
    RUBY_FL_TAINT = 256,
    RUBY_FL_SEEN_OBJ_ID = 512,
    RUBY_FL_EXIVAR = 1024,
    RUBY_FL_FREEZE = 2048,
    RUBY_FL_USER0 = 4096,
    RUBY_FL_USER1 = 8192,
    RUBY_FL_USER2 = 16384,
    RUBY_FL_USER3 = 32768,
    RUBY_FL_USER4 = 65536,
    RUBY_FL_USER5 = 131072,
    RUBY_FL_USER6 = 262144,
    RUBY_FL_USER7 = 524288,
    RUBY_FL_USER8 = 1048576,
    RUBY_FL_USER9 = 2097152,
    RUBY_FL_USER10 = 4194304,
    RUBY_FL_USER11 = 8388608,
    RUBY_FL_USER12 = 16777216,
    RUBY_FL_USER13 = 33554432,
    RUBY_FL_USER14 = 67108864,
    RUBY_FL_USER15 = 134217728,
    RUBY_FL_USER16 = 268435456,
    RUBY_FL_USER17 = 536870912,
    RUBY_FL_USER18 = 1073741824,
    RUBY_FL_USER19 = -2147483648,
}
extern "C" {
    pub fn rb_obj_infect(victim: VALUE, carrier: VALUE);
}
extern "C" {
    pub fn rb_freeze_singleton_class(klass: VALUE);
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ruby_rstring_flags {
    RSTRING_NOEMBED = 8192,
    RSTRING_EMBED_LEN_MASK = 507904,
    RSTRING_FSTR = 536870912,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ruby_rstring_consts {
    RSTRING_EMBED_LEN_SHIFT = 14,
    RSTRING_EMBED_LEN_MAX = 23,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RString {
    pub basic: RBasic,
    pub as_: RString__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union RString__bindgen_ty_1 {
    pub heap: RString__bindgen_ty_1__bindgen_ty_1,
    pub ary: [::std::os::raw::c_char; 24usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RString__bindgen_ty_1__bindgen_ty_1 {
    pub len: ::std::os::raw::c_long,
    pub ptr: *mut ::std::os::raw::c_char,
    pub aux: RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union RString__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {
    pub capa: ::std::os::raw::c_long,
    pub shared: VALUE,
}
extern "C" {
    pub fn rb_str_to_str(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_string_value(arg1: *mut VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_string_value_ptr(arg1: *mut VALUE) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_string_value_cstr(arg1: *mut VALUE) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_str_export(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_export_locale(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_check_safe_str(arg1: VALUE);
}
extern "C" {
    pub fn rb_num2dbl(arg1: VALUE) -> f64;
}
extern "C" {
    pub fn rb_float_value(arg1: VALUE) -> f64;
}
extern "C" {
    pub fn rb_float_new(arg1: f64) -> VALUE;
}
extern "C" {
    pub fn rb_float_new_in_heap(arg1: f64) -> VALUE;
}
extern "C" {
    pub fn rb_ll2inum(arg1: ::std::os::raw::c_longlong) -> VALUE;
}
extern "C" {
    pub fn rb_ull2inum(arg1: ::std::os::raw::c_ulonglong) -> VALUE;
}
extern "C" {
    pub fn rb_num2ll(arg1: VALUE) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn rb_num2ull(arg1: VALUE) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn rb_num2short(arg1: VALUE) -> ::std::os::raw::c_short;
}
extern "C" {
    pub fn rb_num2ushort(arg1: VALUE) -> ::std::os::raw::c_ushort;
}
extern "C" {
    pub fn rb_fix2short(arg1: VALUE) -> ::std::os::raw::c_short;
}
extern "C" {
    pub fn rb_fix2ushort(arg1: VALUE) -> ::std::os::raw::c_ushort;
}
pub type st_data_t = ::std::os::raw::c_ulonglong;
pub type st_index_t = st_data_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_hash_type {
    pub compare: ::std::option::Option<
        unsafe extern "C" fn(arg1: st_data_t, arg2: st_data_t) -> ::std::os::raw::c_int,
    >,
    pub hash: ::std::option::Option<unsafe extern "C" fn(arg1: st_data_t) -> st_index_t>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_table_entry {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_table {
    pub entry_power: ::std::os::raw::c_uchar,
    pub bin_power: ::std::os::raw::c_uchar,
    pub size_ind: ::std::os::raw::c_uchar,
    pub rebuilds_num: ::std::os::raw::c_uint,
    pub type_: *const st_hash_type,
    pub num_entries: st_index_t,
    pub bins: *mut st_index_t,
    pub entries_start: st_index_t,
    pub entries_bound: st_index_t,
    pub entries: *mut st_table_entry,
}
extern "C" {
    pub fn rb_st_init_table(arg1: *const st_hash_type) -> *mut st_table;
}
extern "C" {
    pub fn rb_st_init_table_with_size(arg1: *const st_hash_type, arg2: st_index_t)
        -> *mut st_table;
}
extern "C" {
    pub fn rb_st_init_numtable() -> *mut st_table;
}
extern "C" {
    pub fn rb_st_init_numtable_with_size(arg1: st_index_t) -> *mut st_table;
}
extern "C" {
    pub fn rb_st_init_strtable() -> *mut st_table;
}
extern "C" {
    pub fn rb_st_init_strtable_with_size(arg1: st_index_t) -> *mut st_table;
}
extern "C" {
    pub fn rb_st_init_strcasetable() -> *mut st_table;
}
extern "C" {
    pub fn rb_st_init_strcasetable_with_size(arg1: st_index_t) -> *mut st_table;
}
extern "C" {
    pub fn rb_st_delete(
        arg1: *mut st_table,
        arg2: *mut st_data_t,
        arg3: *mut st_data_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_st_delete_safe(
        arg1: *mut st_table,
        arg2: *mut st_data_t,
        arg3: *mut st_data_t,
        arg4: st_data_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_st_shift(
        arg1: *mut st_table,
        arg2: *mut st_data_t,
        arg3: *mut st_data_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_st_insert(
        arg1: *mut st_table,
        arg2: st_data_t,
        arg3: st_data_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_st_insert2(
        arg1: *mut st_table,
        arg2: st_data_t,
        arg3: st_data_t,
        arg4: ::std::option::Option<unsafe extern "C" fn(arg1: st_data_t) -> st_data_t>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_st_lookup(
        arg1: *mut st_table,
        arg2: st_data_t,
        arg3: *mut st_data_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_st_get_key(
        arg1: *mut st_table,
        arg2: st_data_t,
        arg3: *mut st_data_t,
    ) -> ::std::os::raw::c_int;
}
pub type st_update_callback_func = ::std::option::Option<
    unsafe extern "C" fn(
        key: *mut st_data_t,
        value: *mut st_data_t,
        arg: st_data_t,
        existing: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn rb_st_update(
        table: *mut st_table,
        key: st_data_t,
        func: st_update_callback_func,
        arg: st_data_t,
    ) -> ::std::os::raw::c_int;
}
pub type st_foreach_callback_func = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: st_data_t,
        arg2: st_data_t,
        arg3: st_data_t,
    ) -> ::std::os::raw::c_int,
>;
pub type st_foreach_check_callback_func = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: st_data_t,
        arg2: st_data_t,
        arg3: st_data_t,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn rb_st_foreach_with_replace(
        tab: *mut st_table,
        func: st_foreach_check_callback_func,
        replace: st_update_callback_func,
        arg: st_data_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_st_foreach(
        arg1: *mut st_table,
        arg2: st_foreach_callback_func,
        arg3: st_data_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_st_foreach_check(
        arg1: *mut st_table,
        arg2: st_foreach_check_callback_func,
        arg3: st_data_t,
        arg4: st_data_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_st_keys(table: *mut st_table, keys: *mut st_data_t, size: st_index_t) -> st_index_t;
}
extern "C" {
    pub fn rb_st_keys_check(
        table: *mut st_table,
        keys: *mut st_data_t,
        size: st_index_t,
        never: st_data_t,
    ) -> st_index_t;
}
extern "C" {
    pub fn rb_st_values(
        table: *mut st_table,
        values: *mut st_data_t,
        size: st_index_t,
    ) -> st_index_t;
}
extern "C" {
    pub fn rb_st_values_check(
        table: *mut st_table,
        values: *mut st_data_t,
        size: st_index_t,
        never: st_data_t,
    ) -> st_index_t;
}
extern "C" {
    pub fn rb_st_add_direct(arg1: *mut st_table, arg2: st_data_t, arg3: st_data_t);
}
extern "C" {
    pub fn rb_st_free_table(arg1: *mut st_table);
}
extern "C" {
    pub fn rb_st_cleanup_safe(arg1: *mut st_table, arg2: st_data_t);
}
extern "C" {
    pub fn rb_st_clear(arg1: *mut st_table);
}
extern "C" {
    pub fn rb_st_copy(arg1: *mut st_table) -> *mut st_table;
}
extern "C" {
    pub fn rb_st_numcmp(arg1: st_data_t, arg2: st_data_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_st_numhash(arg1: st_data_t) -> st_index_t;
}
extern "C" {
    pub fn rb_st_locale_insensitive_strcasecmp(
        s1: *const ::std::os::raw::c_char,
        s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_st_locale_insensitive_strncasecmp(
        s1: *const ::std::os::raw::c_char,
        s2: *const ::std::os::raw::c_char,
        n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_st_memsize(arg1: *const st_table) -> size_t;
}
extern "C" {
    pub fn rb_st_hash(ptr: *const ::std::os::raw::c_void, len: size_t, h: st_index_t)
        -> st_index_t;
}
extern "C" {
    pub fn rb_st_hash_uint32(h: st_index_t, i: u32) -> st_index_t;
}
extern "C" {
    pub fn rb_st_hash_uint(h: st_index_t, i: st_index_t) -> st_index_t;
}
extern "C" {
    pub fn rb_st_hash_end(h: st_index_t) -> st_index_t;
}
extern "C" {
    pub fn rb_st_hash_start(h: st_index_t) -> st_index_t;
}
extern "C" {
    pub fn rb_hash_bulk_insert_into_st_table(
        arg1: ::std::os::raw::c_long,
        arg2: *const VALUE,
        arg3: VALUE,
    );
}
extern "C" {
    pub fn rb_gc_writebarrier(a: VALUE, b: VALUE);
}
extern "C" {
    pub fn rb_gc_writebarrier_unprotect(obj: VALUE);
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ruby_rarray_flags {
    RARRAY_EMBED_FLAG = 8192,
    RARRAY_EMBED_LEN_MASK = 98304,
    RARRAY_TRANSIENT_FLAG = 33554432,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ruby_rarray_consts {
    RARRAY_EMBED_LEN_SHIFT = 15,
    RARRAY_EMBED_LEN_MAX = 3,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RArray {
    pub basic: RBasic,
    pub as_: RArray__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union RArray__bindgen_ty_1 {
    pub heap: RArray__bindgen_ty_1__bindgen_ty_1,
    pub ary: [VALUE; 3usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RArray__bindgen_ty_1__bindgen_ty_1 {
    pub len: ::std::os::raw::c_long,
    pub aux: RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1,
    pub ptr: *const VALUE,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union RArray__bindgen_ty_1__bindgen_ty_1__bindgen_ty_1 {
    pub capa: ::std::os::raw::c_long,
    pub shared_root: VALUE,
}
extern "C" {
    pub fn rb_ary_ptr_use_start(ary: VALUE) -> *mut VALUE;
}
extern "C" {
    pub fn rb_ary_ptr_use_end(a: VALUE);
}
extern "C" {
    pub fn rb_ary_detransient(a: VALUE);
}
extern "C" {
    pub fn rb_big_sign(num: VALUE) -> ::std::os::raw::c_int;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ruby_rmodule_flags {
    RMODULE_IS_OVERLAID = 16384,
    RMODULE_IS_REFINEMENT = 32768,
    RMODULE_INCLUDED_INTO_REFINEMENT = 65536,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RClass {
    _unused: [u8; 0],
}
extern "C" {
    pub fn rb_class_get_superclass(arg1: VALUE) -> VALUE;
}
pub type RUBY_DATA_FUNC =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RData {
    pub basic: RBasic,
    pub dmark: RUBY_DATA_FUNC,
    pub dfree: RUBY_DATA_FUNC,
    pub data: *mut ::std::os::raw::c_void,
}
extern "C" {
    pub fn rb_data_object_wrap(
        klass: VALUE,
        datap: *mut ::std::os::raw::c_void,
        dmark: RUBY_DATA_FUNC,
        dfree: RUBY_DATA_FUNC,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_data_object_zalloc(
        klass: VALUE,
        size: size_t,
        dmark: RUBY_DATA_FUNC,
        dfree: RUBY_DATA_FUNC,
    ) -> VALUE;
}
extern "C" {
    pub static mut rb_cObject: VALUE;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_io_t {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RFile {
    pub basic: RBasic,
    pub fptr: *mut rb_io_t,
}
extern "C" {
    pub fn ruby_sysinit(
        argc: *mut ::std::os::raw::c_int,
        argv: *mut *mut *mut ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn ruby_init();
}
extern "C" {
    pub fn ruby_options(
        argc: ::std::os::raw::c_int,
        argv: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn ruby_executable_node(
        n: *mut ::std::os::raw::c_void,
        status: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ruby_run_node(n: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ruby_show_version();
}
extern "C" {
    pub fn ruby_show_copyright();
}
extern "C" {
    pub fn ruby_init_stack(arg1: *mut VALUE);
}
extern "C" {
    pub fn ruby_setup() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ruby_cleanup(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ruby_finalize();
}
extern "C" {
    pub fn ruby_stop(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn ruby_stack_check() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ruby_stack_length(arg1: *mut *mut VALUE) -> size_t;
}
extern "C" {
    pub fn ruby_exec_node(n: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ruby_script(name: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn ruby_set_script_name(name: VALUE);
}
extern "C" {
    pub fn ruby_prog_init();
}
extern "C" {
    pub fn ruby_set_argv(arg1: ::std::os::raw::c_int, arg2: *mut *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn ruby_process_options(
        arg1: ::std::os::raw::c_int,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn ruby_init_loadpath();
}
extern "C" {
    pub fn ruby_incpush(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn ruby_sig_finalize();
}
extern "C" {
    pub fn rb_disable_super();
}
extern "C" {
    pub fn rb_enable_super();
}
extern "C" {
    pub fn rb_hash_iter_lev();
}
extern "C" {
    pub fn rb_hash_ifnone();
}
extern "C" {
    pub fn rb_str_associate();
}
extern "C" {
    pub fn rb_str_associated();
}
extern "C" {
    pub fn rb_autoload(arg1: VALUE, arg2: ID, arg3: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn rb_clear_cache();
}
extern "C" {
    pub fn rb_frame_pop();
}
extern "C" {
    pub fn rb_frozen_class_p(arg1: VALUE);
}
extern "C" {
    pub fn rb_exec_end_proc();
}
extern "C" {
    pub fn rb_compile_error();
}
extern "C" {
    pub fn rb_compile_error_with_enc();
}
extern "C" {
    pub fn rb_compile_error_append();
}
extern "C" {
    pub fn rb_gc_call_finalizer_at_exit();
}
extern "C" {
    pub fn rb_trap_exit();
}
extern "C" {
    pub fn rb_struct_ptr();
}
extern "C" {
    pub fn rb_clear_trace_func();
}
extern "C" {
    pub fn rb_generic_ivar_table();
}
extern "C" {
    pub fn rb_mod_const_missing(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_size_num(hash: VALUE) -> size_t;
}
extern "C" {
    pub fn rb_hash_tbl(
        arg1: VALUE,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
    ) -> *mut st_table;
}
extern "C" {
    pub fn rb_hash_set_ifnone(hash: VALUE, ifnone: VALUE) -> VALUE;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ruby_robject_flags {
    ROBJECT_EMBED = 8192,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ruby_robject_consts {
    ROBJECT_EMBED_LEN_MAX = 3,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RObject {
    pub basic: RBasic,
    pub as_: RObject__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union RObject__bindgen_ty_1 {
    pub heap: RObject__bindgen_ty_1__bindgen_ty_1,
    pub ary: [VALUE; 3usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RObject__bindgen_ty_1__bindgen_ty_1 {
    pub numiv: u32,
    pub ivptr: *mut VALUE,
    pub iv_index_tbl: *mut st_table,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RRegexp {
    pub basic: RBasic,
    pub ptr: *mut re_pattern_buffer,
    pub src: VALUE,
    pub usecnt: ::std::os::raw::c_ulong,
}
extern "C" {
    pub fn rb_struct_size(s: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_struct_aref(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_struct_aset(arg1: VALUE, arg2: VALUE, arg3: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_errinfo() -> VALUE;
}
extern "C" {
    pub fn rb_set_errinfo(arg1: VALUE);
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rb_warning_category_t {
    RB_WARN_CATEGORY_NONE = 0,
    RB_WARN_CATEGORY_DEPRECATED = 1,
    RB_WARN_CATEGORY_EXPERIMENTAL = 2,
    RB_WARN_CATEGORY_ALL_BITS = 6,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rb_io_wait_readwrite {
    RB_IO_WAIT_READABLE = 0,
    RB_IO_WAIT_WRITABLE = 1,
}
extern "C" {
    pub fn rb_raise(arg1: VALUE, arg2: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn rb_fatal(arg1: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn rb_bug(arg1: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn rb_bug_errno(arg1: *const ::std::os::raw::c_char, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn rb_sys_fail(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn rb_sys_fail_str(arg1: VALUE);
}
extern "C" {
    pub fn rb_mod_sys_fail(arg1: VALUE, arg2: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn rb_mod_sys_fail_str(arg1: VALUE, arg2: VALUE);
}
extern "C" {
    pub fn rb_readwrite_sys_fail(arg1: rb_io_wait_readwrite, arg2: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn rb_iter_break();
}
extern "C" {
    pub fn rb_iter_break_value(arg1: VALUE);
}
extern "C" {
    pub fn rb_exit(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn rb_notimplement();
}
extern "C" {
    pub fn rb_syserr_new(arg1: ::std::os::raw::c_int, arg2: *const ::std::os::raw::c_char)
        -> VALUE;
}
extern "C" {
    pub fn rb_syserr_new_str(n: ::std::os::raw::c_int, arg: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_syserr_fail(arg1: ::std::os::raw::c_int, arg2: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn rb_syserr_fail_str(arg1: ::std::os::raw::c_int, arg2: VALUE);
}
extern "C" {
    pub fn rb_mod_syserr_fail(
        arg1: VALUE,
        arg2: ::std::os::raw::c_int,
        arg3: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn rb_mod_syserr_fail_str(arg1: VALUE, arg2: ::std::os::raw::c_int, arg3: VALUE);
}
extern "C" {
    pub fn rb_readwrite_syserr_fail(
        arg1: rb_io_wait_readwrite,
        arg2: ::std::os::raw::c_int,
        arg3: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn rb_unexpected_type(arg1: VALUE, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn rb_ruby_verbose_ptr() -> *mut VALUE;
}
extern "C" {
    pub fn rb_ruby_debug_ptr() -> *mut VALUE;
}
extern "C" {
    pub fn rb_warning(arg1: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn rb_category_warning(
        arg1: rb_warning_category_t,
        arg2: *const ::std::os::raw::c_char,
        ...
    );
}
extern "C" {
    pub fn rb_compile_warning(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *const ::std::os::raw::c_char,
        ...
    );
}
extern "C" {
    pub fn rb_category_compile_warn(
        arg1: rb_warning_category_t,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
        ...
    );
}
extern "C" {
    pub fn rb_sys_warning(arg1: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn rb_warn(arg1: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn rb_category_warn(arg1: rb_warning_category_t, arg2: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn rb_compile_warn(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *const ::std::os::raw::c_char,
        ...
    );
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rbimpl_typeddata_flags {
    RUBY_TYPED_FREE_IMMEDIATELY = 1,
    RUBY_TYPED_FROZEN_SHAREABLE = 256,
    RUBY_TYPED_WB_PROTECTED = 32,
    RUBY_TYPED_PROMOTED1 = 64,
}
pub type rb_data_type_t = rb_data_type_struct;
#[repr(C)]
#[derive(Debug)]
pub struct rb_data_type_struct {
    pub wrap_struct_name: *const ::std::os::raw::c_char,
    pub function: rb_data_type_struct__bindgen_ty_1,
    pub parent: *const rb_data_type_t,
    pub data: *mut ::std::os::raw::c_void,
    pub flags: VALUE,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_data_type_struct__bindgen_ty_1 {
    pub dmark: RUBY_DATA_FUNC,
    pub dfree: RUBY_DATA_FUNC,
    pub dsize:
        ::std::option::Option<unsafe extern "C" fn(arg1: *const ::std::os::raw::c_void) -> size_t>,
    pub dcompact: RUBY_DATA_FUNC,
    pub reserved: [*mut ::std::os::raw::c_void; 1usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RTypedData {
    pub basic: RBasic,
    pub type_: *const rb_data_type_t,
    pub typed_flag: VALUE,
    pub data: *mut ::std::os::raw::c_void,
}
extern "C" {
    pub fn rb_data_typed_object_wrap(
        klass: VALUE,
        datap: *mut ::std::os::raw::c_void,
        arg1: *const rb_data_type_t,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_data_typed_object_zalloc(
        klass: VALUE,
        size: size_t,
        type_: *const rb_data_type_t,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_typeddata_inherited_p(
        child: *const rb_data_type_t,
        parent: *const rb_data_type_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_typeddata_is_kind_of(
        obj: VALUE,
        data_type: *const rb_data_type_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_check_typeddata(
        obj: VALUE,
        data_type: *const rb_data_type_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn ruby_strtoul(
        str_: *const ::std::os::raw::c_char,
        endptr: *mut *mut ::std::os::raw::c_char,
        base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn rb_eval_string(arg1: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_eval_string_protect(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_eval_string_wrap(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_funcall(arg1: VALUE, arg2: ID, arg3: ::std::os::raw::c_int, ...) -> VALUE;
}
extern "C" {
    pub fn rb_funcallv(
        arg1: VALUE,
        arg2: ID,
        arg3: ::std::os::raw::c_int,
        arg4: *const VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_funcallv_kw(
        arg1: VALUE,
        arg2: ID,
        arg3: ::std::os::raw::c_int,
        arg4: *const VALUE,
        arg5: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_funcallv_public(
        arg1: VALUE,
        arg2: ID,
        arg3: ::std::os::raw::c_int,
        arg4: *const VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_funcallv_public_kw(
        arg1: VALUE,
        arg2: ID,
        arg3: ::std::os::raw::c_int,
        arg4: *const VALUE,
        arg5: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_funcall_passing_block(
        arg1: VALUE,
        arg2: ID,
        arg3: ::std::os::raw::c_int,
        arg4: *const VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_funcall_passing_block_kw(
        arg1: VALUE,
        arg2: ID,
        arg3: ::std::os::raw::c_int,
        arg4: *const VALUE,
        arg5: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_funcall_with_block(
        arg1: VALUE,
        arg2: ID,
        arg3: ::std::os::raw::c_int,
        arg4: *const VALUE,
        arg5: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_funcall_with_block_kw(
        arg1: VALUE,
        arg2: ID,
        arg3: ::std::os::raw::c_int,
        arg4: *const VALUE,
        arg5: VALUE,
        arg6: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_call_super(arg1: ::std::os::raw::c_int, arg2: *const VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_call_super_kw(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_current_receiver() -> VALUE;
}
extern "C" {
    pub fn rb_get_kwargs(
        keyword_hash: VALUE,
        table: *const ID,
        required: ::std::os::raw::c_int,
        optional: ::std::os::raw::c_int,
        arg1: *mut VALUE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_extract_keywords(orighash: *mut VALUE) -> VALUE;
}
pub type rb_event_flag_t = u32;
pub type rb_event_hook_func_t = ::std::option::Option<
    unsafe extern "C" fn(evflag: rb_event_flag_t, data: VALUE, self_: VALUE, mid: ID, klass: VALUE),
>;
extern "C" {
    pub fn rb_add_event_hook(func: rb_event_hook_func_t, events: rb_event_flag_t, data: VALUE);
}
extern "C" {
    pub fn rb_remove_event_hook(func: rb_event_hook_func_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_gc_register_address(valptr: *mut VALUE);
}
extern "C" {
    pub fn rb_global_variable(arg1: *mut VALUE);
}
extern "C" {
    pub fn rb_gc_unregister_address(valptr: *mut VALUE);
}
extern "C" {
    pub fn rb_gc_register_mark_object(object: VALUE);
}
pub type ruby_glob_func = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_char,
        arg2: VALUE,
        arg3: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn rb_glob(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_char,
                arg2: VALUE,
                arg3: *mut ::std::os::raw::c_void,
            ),
        >,
        arg3: VALUE,
    );
}
extern "C" {
    pub fn ruby_glob(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: ruby_glob_func,
        arg4: VALUE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ruby_brace_glob(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: ruby_glob_func,
        arg4: VALUE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut rb_mKernel: VALUE;
}
extern "C" {
    pub static mut rb_mComparable: VALUE;
}
extern "C" {
    pub static mut rb_mEnumerable: VALUE;
}
extern "C" {
    pub static mut rb_mErrno: VALUE;
}
extern "C" {
    pub static mut rb_mFileTest: VALUE;
}
extern "C" {
    pub static mut rb_mGC: VALUE;
}
extern "C" {
    pub static mut rb_mMath: VALUE;
}
extern "C" {
    pub static mut rb_mProcess: VALUE;
}
extern "C" {
    pub static mut rb_mWaitReadable: VALUE;
}
extern "C" {
    pub static mut rb_mWaitWritable: VALUE;
}
extern "C" {
    pub static mut rb_cBasicObject: VALUE;
}
extern "C" {
    pub static mut rb_cArray: VALUE;
}
extern "C" {
    pub static mut rb_cBinding: VALUE;
}
extern "C" {
    pub static mut rb_cClass: VALUE;
}
extern "C" {
    pub static mut rb_cDir: VALUE;
}
extern "C" {
    pub static mut rb_cEncoding: VALUE;
}
extern "C" {
    pub static mut rb_cEnumerator: VALUE;
}
extern "C" {
    pub static mut rb_cFalseClass: VALUE;
}
extern "C" {
    pub static mut rb_cFile: VALUE;
}
extern "C" {
    pub static mut rb_cComplex: VALUE;
}
extern "C" {
    pub static mut rb_cFloat: VALUE;
}
extern "C" {
    pub static mut rb_cHash: VALUE;
}
extern "C" {
    pub static mut rb_cIO: VALUE;
}
extern "C" {
    pub static mut rb_cInteger: VALUE;
}
extern "C" {
    pub static mut rb_cMatch: VALUE;
}
extern "C" {
    pub static mut rb_cMethod: VALUE;
}
extern "C" {
    pub static mut rb_cModule: VALUE;
}
extern "C" {
    pub static mut rb_cNameErrorMesg: VALUE;
}
extern "C" {
    pub static mut rb_cNilClass: VALUE;
}
extern "C" {
    pub static mut rb_cNumeric: VALUE;
}
extern "C" {
    pub static mut rb_cProc: VALUE;
}
extern "C" {
    pub static mut rb_cRandom: VALUE;
}
extern "C" {
    pub static mut rb_cRange: VALUE;
}
extern "C" {
    pub static mut rb_cRational: VALUE;
}
extern "C" {
    pub static mut rb_cRegexp: VALUE;
}
extern "C" {
    pub static mut rb_cStat: VALUE;
}
extern "C" {
    pub static mut rb_cString: VALUE;
}
extern "C" {
    pub static mut rb_cStruct: VALUE;
}
extern "C" {
    pub static mut rb_cSymbol: VALUE;
}
extern "C" {
    pub static mut rb_cThread: VALUE;
}
extern "C" {
    pub static mut rb_cTime: VALUE;
}
extern "C" {
    pub static mut rb_cTrueClass: VALUE;
}
extern "C" {
    pub static mut rb_cUnboundMethod: VALUE;
}
extern "C" {
    pub static mut rb_eException: VALUE;
}
extern "C" {
    pub static mut rb_eStandardError: VALUE;
}
extern "C" {
    pub static mut rb_eSystemExit: VALUE;
}
extern "C" {
    pub static mut rb_eInterrupt: VALUE;
}
extern "C" {
    pub static mut rb_eSignal: VALUE;
}
extern "C" {
    pub static mut rb_eFatal: VALUE;
}
extern "C" {
    pub static mut rb_eArgError: VALUE;
}
extern "C" {
    pub static mut rb_eEOFError: VALUE;
}
extern "C" {
    pub static mut rb_eIndexError: VALUE;
}
extern "C" {
    pub static mut rb_eStopIteration: VALUE;
}
extern "C" {
    pub static mut rb_eKeyError: VALUE;
}
extern "C" {
    pub static mut rb_eRangeError: VALUE;
}
extern "C" {
    pub static mut rb_eIOError: VALUE;
}
extern "C" {
    pub static mut rb_eRuntimeError: VALUE;
}
extern "C" {
    pub static mut rb_eFrozenError: VALUE;
}
extern "C" {
    pub static mut rb_eSecurityError: VALUE;
}
extern "C" {
    pub static mut rb_eSystemCallError: VALUE;
}
extern "C" {
    pub static mut rb_eThreadError: VALUE;
}
extern "C" {
    pub static mut rb_eTypeError: VALUE;
}
extern "C" {
    pub static mut rb_eZeroDivError: VALUE;
}
extern "C" {
    pub static mut rb_eNotImpError: VALUE;
}
extern "C" {
    pub static mut rb_eNoMemError: VALUE;
}
extern "C" {
    pub static mut rb_eNoMethodError: VALUE;
}
extern "C" {
    pub static mut rb_eFloatDomainError: VALUE;
}
extern "C" {
    pub static mut rb_eLocalJumpError: VALUE;
}
extern "C" {
    pub static mut rb_eSysStackError: VALUE;
}
extern "C" {
    pub static mut rb_eRegexpError: VALUE;
}
extern "C" {
    pub static mut rb_eEncodingError: VALUE;
}
extern "C" {
    pub static mut rb_eEncCompatError: VALUE;
}
extern "C" {
    pub static mut rb_eNoMatchingPatternError: VALUE;
}
extern "C" {
    pub static mut rb_eScriptError: VALUE;
}
extern "C" {
    pub static mut rb_eNameError: VALUE;
}
extern "C" {
    pub static mut rb_eSyntaxError: VALUE;
}
extern "C" {
    pub static mut rb_eLoadError: VALUE;
}
extern "C" {
    pub static mut rb_eMathDomainError: VALUE;
}
extern "C" {
    pub static mut rb_stdin: VALUE;
}
extern "C" {
    pub static mut rb_stdout: VALUE;
}
extern "C" {
    pub static mut rb_stderr: VALUE;
}
pub type rb_block_call_func = ::std::option::Option<
    unsafe extern "C" fn(
        yielded_arg: VALUE,
        callback_arg: VALUE,
        argc: ::std::os::raw::c_int,
        argv: *const VALUE,
        blockarg: VALUE,
    ) -> VALUE,
>;
pub type rb_block_call_func_t = rb_block_call_func;
extern "C" {
    pub fn rb_each(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_yield(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_yield_values(n: ::std::os::raw::c_int, ...) -> VALUE;
}
extern "C" {
    pub fn rb_yield_values2(n: ::std::os::raw::c_int, argv: *const VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_yield_values_kw(
        n: ::std::os::raw::c_int,
        argv: *const VALUE,
        kw_splat: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_yield_splat(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_yield_splat_kw(arg1: VALUE, arg2: ::std::os::raw::c_int) -> VALUE;
}
extern "C" {
    pub fn rb_yield_block(
        yielded_arg: VALUE,
        callback_arg: VALUE,
        argc: ::std::os::raw::c_int,
        argv: *const VALUE,
        blockarg: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_keyword_given_p() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_block_given_p() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_need_block();
}
extern "C" {
    pub fn rb_iterate(
        arg1: ::std::option::Option<unsafe extern "C" fn(arg1: VALUE) -> VALUE>,
        arg2: VALUE,
        arg3: rb_block_call_func_t,
        arg4: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_block_call(
        arg1: VALUE,
        arg2: ID,
        arg3: ::std::os::raw::c_int,
        arg4: *const VALUE,
        arg5: rb_block_call_func_t,
        arg6: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_block_call_kw(
        arg1: VALUE,
        arg2: ID,
        arg3: ::std::os::raw::c_int,
        arg4: *const VALUE,
        arg5: rb_block_call_func_t,
        arg6: VALUE,
        arg7: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_rescue(
        arg1: ::std::option::Option<unsafe extern "C" fn(arg1: VALUE) -> VALUE>,
        arg2: VALUE,
        arg3: ::std::option::Option<unsafe extern "C" fn(arg1: VALUE, arg2: VALUE) -> VALUE>,
        arg4: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_rescue2(
        arg1: ::std::option::Option<unsafe extern "C" fn(arg1: VALUE) -> VALUE>,
        arg2: VALUE,
        arg3: ::std::option::Option<unsafe extern "C" fn(arg1: VALUE, arg2: VALUE) -> VALUE>,
        arg4: VALUE,
        ...
    ) -> VALUE;
}
extern "C" {
    pub fn rb_vrescue2(
        arg1: ::std::option::Option<unsafe extern "C" fn(arg1: VALUE) -> VALUE>,
        arg2: VALUE,
        arg3: ::std::option::Option<unsafe extern "C" fn(arg1: VALUE, arg2: VALUE) -> VALUE>,
        arg4: VALUE,
        arg5: va_list,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_ensure(
        arg1: ::std::option::Option<unsafe extern "C" fn(arg1: VALUE) -> VALUE>,
        arg2: VALUE,
        arg3: ::std::option::Option<unsafe extern "C" fn(arg1: VALUE) -> VALUE>,
        arg4: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_catch(
        arg1: *const ::std::os::raw::c_char,
        arg2: rb_block_call_func_t,
        arg3: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_catch_obj(arg1: VALUE, arg2: rb_block_call_func_t, arg3: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_throw(arg1: *const ::std::os::raw::c_char, arg2: VALUE);
}
extern "C" {
    pub fn rb_throw_obj(arg1: VALUE, arg2: VALUE);
}
extern "C" {
    pub fn rb_alloc_tmp_buffer(
        store: *mut VALUE,
        len: ::std::os::raw::c_long,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn rb_alloc_tmp_buffer_with_count(
        store: *mut VALUE,
        len: size_t,
        count: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn rb_free_tmp_buffer(store: *mut VALUE);
}
extern "C" {
    pub fn ruby_malloc_size_overflow(arg1: size_t, arg2: size_t);
}
extern "C" {
    pub fn rb_define_class(arg1: *const ::std::os::raw::c_char, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_define_module(arg1: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_define_class_under(
        arg1: VALUE,
        arg2: *const ::std::os::raw::c_char,
        arg3: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_define_module_under(arg1: VALUE, arg2: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_include_module(arg1: VALUE, arg2: VALUE);
}
extern "C" {
    pub fn rb_extend_object(arg1: VALUE, arg2: VALUE);
}
extern "C" {
    pub fn rb_prepend_module(arg1: VALUE, arg2: VALUE);
}
extern "C" {
    pub fn rb_newobj() -> VALUE;
}
extern "C" {
    pub fn rb_newobj_of(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_setup(obj: VALUE, klass: VALUE, type_: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_class(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_copy_generic_ivar(arg1: VALUE, arg2: VALUE);
}
extern "C" {
    pub fn rb_mem_clear(arg1: *mut VALUE, arg2: ::std::os::raw::c_long);
}
extern "C" {
    pub fn rb_assoc_new(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_check_array_type(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_new() -> VALUE;
}
extern "C" {
    pub fn rb_ary_new_capa(capa: ::std::os::raw::c_long) -> VALUE;
}
extern "C" {
    pub fn rb_ary_new_from_args(n: ::std::os::raw::c_long, ...) -> VALUE;
}
extern "C" {
    pub fn rb_ary_new_from_values(n: ::std::os::raw::c_long, elts: *const VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_tmp_new(arg1: ::std::os::raw::c_long) -> VALUE;
}
extern "C" {
    pub fn rb_ary_free(arg1: VALUE);
}
extern "C" {
    pub fn rb_ary_modify(arg1: VALUE);
}
extern "C" {
    pub fn rb_ary_freeze(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_shared_with_p(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_aref(arg1: ::std::os::raw::c_int, arg2: *const VALUE, arg3: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_subseq(
        arg1: VALUE,
        arg2: ::std::os::raw::c_long,
        arg3: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_ary_store(arg1: VALUE, arg2: ::std::os::raw::c_long, arg3: VALUE);
}
extern "C" {
    pub fn rb_ary_dup(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_resurrect(ary: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_to_ary(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_to_s(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_cat(arg1: VALUE, arg2: *const VALUE, arg3: ::std::os::raw::c_long) -> VALUE;
}
extern "C" {
    pub fn rb_ary_push(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_pop(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_shift(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_unshift(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_entry(arg1: VALUE, arg2: ::std::os::raw::c_long) -> VALUE;
}
extern "C" {
    pub fn rb_ary_each(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_join(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_reverse(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_rotate(arg1: VALUE, arg2: ::std::os::raw::c_long) -> VALUE;
}
extern "C" {
    pub fn rb_ary_sort(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_sort_bang(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_delete(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_delete_at(arg1: VALUE, arg2: ::std::os::raw::c_long) -> VALUE;
}
extern "C" {
    pub fn rb_ary_clear(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_plus(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_concat(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_assoc(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_rassoc(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_includes(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_cmp(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ary_replace(copy: VALUE, orig: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_get_values_at(
        arg1: VALUE,
        arg2: ::std::os::raw::c_long,
        arg3: ::std::os::raw::c_int,
        arg4: *const VALUE,
        arg5: ::std::option::Option<
            unsafe extern "C" fn(arg1: VALUE, arg2: ::std::os::raw::c_long) -> VALUE,
        >,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_ary_resize(ary: VALUE, len: ::std::os::raw::c_long) -> VALUE;
}
extern "C" {
    pub fn rb_exc_new(
        arg1: VALUE,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_exc_new_cstr(arg1: VALUE, arg2: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_exc_new_str(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_loaderror(arg1: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn rb_loaderror_with_path(path: VALUE, arg1: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn rb_name_error(arg1: ID, arg2: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn rb_name_error_str(arg1: VALUE, arg2: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn rb_frozen_error_raise(arg1: VALUE, arg2: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn rb_invalid_str(arg1: *const ::std::os::raw::c_char, arg2: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn rb_error_frozen(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn rb_error_frozen_object(arg1: VALUE);
}
extern "C" {
    pub fn rb_error_untrusted(arg1: VALUE);
}
extern "C" {
    pub fn rb_check_frozen(arg1: VALUE);
}
extern "C" {
    pub fn rb_check_trusted(arg1: VALUE);
}
extern "C" {
    pub fn rb_check_copyable(obj: VALUE, orig: VALUE);
}
extern "C" {
    pub fn rb_error_arity(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn rb_st_foreach_safe(
        arg1: *mut st_table,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: st_data_t,
                arg2: st_data_t,
                arg3: st_data_t,
            ) -> ::std::os::raw::c_int,
        >,
        arg3: st_data_t,
    );
}
extern "C" {
    pub fn rb_check_hash_type(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_foreach(
        arg1: VALUE,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(arg1: VALUE, arg2: VALUE, arg3: VALUE) -> ::std::os::raw::c_int,
        >,
        arg3: VALUE,
    );
}
extern "C" {
    pub fn rb_hash(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_new() -> VALUE;
}
extern "C" {
    pub fn rb_hash_dup(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_freeze(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_aref(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_lookup(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_lookup2(arg1: VALUE, arg2: VALUE, arg3: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_fetch(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_aset(arg1: VALUE, arg2: VALUE, arg3: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_clear(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_delete_if(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_delete(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_bulk_insert(arg1: ::std::os::raw::c_long, arg2: *const VALUE, arg3: VALUE);
}
pub type rb_hash_update_func = ::std::option::Option<
    unsafe extern "C" fn(newkey: VALUE, oldkey: VALUE, value: VALUE) -> VALUE,
>;
extern "C" {
    pub fn rb_hash_update_by(hash1: VALUE, hash2: VALUE, func: rb_hash_update_func) -> VALUE;
}
extern "C" {
    pub fn rb_path_check(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_env_path_tainted() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_env_clear() -> VALUE;
}
extern "C" {
    pub fn rb_hash_size(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_hash_free(arg1: VALUE);
}
extern "C" {
    pub fn rb_block_proc() -> VALUE;
}
extern "C" {
    pub fn rb_block_lambda() -> VALUE;
}
extern "C" {
    pub fn rb_proc_new(arg1: rb_block_call_func_t, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_is_proc(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_proc_call(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_proc_call_kw(arg1: VALUE, arg2: VALUE, arg3: ::std::os::raw::c_int) -> VALUE;
}
extern "C" {
    pub fn rb_proc_call_with_block(
        arg1: VALUE,
        argc: ::std::os::raw::c_int,
        argv: *const VALUE,
        arg2: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_proc_call_with_block_kw(
        arg1: VALUE,
        argc: ::std::os::raw::c_int,
        argv: *const VALUE,
        arg2: VALUE,
        arg3: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_proc_arity(arg1: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_proc_lambda_p(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_binding_new() -> VALUE;
}
extern "C" {
    pub fn rb_obj_method(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_is_method(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_method_call(arg1: ::std::os::raw::c_int, arg2: *const VALUE, arg3: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_method_call_kw(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: VALUE,
        arg4: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_method_call_with_block(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: VALUE,
        arg4: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_method_call_with_block_kw(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: VALUE,
        arg4: VALUE,
        arg5: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_mod_method_arity(arg1: VALUE, arg2: ID) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_obj_method_arity(arg1: VALUE, arg2: ID) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_protect(
        arg1: ::std::option::Option<unsafe extern "C" fn(arg1: VALUE) -> VALUE>,
        arg2: VALUE,
        arg3: *mut ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_scan_args(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_scan_args_kw(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: *const VALUE,
        arg4: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_scan_args_bad_format(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn rb_scan_args_length_mismatch(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn rb_sym2id(arg1: VALUE) -> ID;
}
extern "C" {
    pub fn rb_id2sym(arg1: ID) -> VALUE;
}
extern "C" {
    pub fn rb_intern(arg1: *const ::std::os::raw::c_char) -> ID;
}
extern "C" {
    pub fn rb_intern2(arg1: *const ::std::os::raw::c_char, arg2: ::std::os::raw::c_long) -> ID;
}
extern "C" {
    pub fn rb_intern_str(str_: VALUE) -> ID;
}
extern "C" {
    pub fn rb_id2name(arg1: ID) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_check_id(arg1: *mut VALUE) -> ID;
}
extern "C" {
    pub fn rb_to_id(arg1: VALUE) -> ID;
}
extern "C" {
    pub fn rb_id2str(arg1: ID) -> VALUE;
}
extern "C" {
    pub fn rb_sym2str(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_to_symbol(name: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_check_symbol(namep: *mut VALUE) -> VALUE;
}
pub type rb_gvar_getter_t =
    ::std::option::Option<unsafe extern "C" fn(id: ID, data: *mut VALUE) -> VALUE>;
pub type rb_gvar_setter_t =
    ::std::option::Option<unsafe extern "C" fn(val: VALUE, id: ID, data: *mut VALUE)>;
pub type rb_gvar_marker_t = ::std::option::Option<unsafe extern "C" fn(var: *mut VALUE)>;
extern "C" {
    pub fn rb_gvar_undef_getter(id: ID, data: *mut VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_gvar_undef_setter(val: VALUE, id: ID, data: *mut VALUE);
}
extern "C" {
    pub fn rb_gvar_undef_marker(var: *mut VALUE);
}
extern "C" {
    pub fn rb_gvar_val_getter(id: ID, data: *mut VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_gvar_val_setter(val: VALUE, id: ID, data: *mut VALUE);
}
extern "C" {
    pub fn rb_gvar_val_marker(var: *mut VALUE);
}
extern "C" {
    pub fn rb_gvar_var_getter(id: ID, data: *mut VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_gvar_var_setter(val: VALUE, id: ID, data: *mut VALUE);
}
extern "C" {
    pub fn rb_gvar_var_marker(var: *mut VALUE);
}
extern "C" {
    pub fn rb_gvar_readonly_setter(arg1: VALUE, arg2: ID, arg3: *mut VALUE);
}
extern "C" {
    pub fn rb_define_variable(arg1: *const ::std::os::raw::c_char, arg2: *mut VALUE);
}
extern "C" {
    pub fn rb_define_virtual_variable(
        arg1: *const ::std::os::raw::c_char,
        arg2: rb_gvar_getter_t,
        arg3: rb_gvar_setter_t,
    );
}
extern "C" {
    pub fn rb_define_hooked_variable(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut VALUE,
        arg3: rb_gvar_getter_t,
        arg4: rb_gvar_setter_t,
    );
}
extern "C" {
    pub fn rb_define_readonly_variable(arg1: *const ::std::os::raw::c_char, arg2: *const VALUE);
}
extern "C" {
    pub fn rb_define_const(arg1: VALUE, arg2: *const ::std::os::raw::c_char, arg3: VALUE);
}
extern "C" {
    pub fn rb_define_global_const(arg1: *const ::std::os::raw::c_char, arg2: VALUE);
}
extern "C" {
    pub fn rb_gv_set(arg1: *const ::std::os::raw::c_char, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_gv_get(arg1: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_iv_get(arg1: VALUE, arg2: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_iv_set(arg1: VALUE, arg2: *const ::std::os::raw::c_char, arg3: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_get_path(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_get_path_no_checksafe(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_class2name(arg1: VALUE) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_obj_classname(arg1: VALUE) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_p(arg1: VALUE);
}
extern "C" {
    pub fn rb_equal(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_require(arg1: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_big_new(arg1: size_t, arg2: ::std::os::raw::c_int) -> VALUE;
}
extern "C" {
    pub fn rb_bigzero_p(x: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_big_clone(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_big_2comp(arg1: VALUE);
}
extern "C" {
    pub fn rb_big_norm(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_big_resize(big: VALUE, len: size_t);
}
extern "C" {
    pub fn rb_cstr_to_inum(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_str_to_inum(
        arg1: VALUE,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_cstr2inum(arg1: *const ::std::os::raw::c_char, arg2: ::std::os::raw::c_int) -> VALUE;
}
extern "C" {
    pub fn rb_str2inum(arg1: VALUE, arg2: ::std::os::raw::c_int) -> VALUE;
}
extern "C" {
    pub fn rb_big2str(arg1: VALUE, arg2: ::std::os::raw::c_int) -> VALUE;
}
extern "C" {
    pub fn rb_big2long(arg1: VALUE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rb_big2ulong(arg1: VALUE) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn rb_big2ll(arg1: VALUE) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn rb_big2ull(arg1: VALUE) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn rb_big_pack(
        val: VALUE,
        buf: *mut ::std::os::raw::c_ulong,
        num_longs: ::std::os::raw::c_long,
    );
}
extern "C" {
    pub fn rb_big_unpack(
        buf: *mut ::std::os::raw::c_ulong,
        num_longs: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_uv_to_utf8(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_dbl2big(arg1: f64) -> VALUE;
}
extern "C" {
    pub fn rb_big2dbl(arg1: VALUE) -> f64;
}
extern "C" {
    pub fn rb_big_cmp(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_big_eq(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_big_eql(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_big_plus(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_big_minus(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_big_mul(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_big_div(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_big_idiv(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_big_modulo(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_big_divmod(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_big_pow(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_big_and(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_big_or(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_big_xor(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_big_lshift(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_big_rshift(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_integer_pack(
        val: VALUE,
        words: *mut ::std::os::raw::c_void,
        numwords: size_t,
        wordsize: size_t,
        nails: size_t,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_integer_unpack(
        words: *const ::std::os::raw::c_void,
        numwords: size_t,
        wordsize: size_t,
        nails: size_t,
        flags: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_absint_size(val: VALUE, nlz_bits_ret: *mut ::std::os::raw::c_int) -> size_t;
}
extern "C" {
    pub fn rb_absint_numwords(
        val: VALUE,
        word_numbits: size_t,
        nlz_bits_ret: *mut size_t,
    ) -> size_t;
}
extern "C" {
    pub fn rb_absint_singlebit_p(val: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_cmpint(arg1: VALUE, arg2: VALUE, arg3: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_cmperr(arg1: VALUE, arg2: VALUE);
}
extern "C" {
    pub fn rb_complex_raw(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_complex_new(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_complex_new_polar(abs: VALUE, arg: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_complex_polar(abs: VALUE, arg: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_complex_real(z: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_complex_imag(z: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_complex_plus(x: VALUE, y: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_complex_minus(x: VALUE, y: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_complex_mul(x: VALUE, y: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_complex_div(x: VALUE, y: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_complex_uminus(z: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_complex_conjugate(z: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_complex_abs(z: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_complex_arg(z: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_complex_pow(base: VALUE, exp: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_dbl_complex_new(real: f64, imag: f64) -> VALUE;
}
extern "C" {
    pub fn rb_Complex(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_fiber_new(arg1: rb_block_call_func_t, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_fiber_new_kw(
        arg1: rb_block_call_func_t,
        arg2: VALUE,
        kw_splat: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_fiber_resume(fib: VALUE, argc: ::std::os::raw::c_int, argv: *const VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_fiber_resume_kw(
        fib: VALUE,
        argc: ::std::os::raw::c_int,
        argv: *const VALUE,
        kw_splat: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_fiber_yield(argc: ::std::os::raw::c_int, argv: *const VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_fiber_yield_kw(
        argc: ::std::os::raw::c_int,
        argv: *const VALUE,
        kw_splat: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_fiber_current() -> VALUE;
}
extern "C" {
    pub fn rb_fiber_alive_p(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_dir_getwd() -> VALUE;
}
extern "C" {
    pub fn rb_enum_values_pack(arg1: ::std::os::raw::c_int, arg2: *const VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_exc_raise(arg1: VALUE);
}
extern "C" {
    pub fn rb_exc_fatal(arg1: VALUE);
}
extern "C" {
    pub fn rb_f_exit(arg1: ::std::os::raw::c_int, arg2: *const VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_f_abort(arg1: ::std::os::raw::c_int, arg2: *const VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_interrupt();
}
extern "C" {
    pub fn rb_frame_this_func() -> ID;
}
extern "C" {
    pub fn rb_jump_tag(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn rb_obj_call_init(arg1: VALUE, arg2: ::std::os::raw::c_int, arg3: *const VALUE);
}
extern "C" {
    pub fn rb_obj_call_init_kw(
        arg1: VALUE,
        arg2: ::std::os::raw::c_int,
        arg3: *const VALUE,
        arg4: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn rb_frame_callee() -> ID;
}
extern "C" {
    pub fn rb_make_exception(arg1: ::std::os::raw::c_int, arg2: *const VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_set_end_proc(
        arg1: ::std::option::Option<unsafe extern "C" fn(arg1: VALUE)>,
        arg2: VALUE,
    );
}
pub type rb_enumerator_size_func =
    ::std::option::Option<unsafe extern "C" fn(arg1: VALUE, arg2: VALUE, arg3: VALUE) -> VALUE>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_arithmetic_sequence_components_t {
    pub begin: VALUE,
    pub end: VALUE,
    pub step: VALUE,
    pub exclude_end: ::std::os::raw::c_int,
}
extern "C" {
    pub fn rb_enumeratorize(
        arg1: VALUE,
        arg2: VALUE,
        arg3: ::std::os::raw::c_int,
        arg4: *const VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_enumeratorize_with_size(
        arg1: VALUE,
        arg2: VALUE,
        arg3: ::std::os::raw::c_int,
        arg4: *const VALUE,
        arg5: rb_enumerator_size_func,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_enumeratorize_with_size_kw(
        arg1: VALUE,
        arg2: VALUE,
        arg3: ::std::os::raw::c_int,
        arg4: *const VALUE,
        arg5: rb_enumerator_size_func,
        arg6: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_arithmetic_sequence_extract(
        arg1: VALUE,
        arg2: *mut rb_arithmetic_sequence_components_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_arithmetic_sequence_beg_len_step(
        arg1: VALUE,
        begp: *mut ::std::os::raw::c_long,
        lenp: *mut ::std::os::raw::c_long,
        stepp: *mut ::std::os::raw::c_long,
        len: ::std::os::raw::c_long,
        err: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_file_s_expand_path(arg1: ::std::os::raw::c_int, arg2: *const VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_file_expand_path(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_file_s_absolute_path(arg1: ::std::os::raw::c_int, arg2: *const VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_file_absolute_path(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_file_dirname(fname: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_find_file_ext(
        arg1: *mut VALUE,
        arg2: *const *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_find_file(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_file_directory_p(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_encode_ospath(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_is_absolute_path(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_memerror();
}
extern "C" {
    pub fn rb_during_gc() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_gc_mark_locations(arg1: *const VALUE, arg2: *const VALUE);
}
extern "C" {
    pub fn rb_mark_tbl(arg1: *mut st_table);
}
extern "C" {
    pub fn rb_mark_tbl_no_pin(arg1: *mut st_table);
}
extern "C" {
    pub fn rb_mark_set(arg1: *mut st_table);
}
extern "C" {
    pub fn rb_mark_hash(arg1: *mut st_table);
}
extern "C" {
    pub fn rb_gc_update_tbl_refs(ptr: *mut st_table);
}
extern "C" {
    pub fn rb_gc_mark_maybe(arg1: VALUE);
}
extern "C" {
    pub fn rb_gc_mark(arg1: VALUE);
}
extern "C" {
    pub fn rb_gc_mark_movable(arg1: VALUE);
}
extern "C" {
    pub fn rb_gc_location(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_gc_force_recycle(arg1: VALUE);
}
extern "C" {
    pub fn rb_gc();
}
extern "C" {
    pub fn rb_gc_copy_finalizer(arg1: VALUE, arg2: VALUE);
}
extern "C" {
    pub fn rb_gc_enable() -> VALUE;
}
extern "C" {
    pub fn rb_gc_disable() -> VALUE;
}
extern "C" {
    pub fn rb_gc_start() -> VALUE;
}
extern "C" {
    pub fn rb_define_finalizer(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_undefine_finalizer(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_gc_count() -> size_t;
}
extern "C" {
    pub fn rb_gc_stat(arg1: VALUE) -> size_t;
}
extern "C" {
    pub fn rb_gc_latest_gc_info(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_gc_adjust_memory_usage(arg1: ssize_t);
}
extern "C" {
    pub static mut rb_fs: VALUE;
}
extern "C" {
    pub static mut rb_output_fs: VALUE;
}
extern "C" {
    pub static mut rb_rs: VALUE;
}
extern "C" {
    pub static mut rb_default_rs: VALUE;
}
extern "C" {
    pub static mut rb_output_rs: VALUE;
}
extern "C" {
    pub fn rb_io_write(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_io_gets(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_io_getbyte(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_io_ungetc(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_io_ungetbyte(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_io_close(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_io_flush(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_io_eof(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_io_binmode(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_io_ascii8bit_binmode(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_io_addstr(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_io_printf(arg1: ::std::os::raw::c_int, arg2: *const VALUE, arg3: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_io_print(arg1: ::std::os::raw::c_int, arg2: *const VALUE, arg3: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_io_puts(arg1: ::std::os::raw::c_int, arg2: *const VALUE, arg3: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_io_fdopen(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: *const ::std::os::raw::c_char,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_io_get_io(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_file_open(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_file_open_str(arg1: VALUE, arg2: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_gets() -> VALUE;
}
extern "C" {
    pub fn rb_write_error(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn rb_write_error2(arg1: *const ::std::os::raw::c_char, arg2: ::std::os::raw::c_long);
}
extern "C" {
    pub fn rb_close_before_exec(
        lowfd: ::std::os::raw::c_int,
        maxhint: ::std::os::raw::c_int,
        noclose_fds: VALUE,
    );
}
extern "C" {
    pub fn rb_pipe(pipes: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_reserved_fd_p(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_cloexec_open(
        pathname: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
        mode: mode_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_cloexec_dup(oldfd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_cloexec_dup2(
        oldfd: ::std::os::raw::c_int,
        newfd: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_cloexec_pipe(fildes: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_cloexec_fcntl_dupfd(
        fd: ::std::os::raw::c_int,
        minfd: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_update_max_fd(fd: ::std::os::raw::c_int);
}
extern "C" {
    pub fn rb_fd_fix_cloexec(fd: ::std::os::raw::c_int);
}
extern "C" {
    pub fn rb_load(arg1: VALUE, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn rb_load_protect(
        arg1: VALUE,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn rb_provided(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_feature_provided(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_provide(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn rb_f_require(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_require_string(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ext_ractor_safe(flag: bool);
}
extern "C" {
    pub fn rb_marshal_dump(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_marshal_load(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_marshal_define_compat(
        newclass: VALUE,
        oldclass: VALUE,
        dumper: ::std::option::Option<unsafe extern "C" fn(arg1: VALUE) -> VALUE>,
        loader: ::std::option::Option<unsafe extern "C" fn(arg1: VALUE, arg2: VALUE) -> VALUE>,
    );
}
extern "C" {
    pub fn rb_num_zerodiv();
}
extern "C" {
    pub fn rb_num_coerce_bin(arg1: VALUE, arg2: VALUE, arg3: ID) -> VALUE;
}
extern "C" {
    pub fn rb_num_coerce_cmp(arg1: VALUE, arg2: VALUE, arg3: ID) -> VALUE;
}
extern "C" {
    pub fn rb_num_coerce_relop(arg1: VALUE, arg2: VALUE, arg3: ID) -> VALUE;
}
extern "C" {
    pub fn rb_num_coerce_bit(arg1: VALUE, arg2: VALUE, arg3: ID) -> VALUE;
}
extern "C" {
    pub fn rb_num2fix(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_fix2str(arg1: VALUE, arg2: ::std::os::raw::c_int) -> VALUE;
}
extern "C" {
    pub fn rb_dbl_cmp(arg1: f64, arg2: f64) -> VALUE;
}
extern "C" {
    pub fn rb_class_new_instance_pass_kw(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_class_new_instance(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_class_new_instance_kw(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: VALUE,
        arg4: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_eql(arg1: VALUE, arg2: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_any_to_s(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_inspect(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_is_instance_of(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_is_kind_of(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_alloc(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_clone(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_dup(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_init_copy(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_taint(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_tainted(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_untaint(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_untrust(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_untrusted(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_trust(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_freeze(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_frozen_p(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_id(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_memory_id(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_class_real(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_class_inherited_p(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_class_superclass(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_convert_type(
        arg1: VALUE,
        arg2: ::std::os::raw::c_int,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const ::std::os::raw::c_char,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_check_convert_type(
        arg1: VALUE,
        arg2: ::std::os::raw::c_int,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const ::std::os::raw::c_char,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_check_to_integer(arg1: VALUE, arg2: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_check_to_float(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_to_int(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_check_to_int(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_Integer(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_to_float(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_Float(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_String(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_Array(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_Hash(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_cstr_to_dbl(arg1: *const ::std::os::raw::c_char, arg2: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn rb_str_to_dbl(arg1: VALUE, arg2: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn rb_id_attrset(arg1: ID) -> ID;
}
extern "C" {
    pub fn rb_is_const_id(arg1: ID) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_is_global_id(arg1: ID) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_is_instance_id(arg1: ID) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_is_attrset_id(arg1: ID) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_is_class_id(arg1: ID) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_is_local_id(arg1: ID) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_is_junk_id(arg1: ID) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_symname_p(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_sym_interned_p(arg1: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_backref_get() -> VALUE;
}
extern "C" {
    pub fn rb_backref_set(arg1: VALUE);
}
extern "C" {
    pub fn rb_lastline_get() -> VALUE;
}
extern "C" {
    pub fn rb_lastline_set(arg1: VALUE);
}
extern "C" {
    pub fn rb_sym_all_symbols() -> VALUE;
}
extern "C" {
    pub fn rb_last_status_set(status: ::std::os::raw::c_int, pid: pid_t);
}
extern "C" {
    pub fn rb_last_status_get() -> VALUE;
}
extern "C" {
    pub fn rb_proc_exec(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_f_exec(arg1: ::std::os::raw::c_int, arg2: *const VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_waitpid(
        pid: pid_t,
        status: *mut ::std::os::raw::c_int,
        flags: ::std::os::raw::c_int,
    ) -> pid_t;
}
extern "C" {
    pub fn rb_syswait(pid: pid_t);
}
extern "C" {
    pub fn rb_spawn(arg1: ::std::os::raw::c_int, arg2: *const VALUE) -> pid_t;
}
extern "C" {
    pub fn rb_spawn_err(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: *mut ::std::os::raw::c_char,
        arg4: size_t,
    ) -> pid_t;
}
extern "C" {
    pub fn rb_proc_times(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_detach_process(pid: pid_t) -> VALUE;
}
extern "C" {
    pub fn rb_genrand_int32() -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn rb_genrand_real() -> f64;
}
extern "C" {
    pub fn rb_reset_random_seed();
}
extern "C" {
    pub fn rb_random_bytes(rnd: VALUE, n: ::std::os::raw::c_long) -> VALUE;
}
extern "C" {
    pub fn rb_random_int(rnd: VALUE, max: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_random_int32(rnd: VALUE) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn rb_random_real(rnd: VALUE) -> f64;
}
extern "C" {
    pub fn rb_random_ulong_limited(
        rnd: VALUE,
        limit: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn rb_genrand_ulong_limited(i: ::std::os::raw::c_ulong) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn rb_range_new(arg1: VALUE, arg2: VALUE, arg3: ::std::os::raw::c_int) -> VALUE;
}
extern "C" {
    pub fn rb_range_beg_len(
        arg1: VALUE,
        arg2: *mut ::std::os::raw::c_long,
        arg3: *mut ::std::os::raw::c_long,
        arg4: ::std::os::raw::c_long,
        arg5: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_range_values(
        range: VALUE,
        begp: *mut VALUE,
        endp: *mut VALUE,
        exclp: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_rational_raw(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_rational_new(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_Rational(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_rational_num(rat: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_rational_den(rat: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_flt_rationalize_with_prec(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_flt_rationalize(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_memcicmp(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_match_busy(arg1: VALUE);
}
extern "C" {
    pub fn rb_reg_nth_defined(arg1: ::std::os::raw::c_int, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_reg_nth_match(arg1: ::std::os::raw::c_int, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_reg_backref_number(match_: VALUE, backref: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_reg_last_match(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_reg_match_pre(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_reg_match_post(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_reg_match_last(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_reg_new_str(arg1: VALUE, arg2: ::std::os::raw::c_int) -> VALUE;
}
extern "C" {
    pub fn rb_reg_new(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_long,
        arg3: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_reg_alloc() -> VALUE;
}
extern "C" {
    pub fn rb_reg_init_str(re: VALUE, s: VALUE, options: ::std::os::raw::c_int) -> VALUE;
}
extern "C" {
    pub fn rb_reg_match(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_reg_match2(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_reg_options(arg1: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut rb_argv0: VALUE;
}
extern "C" {
    pub fn rb_get_argv() -> VALUE;
}
extern "C" {
    pub fn rb_load_file(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn rb_load_file_str(arg1: VALUE) -> *mut ::std::os::raw::c_void;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_fdset_t {
    pub capa: ::std::os::raw::c_int,
    pub fdset: *mut fd_set,
}
extern "C" {
    pub fn rb_fd_init(arg1: *mut rb_fdset_t);
}
extern "C" {
    pub fn rb_fd_term(arg1: *mut rb_fdset_t);
}
extern "C" {
    pub fn rb_fd_set(arg1: ::std::os::raw::c_int, arg2: *mut rb_fdset_t);
}
extern "C" {
    pub fn rb_w32_fd_copy(arg1: *mut rb_fdset_t, arg2: *const fd_set, arg3: ::std::os::raw::c_int);
}
extern "C" {
    pub fn rb_w32_fd_dup(dst: *mut rb_fdset_t, src: *const rb_fdset_t);
}
extern "C" {
    pub fn rb_thread_fd_select(
        arg1: ::std::os::raw::c_int,
        arg2: *mut rb_fdset_t,
        arg3: *mut rb_fdset_t,
        arg4: *mut rb_fdset_t,
        arg5: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_f_kill(arg1: ::std::os::raw::c_int, arg2: *const VALUE) -> VALUE;
}
extern "C" {
    pub fn ruby_signal_name(arg1: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn ruby_default_signal(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn rb_f_sprintf(arg1: ::std::os::raw::c_int, arg2: *const VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_sprintf(arg1: *const ::std::os::raw::c_char, ...) -> VALUE;
}
extern "C" {
    pub fn rb_vsprintf(arg1: *const ::std::os::raw::c_char, arg2: va_list) -> VALUE;
}
extern "C" {
    pub fn rb_str_catf(arg1: VALUE, arg2: *const ::std::os::raw::c_char, ...) -> VALUE;
}
extern "C" {
    pub fn rb_str_vcatf(arg1: VALUE, arg2: *const ::std::os::raw::c_char, arg3: va_list) -> VALUE;
}
extern "C" {
    pub fn rb_str_format(arg1: ::std::os::raw::c_int, arg2: *const VALUE, arg3: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_new(arg1: *const ::std::os::raw::c_char, arg2: ::std::os::raw::c_long) -> VALUE;
}
extern "C" {
    pub fn rb_str_new_cstr(arg1: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_str_new_shared(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_new_frozen(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_new_with_class(
        arg1: VALUE,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_tainted_str_new_cstr(arg1: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_tainted_str_new(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_external_str_new(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_external_str_new_cstr(arg1: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_locale_str_new(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_locale_str_new_cstr(arg1: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_filesystem_str_new(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_filesystem_str_new_cstr(arg1: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_str_buf_new(arg1: ::std::os::raw::c_long) -> VALUE;
}
extern "C" {
    pub fn rb_str_buf_new_cstr(arg1: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_str_buf_new2(arg1: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_str_tmp_new(arg1: ::std::os::raw::c_long) -> VALUE;
}
extern "C" {
    pub fn rb_usascii_str_new(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_usascii_str_new_cstr(arg1: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_utf8_str_new(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_utf8_str_new_cstr(arg1: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_str_new_static(
        ptr: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_usascii_str_new_static(
        ptr: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_utf8_str_new_static(
        ptr: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_str_to_interned_str(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_interned_str(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_interned_str_cstr(arg1: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_str_free(arg1: VALUE);
}
extern "C" {
    pub fn rb_str_shared_replace(arg1: VALUE, arg2: VALUE);
}
extern "C" {
    pub fn rb_str_buf_append(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_buf_cat(
        arg1: VALUE,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_str_buf_cat2(arg1: VALUE, arg2: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_str_buf_cat_ascii(arg1: VALUE, arg2: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_obj_as_string(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_check_string_type(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_must_asciicompat(arg1: VALUE);
}
extern "C" {
    pub fn rb_str_dup(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_resurrect(str_: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_locktmp(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_unlocktmp(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_dup_frozen(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_plus(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_times(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_sublen(arg1: VALUE, arg2: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rb_str_substr(
        arg1: VALUE,
        arg2: ::std::os::raw::c_long,
        arg3: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_str_subseq(
        arg1: VALUE,
        arg2: ::std::os::raw::c_long,
        arg3: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_str_subpos(
        arg1: VALUE,
        arg2: ::std::os::raw::c_long,
        arg3: *mut ::std::os::raw::c_long,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_str_modify(arg1: VALUE);
}
extern "C" {
    pub fn rb_str_modify_expand(arg1: VALUE, arg2: ::std::os::raw::c_long);
}
extern "C" {
    pub fn rb_str_freeze(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_set_len(arg1: VALUE, arg2: ::std::os::raw::c_long);
}
extern "C" {
    pub fn rb_str_resize(arg1: VALUE, arg2: ::std::os::raw::c_long) -> VALUE;
}
extern "C" {
    pub fn rb_str_cat(
        arg1: VALUE,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_long,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_str_cat_cstr(arg1: VALUE, arg2: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_str_cat2(arg1: VALUE, arg2: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_str_append(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_concat(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_memhash(
        ptr: *const ::std::os::raw::c_void,
        len: ::std::os::raw::c_long,
    ) -> st_index_t;
}
extern "C" {
    pub fn rb_hash_start(arg1: st_index_t) -> st_index_t;
}
extern "C" {
    pub fn rb_hash_uint32(arg1: st_index_t, arg2: u32) -> st_index_t;
}
extern "C" {
    pub fn rb_hash_uint(arg1: st_index_t, arg2: st_index_t) -> st_index_t;
}
extern "C" {
    pub fn rb_hash_end(arg1: st_index_t) -> st_index_t;
}
extern "C" {
    pub fn rb_str_hash(arg1: VALUE) -> st_index_t;
}
extern "C" {
    pub fn rb_str_hash_cmp(arg1: VALUE, arg2: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_str_comparable(arg1: VALUE, arg2: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_str_cmp(arg1: VALUE, arg2: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_str_equal(str1: VALUE, str2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_drop_bytes(arg1: VALUE, arg2: ::std::os::raw::c_long) -> VALUE;
}
extern "C" {
    pub fn rb_str_update(
        arg1: VALUE,
        arg2: ::std::os::raw::c_long,
        arg3: ::std::os::raw::c_long,
        arg4: VALUE,
    );
}
extern "C" {
    pub fn rb_str_replace(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_inspect(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_dump(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_split(arg1: VALUE, arg2: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_str_setter(val: VALUE, id: ID, data: *mut VALUE);
}
extern "C" {
    pub fn rb_str_intern(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_sym_to_s(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_strlen(arg1: VALUE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rb_str_length(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_offset(arg1: VALUE, arg2: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rb_str_capacity(arg1: VALUE) -> size_t;
}
extern "C" {
    pub fn rb_str_ellipsize(arg1: VALUE, arg2: ::std::os::raw::c_long) -> VALUE;
}
extern "C" {
    pub fn rb_str_scrub(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_str_succ(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_struct_new(arg1: VALUE, ...) -> VALUE;
}
extern "C" {
    pub fn rb_struct_define(arg1: *const ::std::os::raw::c_char, ...) -> VALUE;
}
extern "C" {
    pub fn rb_struct_define_under(arg1: VALUE, arg2: *const ::std::os::raw::c_char, ...) -> VALUE;
}
extern "C" {
    pub fn rb_struct_alloc(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_struct_initialize(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_struct_getmember(arg1: VALUE, arg2: ID) -> VALUE;
}
extern "C" {
    pub fn rb_struct_s_members(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_struct_members(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_struct_alloc_noinit(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_struct_define_without_accessor(
        arg1: *const ::std::os::raw::c_char,
        arg2: VALUE,
        arg3: rb_alloc_func_t,
        ...
    ) -> VALUE;
}
extern "C" {
    pub fn rb_struct_define_without_accessor_under(
        outer: VALUE,
        class_name: *const ::std::os::raw::c_char,
        super_: VALUE,
        alloc: rb_alloc_func_t,
        ...
    ) -> VALUE;
}
extern "C" {
    pub fn rb_thread_schedule();
}
extern "C" {
    pub fn rb_thread_wait_fd(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn rb_thread_fd_writable(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_thread_fd_close(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn rb_thread_alone() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_thread_sleep(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn rb_thread_sleep_forever();
}
extern "C" {
    pub fn rb_thread_sleep_deadly();
}
extern "C" {
    pub fn rb_thread_stop() -> VALUE;
}
extern "C" {
    pub fn rb_thread_wakeup(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_thread_wakeup_alive(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_thread_run(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_thread_kill(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_thread_create(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> VALUE,
        >,
        arg2: *mut ::std::os::raw::c_void,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_thread_wait_for(arg1: timeval);
}
extern "C" {
    pub fn rb_thread_current() -> VALUE;
}
extern "C" {
    pub fn rb_thread_main() -> VALUE;
}
extern "C" {
    pub fn rb_thread_local_aref(arg1: VALUE, arg2: ID) -> VALUE;
}
extern "C" {
    pub fn rb_thread_local_aset(arg1: VALUE, arg2: ID, arg3: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_thread_atfork();
}
extern "C" {
    pub fn rb_thread_atfork_before_exec();
}
extern "C" {
    pub fn rb_exec_recursive(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(arg1: VALUE, arg2: VALUE, arg3: ::std::os::raw::c_int) -> VALUE,
        >,
        arg2: VALUE,
        arg3: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_exec_recursive_paired(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(arg1: VALUE, arg2: VALUE, arg3: ::std::os::raw::c_int) -> VALUE,
        >,
        arg2: VALUE,
        arg3: VALUE,
        arg4: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_exec_recursive_outer(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(arg1: VALUE, arg2: VALUE, arg3: ::std::os::raw::c_int) -> VALUE,
        >,
        arg2: VALUE,
        arg3: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_exec_recursive_paired_outer(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(arg1: VALUE, arg2: VALUE, arg3: ::std::os::raw::c_int) -> VALUE,
        >,
        arg2: VALUE,
        arg3: VALUE,
        arg4: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_thread_check_ints();
}
extern "C" {
    pub fn rb_thread_interrupted(thval: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_mutex_new() -> VALUE;
}
extern "C" {
    pub fn rb_mutex_locked_p(mutex: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_mutex_trylock(mutex: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_mutex_lock(mutex: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_mutex_unlock(mutex: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_mutex_sleep(self_: VALUE, timeout: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_mutex_synchronize(
        mutex: VALUE,
        func: ::std::option::Option<unsafe extern "C" fn(arg: VALUE) -> VALUE>,
        arg: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_timespec_now(arg1: *mut timespec);
}
extern "C" {
    pub fn rb_time_new(arg1: time_t, arg2: ::std::os::raw::c_long) -> VALUE;
}
extern "C" {
    pub fn rb_time_nano_new(arg1: time_t, arg2: ::std::os::raw::c_long) -> VALUE;
}
extern "C" {
    pub fn rb_time_timespec_new(arg1: *const timespec, arg2: ::std::os::raw::c_int) -> VALUE;
}
extern "C" {
    pub fn rb_time_num_new(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_time_interval(num: VALUE) -> timeval;
}
extern "C" {
    pub fn rb_time_timeval(time: VALUE) -> timeval;
}
extern "C" {
    pub fn rb_time_timespec(time: VALUE) -> timespec;
}
extern "C" {
    pub fn rb_time_timespec_interval(num: VALUE) -> timespec;
}
extern "C" {
    pub fn rb_time_utc_offset(time: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_mod_name(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_class_path(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_class_path_cached(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_set_class_path(arg1: VALUE, arg2: VALUE, arg3: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn rb_set_class_path_string(arg1: VALUE, arg2: VALUE, arg3: VALUE);
}
extern "C" {
    pub fn rb_path_to_class(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_path2class(arg1: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_class_name(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_autoload_load(arg1: VALUE, arg2: ID) -> VALUE;
}
extern "C" {
    pub fn rb_autoload_p(arg1: VALUE, arg2: ID) -> VALUE;
}
extern "C" {
    pub fn rb_f_trace_var(arg1: ::std::os::raw::c_int, arg2: *const VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_f_untrace_var(arg1: ::std::os::raw::c_int, arg2: *const VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_f_global_variables() -> VALUE;
}
extern "C" {
    pub fn rb_alias_variable(arg1: ID, arg2: ID);
}
extern "C" {
    pub fn rb_free_generic_ivar(arg1: VALUE);
}
extern "C" {
    pub fn rb_ivar_get(arg1: VALUE, arg2: ID) -> VALUE;
}
extern "C" {
    pub fn rb_ivar_set(arg1: VALUE, arg2: ID, arg3: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_ivar_defined(arg1: VALUE, arg2: ID) -> VALUE;
}
extern "C" {
    pub fn rb_ivar_foreach(
        arg1: VALUE,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(arg1: ID, arg2: VALUE, arg3: st_data_t) -> ::std::os::raw::c_int,
        >,
        arg3: st_data_t,
    );
}
extern "C" {
    pub fn rb_ivar_count(arg1: VALUE) -> st_index_t;
}
extern "C" {
    pub fn rb_attr_get(arg1: VALUE, arg2: ID) -> VALUE;
}
extern "C" {
    pub fn rb_obj_instance_variables(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_obj_remove_instance_variable(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_mod_const_at(
        arg1: VALUE,
        arg2: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn rb_mod_const_of(
        arg1: VALUE,
        arg2: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn rb_const_list(arg1: *mut ::std::os::raw::c_void) -> VALUE;
}
extern "C" {
    pub fn rb_mod_constants(arg1: ::std::os::raw::c_int, arg2: *const VALUE, arg3: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_mod_remove_const(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_const_defined(arg1: VALUE, arg2: ID) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_const_defined_at(arg1: VALUE, arg2: ID) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_const_defined_from(arg1: VALUE, arg2: ID) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_const_get(arg1: VALUE, arg2: ID) -> VALUE;
}
extern "C" {
    pub fn rb_const_get_at(arg1: VALUE, arg2: ID) -> VALUE;
}
extern "C" {
    pub fn rb_const_get_from(arg1: VALUE, arg2: ID) -> VALUE;
}
extern "C" {
    pub fn rb_const_set(arg1: VALUE, arg2: ID, arg3: VALUE);
}
extern "C" {
    pub fn rb_const_remove(arg1: VALUE, arg2: ID) -> VALUE;
}
extern "C" {
    pub fn rb_cvar_defined(arg1: VALUE, arg2: ID) -> VALUE;
}
extern "C" {
    pub fn rb_cvar_set(arg1: VALUE, arg2: ID, arg3: VALUE);
}
extern "C" {
    pub fn rb_cvar_get(arg1: VALUE, arg2: ID) -> VALUE;
}
extern "C" {
    pub fn rb_cv_set(arg1: VALUE, arg2: *const ::std::os::raw::c_char, arg3: VALUE);
}
extern "C" {
    pub fn rb_cv_get(arg1: VALUE, arg2: *const ::std::os::raw::c_char) -> VALUE;
}
extern "C" {
    pub fn rb_define_class_variable(arg1: VALUE, arg2: *const ::std::os::raw::c_char, arg3: VALUE);
}
extern "C" {
    pub fn rb_mod_class_variables(
        arg1: ::std::os::raw::c_int,
        arg2: *const VALUE,
        arg3: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_mod_remove_cvar(arg1: VALUE, arg2: VALUE) -> VALUE;
}
extern "C" {
    pub fn ruby_native_thread_p() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ruby_snprintf(
        str_: *mut ::std::os::raw::c_char,
        n: size_t,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ruby_vsnprintf(
        str_: *mut ::std::os::raw::c_char,
        n: size_t,
        fmt: *const ::std::os::raw::c_char,
        ap: va_list,
    ) -> ::std::os::raw::c_int;
}
pub type OnigUChar = ::std::os::raw::c_uchar;
pub type OnigCodePoint = ::std::os::raw::c_uint;
pub type OnigCtype = ::std::os::raw::c_uint;
pub type OnigDistance = size_t;
pub type OnigCaseFoldType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnigCaseFoldCodeItem {
    pub byte_len: ::std::os::raw::c_int,
    pub code_len: ::std::os::raw::c_int,
    pub code: [OnigCodePoint; 3usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnigMetaCharTableType {
    pub esc: OnigCodePoint,
    pub anychar: OnigCodePoint,
    pub anytime: OnigCodePoint,
    pub zero_or_one_time: OnigCodePoint,
    pub one_or_more_time: OnigCodePoint,
    pub anychar_anytime: OnigCodePoint,
}
pub type OnigApplyAllCaseFoldFunc = ::std::option::Option<
    unsafe extern "C" fn(
        from: OnigCodePoint,
        to: *mut OnigCodePoint,
        to_len: ::std::os::raw::c_int,
        arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnigEncodingTypeST {
    pub precise_mbc_enc_len: ::std::option::Option<
        unsafe extern "C" fn(
            p: *const OnigUChar,
            e: *const OnigUChar,
            enc: *const OnigEncodingTypeST,
        ) -> ::std::os::raw::c_int,
    >,
    pub name: *const ::std::os::raw::c_char,
    pub max_enc_len: ::std::os::raw::c_int,
    pub min_enc_len: ::std::os::raw::c_int,
    pub is_mbc_newline: ::std::option::Option<
        unsafe extern "C" fn(
            p: *const OnigUChar,
            end: *const OnigUChar,
            enc: *const OnigEncodingTypeST,
        ) -> ::std::os::raw::c_int,
    >,
    pub mbc_to_code: ::std::option::Option<
        unsafe extern "C" fn(
            p: *const OnigUChar,
            end: *const OnigUChar,
            enc: *const OnigEncodingTypeST,
        ) -> OnigCodePoint,
    >,
    pub code_to_mbclen: ::std::option::Option<
        unsafe extern "C" fn(
            code: OnigCodePoint,
            enc: *const OnigEncodingTypeST,
        ) -> ::std::os::raw::c_int,
    >,
    pub code_to_mbc: ::std::option::Option<
        unsafe extern "C" fn(
            code: OnigCodePoint,
            buf: *mut OnigUChar,
            enc: *const OnigEncodingTypeST,
        ) -> ::std::os::raw::c_int,
    >,
    pub mbc_case_fold: ::std::option::Option<
        unsafe extern "C" fn(
            flag: OnigCaseFoldType,
            pp: *mut *const OnigUChar,
            end: *const OnigUChar,
            to: *mut OnigUChar,
            enc: *const OnigEncodingTypeST,
        ) -> ::std::os::raw::c_int,
    >,
    pub apply_all_case_fold: ::std::option::Option<
        unsafe extern "C" fn(
            flag: OnigCaseFoldType,
            f: OnigApplyAllCaseFoldFunc,
            arg: *mut ::std::os::raw::c_void,
            enc: *const OnigEncodingTypeST,
        ) -> ::std::os::raw::c_int,
    >,
    pub get_case_fold_codes_by_str: ::std::option::Option<
        unsafe extern "C" fn(
            flag: OnigCaseFoldType,
            p: *const OnigUChar,
            end: *const OnigUChar,
            acs: *mut OnigCaseFoldCodeItem,
            enc: *const OnigEncodingTypeST,
        ) -> ::std::os::raw::c_int,
    >,
    pub property_name_to_ctype: ::std::option::Option<
        unsafe extern "C" fn(
            enc: *const OnigEncodingTypeST,
            p: *const OnigUChar,
            end: *const OnigUChar,
        ) -> ::std::os::raw::c_int,
    >,
    pub is_code_ctype: ::std::option::Option<
        unsafe extern "C" fn(
            code: OnigCodePoint,
            ctype: OnigCtype,
            enc: *const OnigEncodingTypeST,
        ) -> ::std::os::raw::c_int,
    >,
    pub get_ctype_code_range: ::std::option::Option<
        unsafe extern "C" fn(
            ctype: OnigCtype,
            sb_out: *mut OnigCodePoint,
            ranges: *mut *const OnigCodePoint,
            enc: *const OnigEncodingTypeST,
        ) -> ::std::os::raw::c_int,
    >,
    pub left_adjust_char_head: ::std::option::Option<
        unsafe extern "C" fn(
            start: *const OnigUChar,
            p: *const OnigUChar,
            end: *const OnigUChar,
            enc: *const OnigEncodingTypeST,
        ) -> *mut OnigUChar,
    >,
    pub is_allowed_reverse_match: ::std::option::Option<
        unsafe extern "C" fn(
            p: *const OnigUChar,
            end: *const OnigUChar,
            enc: *const OnigEncodingTypeST,
        ) -> ::std::os::raw::c_int,
    >,
    pub case_map: ::std::option::Option<
        unsafe extern "C" fn(
            flagP: *mut OnigCaseFoldType,
            pp: *mut *const OnigUChar,
            end: *const OnigUChar,
            to: *mut OnigUChar,
            to_end: *mut OnigUChar,
            enc: *const OnigEncodingTypeST,
        ) -> ::std::os::raw::c_int,
    >,
    pub ruby_encoding_index: ::std::os::raw::c_int,
    pub flags: ::std::os::raw::c_uint,
}
pub type OnigEncodingType = OnigEncodingTypeST;
pub type OnigEncoding = *const OnigEncodingType;
pub type OnigOptionType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnigSyntaxType {
    pub op: ::std::os::raw::c_uint,
    pub op2: ::std::os::raw::c_uint,
    pub behavior: ::std::os::raw::c_uint,
    pub options: OnigOptionType,
    pub meta_char_table: OnigMetaCharTableType,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnigRepeatRange {
    pub lower: ::std::os::raw::c_int,
    pub upper: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct re_pattern_buffer {
    pub p: *mut ::std::os::raw::c_uchar,
    pub used: ::std::os::raw::c_uint,
    pub alloc: ::std::os::raw::c_uint,
    pub num_mem: ::std::os::raw::c_int,
    pub num_repeat: ::std::os::raw::c_int,
    pub num_null_check: ::std::os::raw::c_int,
    pub num_comb_exp_check: ::std::os::raw::c_int,
    pub num_call: ::std::os::raw::c_int,
    pub capture_history: ::std::os::raw::c_uint,
    pub bt_mem_start: ::std::os::raw::c_uint,
    pub bt_mem_end: ::std::os::raw::c_uint,
    pub stack_pop_level: ::std::os::raw::c_int,
    pub repeat_range_alloc: ::std::os::raw::c_int,
    pub options: OnigOptionType,
    pub repeat_range: *mut OnigRepeatRange,
    pub enc: OnigEncoding,
    pub syntax: *const OnigSyntaxType,
    pub name_table: *mut ::std::os::raw::c_void,
    pub case_fold_flag: OnigCaseFoldType,
    pub optimize: ::std::os::raw::c_int,
    pub threshold_len: ::std::os::raw::c_int,
    pub anchor: ::std::os::raw::c_int,
    pub anchor_dmin: OnigDistance,
    pub anchor_dmax: OnigDistance,
    pub sub_anchor: ::std::os::raw::c_int,
    pub exact: *mut ::std::os::raw::c_uchar,
    pub exact_end: *mut ::std::os::raw::c_uchar,
    pub map: [::std::os::raw::c_uchar; 256usize],
    pub int_map: *mut ::std::os::raw::c_int,
    pub int_map_backward: *mut ::std::os::raw::c_int,
    pub dmin: OnigDistance,
    pub dmax: OnigDistance,
    pub chain: *mut re_pattern_buffer,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ruby_encoding_consts {
    RUBY_ENCODING_INLINE_MAX = 127,
    RUBY_ENCODING_SHIFT = 22,
    RUBY_ENCODING_MASK = 532676608,
    RUBY_ENCODING_MAXNAMELEN = 42,
}
impl ruby_coderange_type {
    pub const RUBY_ENC_CODERANGE_MASK: ruby_coderange_type =
        ruby_coderange_type::RUBY_ENC_CODERANGE_BROKEN;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ruby_coderange_type {
    RUBY_ENC_CODERANGE_UNKNOWN = 0,
    RUBY_ENC_CODERANGE_7BIT = 1048576,
    RUBY_ENC_CODERANGE_VALID = 2097152,
    RUBY_ENC_CODERANGE_BROKEN = 3145728,
}
pub type rb_encoding = OnigEncodingType;
extern "C" {
    pub fn rb_char_to_option_kcode(
        c: ::std::os::raw::c_int,
        option: *mut ::std::os::raw::c_int,
        kcode: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_replicate(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut rb_encoding,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_define_dummy_encoding(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_dummy_p(enc: *mut rb_encoding) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_to_index(enc: *mut rb_encoding) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_get_index(obj: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_set_index(obj: VALUE, encindex: ::std::os::raw::c_int);
}
extern "C" {
    pub fn rb_enc_capable(obj: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_find_index(name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_alias(
        alias: *const ::std::os::raw::c_char,
        orig: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_to_encoding_index(arg1: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_to_encoding(arg1: VALUE) -> *mut rb_encoding;
}
extern "C" {
    pub fn rb_find_encoding(arg1: VALUE) -> *mut rb_encoding;
}
extern "C" {
    pub fn rb_enc_get(arg1: VALUE) -> *mut rb_encoding;
}
extern "C" {
    pub fn rb_enc_compatible(arg1: VALUE, arg2: VALUE) -> *mut rb_encoding;
}
extern "C" {
    pub fn rb_enc_check(arg1: VALUE, arg2: VALUE) -> *mut rb_encoding;
}
extern "C" {
    pub fn rb_enc_associate_index(arg1: VALUE, arg2: ::std::os::raw::c_int) -> VALUE;
}
extern "C" {
    pub fn rb_enc_associate(arg1: VALUE, arg2: *mut rb_encoding) -> VALUE;
}
extern "C" {
    pub fn rb_enc_copy(dst: VALUE, src: VALUE);
}
extern "C" {
    pub fn rb_enc_str_new(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_long,
        arg3: *mut rb_encoding,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_enc_str_new_cstr(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut rb_encoding,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_enc_str_new_static(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_long,
        arg3: *mut rb_encoding,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_enc_interned_str(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_long,
        arg3: *mut rb_encoding,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_enc_interned_str_cstr(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut rb_encoding,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_enc_reg_new(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_long,
        arg3: *mut rb_encoding,
        arg4: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_enc_sprintf(
        arg1: *mut rb_encoding,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> VALUE;
}
extern "C" {
    pub fn rb_enc_vsprintf(
        arg1: *mut rb_encoding,
        arg2: *const ::std::os::raw::c_char,
        arg3: va_list,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_enc_strlen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut rb_encoding,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rb_enc_nth(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_long,
        arg4: *mut rb_encoding,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_obj_encoding(arg1: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_enc_str_buf_cat(
        str_: VALUE,
        ptr: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_long,
        enc: *mut rb_encoding,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_enc_uint_chr(code: ::std::os::raw::c_uint, enc: *mut rb_encoding) -> VALUE;
}
extern "C" {
    pub fn rb_external_str_new_with_enc(
        ptr: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_long,
        arg1: *mut rb_encoding,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_str_export_to_enc(arg1: VALUE, arg2: *mut rb_encoding) -> VALUE;
}
extern "C" {
    pub fn rb_str_conv_enc(str_: VALUE, from: *mut rb_encoding, to: *mut rb_encoding) -> VALUE;
}
extern "C" {
    pub fn rb_str_conv_enc_opts(
        str_: VALUE,
        from: *mut rb_encoding,
        to: *mut rb_encoding,
        ecflags: ::std::os::raw::c_int,
        ecopts: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_enc_raise(
        arg1: *mut rb_encoding,
        arg2: VALUE,
        arg3: *const ::std::os::raw::c_char,
        ...
    );
}
extern "C" {
    pub fn rb_enc_from_index(idx: ::std::os::raw::c_int) -> *mut rb_encoding;
}
extern "C" {
    pub fn rb_enc_find(name: *const ::std::os::raw::c_char) -> *mut rb_encoding;
}
extern "C" {
    pub fn rb_enc_mbclen(
        p: *const ::std::os::raw::c_char,
        e: *const ::std::os::raw::c_char,
        enc: *mut rb_encoding,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_fast_mbclen(
        p: *const ::std::os::raw::c_char,
        e: *const ::std::os::raw::c_char,
        enc: *mut rb_encoding,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_precise_mbclen(
        p: *const ::std::os::raw::c_char,
        e: *const ::std::os::raw::c_char,
        enc: *mut rb_encoding,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_ascget(
        p: *const ::std::os::raw::c_char,
        e: *const ::std::os::raw::c_char,
        len: *mut ::std::os::raw::c_int,
        enc: *mut rb_encoding,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_codepoint_len(
        p: *const ::std::os::raw::c_char,
        e: *const ::std::os::raw::c_char,
        len: *mut ::std::os::raw::c_int,
        enc: *mut rb_encoding,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn rb_enc_codepoint(
        p: *const ::std::os::raw::c_char,
        e: *const ::std::os::raw::c_char,
        enc: *mut rb_encoding,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn rb_enc_codelen(
        code: ::std::os::raw::c_int,
        enc: *mut rb_encoding,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_code_to_mbclen(
        code: ::std::os::raw::c_int,
        enc: *mut rb_encoding,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_casefold(
        to: *mut ::std::os::raw::c_char,
        p: *const ::std::os::raw::c_char,
        e: *const ::std::os::raw::c_char,
        enc: *mut rb_encoding,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_toupper(c: ::std::os::raw::c_int, enc: *mut rb_encoding)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_tolower(c: ::std::os::raw::c_int, enc: *mut rb_encoding)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_intern3(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_long,
        arg3: *mut rb_encoding,
    ) -> ID;
}
extern "C" {
    pub fn rb_interned_id_p(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_long,
        arg3: *mut rb_encoding,
    ) -> ID;
}
extern "C" {
    pub fn rb_enc_symname_p(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut rb_encoding,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_symname2_p(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_long,
        arg3: *mut rb_encoding,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_str_coderange(arg1: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_str_coderange_scan_restartable(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut rb_encoding,
        arg4: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rb_enc_str_asciionly_p(arg1: VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_from_encoding(enc: *mut rb_encoding) -> VALUE;
}
extern "C" {
    pub fn rb_enc_unicode_p(enc: *mut rb_encoding) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_ascii8bit_encoding() -> *mut rb_encoding;
}
extern "C" {
    pub fn rb_utf8_encoding() -> *mut rb_encoding;
}
extern "C" {
    pub fn rb_usascii_encoding() -> *mut rb_encoding;
}
extern "C" {
    pub fn rb_locale_encoding() -> *mut rb_encoding;
}
extern "C" {
    pub fn rb_filesystem_encoding() -> *mut rb_encoding;
}
extern "C" {
    pub fn rb_default_external_encoding() -> *mut rb_encoding;
}
extern "C" {
    pub fn rb_default_internal_encoding() -> *mut rb_encoding;
}
extern "C" {
    pub fn rb_ascii8bit_encindex() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_utf8_encindex() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_usascii_encindex() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_locale_encindex() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_filesystem_encindex() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_enc_default_external() -> VALUE;
}
extern "C" {
    pub fn rb_enc_default_internal() -> VALUE;
}
extern "C" {
    pub fn rb_enc_set_default_external(encoding: VALUE);
}
extern "C" {
    pub fn rb_enc_set_default_internal(encoding: VALUE);
}
extern "C" {
    pub fn rb_locale_charmap(klass: VALUE) -> VALUE;
}
extern "C" {
    pub fn rb_memsearch(
        arg1: *const ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_long,
        arg3: *const ::std::os::raw::c_void,
        arg4: ::std::os::raw::c_long,
        arg5: *mut rb_encoding,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rb_enc_path_next(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut rb_encoding,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_enc_path_skip_prefix(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut rb_encoding,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_enc_path_last_separator(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut rb_encoding,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_enc_path_end(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut rb_encoding,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ruby_enc_find_basename(
        name: *const ::std::os::raw::c_char,
        baselen: *mut ::std::os::raw::c_long,
        alllen: *mut ::std::os::raw::c_long,
        enc: *mut rb_encoding,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn ruby_enc_find_extname(
        name: *const ::std::os::raw::c_char,
        len: *mut ::std::os::raw::c_long,
        enc: *mut rb_encoding,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_check_id_cstr(
        ptr: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_long,
        enc: *mut rb_encoding,
    ) -> ID;
}
extern "C" {
    pub fn rb_check_symbol_cstr(
        ptr: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_long,
        enc: *mut rb_encoding,
    ) -> VALUE;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum rb_econv_result_t {
    econv_invalid_byte_sequence = 0,
    econv_undefined_conversion = 1,
    econv_destination_buffer_full = 2,
    econv_source_buffer_empty = 3,
    econv_finished = 4,
    econv_after_output = 5,
    econv_incomplete_input = 6,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rb_econv_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn rb_str_encode(
        str_: VALUE,
        to: VALUE,
        ecflags: ::std::os::raw::c_int,
        ecopts: VALUE,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_econv_has_convpath_p(
        from_encoding: *const ::std::os::raw::c_char,
        to_encoding: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_econv_prepare_options(
        opthash: VALUE,
        ecopts: *mut VALUE,
        ecflags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_econv_prepare_opts(opthash: VALUE, ecopts: *mut VALUE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_econv_open(
        source_encoding: *const ::std::os::raw::c_char,
        destination_encoding: *const ::std::os::raw::c_char,
        ecflags: ::std::os::raw::c_int,
    ) -> *mut rb_econv_t;
}
extern "C" {
    pub fn rb_econv_open_opts(
        source_encoding: *const ::std::os::raw::c_char,
        destination_encoding: *const ::std::os::raw::c_char,
        ecflags: ::std::os::raw::c_int,
        ecopts: VALUE,
    ) -> *mut rb_econv_t;
}
extern "C" {
    pub fn rb_econv_convert(
        ec: *mut rb_econv_t,
        source_buffer_ptr: *mut *const ::std::os::raw::c_uchar,
        source_buffer_end: *const ::std::os::raw::c_uchar,
        destination_buffer_ptr: *mut *mut ::std::os::raw::c_uchar,
        destination_buffer_end: *mut ::std::os::raw::c_uchar,
        flags: ::std::os::raw::c_int,
    ) -> rb_econv_result_t;
}
extern "C" {
    pub fn rb_econv_close(ec: *mut rb_econv_t);
}
extern "C" {
    pub fn rb_econv_set_replacement(
        ec: *mut rb_econv_t,
        str_: *const ::std::os::raw::c_uchar,
        len: size_t,
        encname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_econv_decorate_at_first(
        ec: *mut rb_econv_t,
        decorator_name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_econv_decorate_at_last(
        ec: *mut rb_econv_t,
        decorator_name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_econv_open_exc(
        senc: *const ::std::os::raw::c_char,
        denc: *const ::std::os::raw::c_char,
        ecflags: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_econv_insert_output(
        ec: *mut rb_econv_t,
        str_: *const ::std::os::raw::c_uchar,
        len: size_t,
        str_encoding: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_econv_encoding_to_insert_output(ec: *mut rb_econv_t)
        -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_econv_check_error(ec: *mut rb_econv_t);
}
extern "C" {
    pub fn rb_econv_make_exception(ec: *mut rb_econv_t) -> VALUE;
}
extern "C" {
    pub fn rb_econv_putbackable(ec: *mut rb_econv_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rb_econv_putback(
        ec: *mut rb_econv_t,
        p: *mut ::std::os::raw::c_uchar,
        n: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn rb_econv_asciicompat_encoding(
        encname: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn rb_econv_str_convert(
        ec: *mut rb_econv_t,
        src: VALUE,
        flags: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_econv_substr_convert(
        ec: *mut rb_econv_t,
        src: VALUE,
        byteoff: ::std::os::raw::c_long,
        bytesize: ::std::os::raw::c_long,
        flags: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_econv_str_append(
        ec: *mut rb_econv_t,
        src: VALUE,
        dst: VALUE,
        flags: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_econv_substr_append(
        ec: *mut rb_econv_t,
        src: VALUE,
        byteoff: ::std::os::raw::c_long,
        bytesize: ::std::os::raw::c_long,
        dst: VALUE,
        flags: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_econv_append(
        ec: *mut rb_econv_t,
        bytesrc: *const ::std::os::raw::c_char,
        bytesize: ::std::os::raw::c_long,
        dst: VALUE,
        flags: ::std::os::raw::c_int,
    ) -> VALUE;
}
extern "C" {
    pub fn rb_econv_binmode(ec: *mut rb_econv_t);
}
impl ruby_econv_flag_type {
    pub const RUBY_ECONV_DEFAULT_NEWLINE_DECORATOR: ruby_econv_flag_type =
        ruby_econv_flag_type::RUBY_ECONV_CRLF_NEWLINE_DECORATOR;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ruby_econv_flag_type {
    RUBY_ECONV_ERROR_HANDLER_MASK = 255,
    RUBY_ECONV_INVALID_MASK = 15,
    RUBY_ECONV_INVALID_REPLACE = 2,
    RUBY_ECONV_UNDEF_MASK = 240,
    RUBY_ECONV_UNDEF_REPLACE = 32,
    RUBY_ECONV_UNDEF_HEX_CHARREF = 48,
    RUBY_ECONV_DECORATOR_MASK = 65280,
    RUBY_ECONV_NEWLINE_DECORATOR_MASK = 16128,
    RUBY_ECONV_NEWLINE_DECORATOR_READ_MASK = 3840,
    RUBY_ECONV_NEWLINE_DECORATOR_WRITE_MASK = 12288,
    RUBY_ECONV_UNIVERSAL_NEWLINE_DECORATOR = 256,
    RUBY_ECONV_CRLF_NEWLINE_DECORATOR = 4096,
    RUBY_ECONV_CR_NEWLINE_DECORATOR = 8192,
    RUBY_ECONV_XML_TEXT_DECORATOR = 16384,
    RUBY_ECONV_XML_ATTR_CONTENT_DECORATOR = 32768,
    RUBY_ECONV_STATEFUL_DECORATOR_MASK = 15728640,
    RUBY_ECONV_XML_ATTR_QUOTE_DECORATOR = 1048576,
    RUBY_ECONV_PARTIAL_INPUT = 65536,
    RUBY_ECONV_AFTER_OUTPUT = 131072,
    RUBY_ECONV_FLAGS_PLACEHOLDER = 131073,
}
pub type __builtin_va_list = *mut ::std::os::raw::c_char;
