use std::string::ToString;

#[derive(Debug)]
pub struct MagicString {
    pub original_str: String,

    /* prefix */
    pub intro: String,
    /* suffix */
    pub outro: String,
}

impl MagicString {
    pub fn new(str: &str) -> MagicString {
        MagicString {
            original_str: String::from(str),
            intro: String::from(""),
            outro: String::from("")
        }
    }

    pub fn append(&mut self, str: &str) -> Result<&mut Self, ()> {
        self.outro = format!("{}{}", self.outro, str);

        Ok(self)
    }

    pub fn prepend(&mut self, str: &str) -> Result<&mut Self, ()> {
        self.intro = format!("{}{}", self.intro, str);

        Ok(self)
    }

    pub fn prepend_left() {
        todo!()
    }

    pub fn prepend_right() {
        todo!()
    }

    pub fn append_left() {
        todo!()
    }

    pub fn append_right() {
        todo!()
    }

}

impl ToString for MagicString {
    fn to_string(&self) -> String {
        // FIXME: replace original_str to chunks
        format!("{}{}{}", self.intro, self.original_str, self.outro)
    }
}


