extern crate proc_macro;

use proc_macro::TokenStream;

use quote::quote;
use syn::{
    parse,
    parse::{Parse, ParseStream, Result},
    LitStr,
};
use tailwind_css::TailwindBuilder;

use self::inline::Inlined;

mod inline;

#[proc_macro]
pub fn tw(input: TokenStream) -> TokenStream {
    let Inlined { class, style } = parse(input).unwrap();
    let gen = quote! {
        (#class, #style)
    };
    gen.into()
}
