//! A friendly opinionated game math library built on top the excellent lower-level [`glam`](https://github.com/bitshifter/glam-rs).

#![cfg_attr(
    target_arch = "spirv",
    feature(register_attr, repr_simd, core_intrinsics)
)]
#![cfg_attr(target_arch = "spirv", no_std)]

mod bounding_box;
#[cfg(not(target_arch = "spirv"))]
mod color_rgba8;
mod float_ext;
mod iso_transform;
#[cfg(not(target_arch = "spirv"))]
mod mesh_gen;
mod plane3;
#[cfg(not(target_arch = "spirv"))]
mod quat_ext;
mod ray3;
mod utils;
mod vec2_ext;
mod vec3_ext;
mod vec4_ext;

pub use self::{
    bounding_box::*, float_ext::*, iso_transform::*, plane3::*, ray3::*, utils::*, vec2_ext::*,
    vec3_ext::*, vec4_ext::*,
};

#[cfg(not(target_arch = "spirv"))]
pub use color_rgba8::*;
#[cfg(not(target_arch = "spirv"))]
pub use mesh_gen::*;
#[cfg(not(target_arch = "spirv"))]
pub use quat_ext::*;

/// Prelude module with extension traits
pub mod prelude {
    pub use {
        crate::FloatExt, crate::Vec2Ext, crate::Vec2Swizzles, crate::Vec3Ext, crate::Vec3Swizzles,
        crate::Vec4Ext, crate::Vec4Swizzles,
    };

    #[cfg(not(target_arch = "spirv"))]
    pub use crate::QuatExt;
}

// Re-export main glam types.
// Should we change to re-export all?
pub use glam::{
    const_mat2, const_mat3, const_mat4, const_quat, const_vec2, const_vec3, const_vec4, ivec2,
    ivec3, mat2, mat3, mat4, quat, uvec2, uvec3, uvec4, vec2, vec3, vec4, Affine3A, EulerRot,
    IVec2, IVec3, IVec4, Mat2, Mat3, Mat4, Quat, UVec2, UVec3, UVec4, Vec2, Vec2Swizzles, Vec3,
    Vec3A, Vec3Swizzles, Vec4, Vec4Swizzles,
};
