# `macaw` changelog

<!-- markdownlint-disable MD024 -->

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## Unreleased

## [0.14.0] - 2021-10-18

- Remove deprecated `QuatExt::from_look_rotation`, use `QuatExt::rotate_positive_z_towards` instead
- Add `BoundingBox::ZERO`
- Add `BoundingBox::edges`

## [0.13.0] - 2021-10-12

- Add `reflect` to `Vec3Ext`.
- Remove `Mat3Ext` and `Mat4Ext`. Use `Mat3::from` and `Mat4::from` instead for conversion between `Mat3` and `Mat4`.

## [0.12.0] - 2021-10-04

- Update `glam` to `0.18`
- Add `Affine3A * Ray3` and `Mat3 * Ray3`.
- Add `trunc` to `Vec2Ext`, `Vec3Ext` and `Vec4Ext`.
- Add `step` and `fract` to `Vec4Ext`.
- Add `with_speedy` feature which allows serialization via the [`speedy`](https://crates.io/crates/speedy) crate.

## [0.11.2] - 2021-09-14

- Remove dependency on `spirv-std`

## [0.11.1] - 2021-08-18

- Add `with_bytemuck` feature that implements `bytemuck::Pod` and `bytemuck::Zeroable` to `ColorRgba8` for easy conversion to/from raw bytes

## [0.11.0] - 2021-08-03

- Update `glam` to `0.17`
- Update `spirv-std` to `0.4.0-alpha.11`

## [0.10.6] - 2021-08-02

- First public published version

## [0.10.5] - 2021-07-08

- Export `Affine3A`

## [0.10.4] - 2021-06-23

- Updated glam to 0.16

## [0.10.3] - 2021-05-18

- Updated glam to 0.15.1
- Expose some integer vector types (e.g. UVec2)

## [0.10.2] - 2021-04-15

### Added ⭐

- Add more methods to `Ray3` and `Plane3`.

## [0.10.1] - 2021-04-14

### Changed 🔧

- Removed `debug_assert` from `IsoTransform` constructors.

## [0.10.0] - 2021-04-13

### Changed 🔧

- Breaking change: `IsoTransform` now has private members.
- Updated `glam` to `0.14`.

### Added ⭐

- `IsoTransform::look_at_rh`.

## [0.9.0] - 2021-03-31

### Changed 🔧

- Renamed `IsoTransform::identity()` to `IsoTransform::IDENTITY`
- Update `glam` to `0.13`

## ???

### Changed 🔧

- Renamed `AffineTransform` to `IsoTransform`.

## [0.4.0] - 2020-11-24

### Added ⭐

- Add `is_finite` member to `AffineTransform`, `Plane3` and `Ray3`.
- Derive `PartialEq` for all types
- Add `BoundingBox` functions `contains`, `is_nothing` and `is_something`

### Fixed 🐛

- Fixed bug where `BoundingBox` transform functions would always return an empty bbox when transforming point-like bboxes (where `bb.is_point() == true`).

### Removed 🔥

- Removed `BoundingBox::is_empty()`. Consider using `is_nothing()` instead.

## [0.3.1] - 2020-11-18

### Changed 🔧

- Upgraded to [`glam`](https://github.com/bitshifter/glam-rs) 0.10.2 which and switched to use the new public field accessors: `.x` instead of `.x()`. The old accessor functions still work but have been deprecated. [Full changelog](https://github.com/bitshifter/glam-rs/blob/master/CHANGELOG.md#0100---2020-10-31)

## [0.3.0] - 2020-11-08

### Added ⭐

- Added `Ray3::offset_along_ray` to easily create a new ray given an offset along an existing ray

### Changed 🔧

- Upgraded to [`glam`](https://github.com/bitshifter/glam-rs) 0.10.0 which contains breaking change: "Changed the return type of `Vec4::truncate` from `Vec3A` to `Vec3`". [Full changelog](https://github.com/bitshifter/glam-rs/blob/master/CHANGELOG.md#0100---2020-10-31)

## [0.2.0] - 2020-10-10

### Added ⭐

- First published private release

[Unreleased]: https://github.com/EmbarkStudios/ark/compare/macaw-0.11.0...HEAD
[0.11.1]: https://github.com/EmbarkStudios/ark/compare/macaw-0.11.0...macaw-0.11.1
[0.11.0]: https://github.com/EmbarkStudios/ark/compare/macaw-0.10.6...macaw-0.11.0
[0.10.6]: https://github.com/EmbarkStudios/ark/compare/macaw-0.10.5...macaw-0.10.6
[0.10.5]: https://github.com/EmbarkStudios/ark/compare/macaw-0.10.4...macaw-0.10.5
[0.10.4]: https://github.com/EmbarkStudios/ark/compare/macaw-0.10.3...macaw-0.10.4
[0.10.3]: https://github.com/EmbarkStudios/ark/compare/macaw-0.10.2...macaw-0.10.3
[0.10.2]: https://github.com/EmbarkStudios/ark/compare/macaw-0.10.1...macaw-0.10.2
[0.10.1]: https://github.com/EmbarkStudios/ark/compare/macaw-0.10.0...macaw-0.10.1
[0.10.0]: https://github.com/EmbarkStudios/ark/compare/macaw-0.9.0...macaw-0.10.0
[0.3.0]: https://github.com/EmbarkStudios/ark/compare/macaw-0.2.0...macaw-0.3.0
[0.2.0]: https://github.com/EmbarkStudios/ark/compare/35b042afe7f6696ee730ef0040b50ee427b474db...macaw-0.2.0
