//! A friendly opinionated game math library built on top the excellent lower-level [`glam`](https://github.com/bitshifter/glam-rs).

// BEGIN - Embark standard lints v0.4
// do not change or add/remove here, but one can add exceptions after this section
// for more info see: <https://github.com/EmbarkStudios/rust-ecosystem/issues/59>
#![deny(unsafe_code)]
#![warn(
    clippy::all,
    clippy::await_holding_lock,
    clippy::char_lit_as_u8,
    clippy::checked_conversions,
    clippy::dbg_macro,
    clippy::debug_assert_with_mut_call,
    clippy::doc_markdown,
    clippy::empty_enum,
    clippy::enum_glob_use,
    clippy::exit,
    clippy::expl_impl_clone_on_copy,
    clippy::explicit_deref_methods,
    clippy::explicit_into_iter_loop,
    clippy::fallible_impl_from,
    clippy::filter_map_next,
    clippy::float_cmp_const,
    clippy::fn_params_excessive_bools,
    clippy::if_let_mutex,
    clippy::implicit_clone,
    clippy::imprecise_flops,
    clippy::inefficient_to_string,
    clippy::invalid_upcast_comparisons,
    clippy::large_types_passed_by_value,
    clippy::let_unit_value,
    clippy::linkedlist,
    clippy::lossy_float_literal,
    clippy::macro_use_imports,
    clippy::manual_ok_or,
    clippy::map_err_ignore,
    clippy::map_flatten,
    clippy::map_unwrap_or,
    clippy::match_on_vec_items,
    clippy::match_same_arms,
    clippy::match_wildcard_for_single_variants,
    clippy::mem_forget,
    clippy::mismatched_target_os,
    clippy::mut_mut,
    clippy::mutex_integer,
    clippy::needless_borrow,
    clippy::needless_continue,
    clippy::option_option,
    clippy::path_buf_push_overwrite,
    clippy::ptr_as_ptr,
    clippy::ref_option_ref,
    clippy::rest_pat_in_fully_bound_structs,
    clippy::same_functions_in_if_condition,
    clippy::semicolon_if_nothing_returned,
    clippy::string_add_assign,
    clippy::string_add,
    clippy::string_lit_as_bytes,
    clippy::string_to_string,
    clippy::todo,
    clippy::trait_duplication_in_bounds,
    clippy::unimplemented,
    clippy::unnested_or_patterns,
    clippy::unused_self,
    clippy::useless_transmute,
    clippy::verbose_file_reads,
    clippy::zero_sized_map_values,
    future_incompatible,
    nonstandard_style,
    rust_2018_idioms
)]
// END - Embark standard lints v0.4
// BEGIN - Ark-specific lints
#![warn(
    clippy::flat_map_option,
    clippy::disallowed_method,
    clippy::disallowed_type,
    clippy::single_match_else
)]
// END - Ark-specific lints

// crate-specific exceptions:
#![allow()]
#![cfg_attr(
    target_arch = "spirv",
    feature(register_attr, repr_simd, core_intrinsics)
)]
#![cfg_attr(target_arch = "spirv", no_std)]

mod bounding_box;
#[cfg(not(target_arch = "spirv"))]
mod color_rgba8;
mod float_ext;
mod iso_transform;
#[cfg(not(target_arch = "spirv"))]
mod mesh_gen;
mod plane3;
#[cfg(not(target_arch = "spirv"))]
mod quat_ext;
mod ray3;
mod utils;
mod vec2_ext;
mod vec3_ext;
mod vec4_ext;

pub use self::{
    bounding_box::*, float_ext::*, iso_transform::*, plane3::*, ray3::*, utils::*, vec2_ext::*,
    vec3_ext::*, vec4_ext::*,
};

#[cfg(not(target_arch = "spirv"))]
pub use color_rgba8::*;
#[cfg(not(target_arch = "spirv"))]
pub use mesh_gen::*;
#[cfg(not(target_arch = "spirv"))]
pub use quat_ext::*;

/// Prelude module with extension traits
pub mod prelude {
    pub use {
        crate::FloatExt, crate::Vec2Ext, crate::Vec2Swizzles, crate::Vec3Ext, crate::Vec3Swizzles,
        crate::Vec4Ext, crate::Vec4Swizzles,
    };

    #[cfg(not(target_arch = "spirv"))]
    pub use crate::QuatExt;
}

// Re-export main glam types.
// Should we change to re-export all?
pub use glam::{
    const_mat2, const_mat3, const_mat4, const_quat, const_vec2, const_vec3, const_vec4, ivec2,
    ivec3, mat2, mat3, mat4, quat, uvec2, uvec3, uvec4, vec2, vec3, vec4, Affine3A, EulerRot,
    IVec2, IVec3, IVec4, Mat2, Mat3, Mat4, Quat, UVec2, UVec3, UVec4, Vec2, Vec2Swizzles, Vec3,
    Vec3A, Vec3Swizzles, Vec4, Vec4Swizzles,
};
