//! Copied from https://github.com/bitshifter/glam-rs

#[macro_export]
macro_rules! bench_func {
    ($name: ident, $desc: expr, op => $func: ident, from => $from: expr) => {
        pub(crate) fn $name(c: &mut Criterion) {
            const SIZE: usize = 1 << 13;
            let mut rng = support::PCG32::default();
            let inputs =
                criterion::black_box((0..SIZE).map(|_| $from(&mut rng)).collect::<Vec<_>>());
            // pre-fill output vector with some random value
            let mut outputs = vec![$func($from(&mut rng)); SIZE];
            let mut i = 0;
            c.bench_function($desc, |b| {
                b.iter(|| {
                    i = (i + 1) & (SIZE - 1);
                    unsafe {
                        *outputs.get_unchecked_mut(i) = $func(*inputs.get_unchecked(i));
                    }
                })
            });
            criterion::black_box(outputs);
        }
    };
}

#[macro_export]
macro_rules! bench_unop {
    ($name: ident, $desc: expr, op => $unop: ident, from => $from: expr) => {
        pub(crate) fn $name(c: &mut Criterion) {
            const SIZE: usize = 1 << 13;
            let mut rng = support::PCG32::default();
            let inputs =
                criterion::black_box((0..SIZE).map(|_| $from(&mut rng)).collect::<Vec<_>>());
            // pre-fill output vector with some random value
            let mut outputs = vec![$from(&mut rng).$unop(); SIZE];
            let mut i = 0;
            c.bench_function($desc, |b| {
                b.iter(|| {
                    i = (i + 1) & (SIZE - 1);
                    unsafe {
                        *outputs.get_unchecked_mut(i) = inputs.get_unchecked(i).$unop();
                    }
                })
            });
            criterion::black_box(outputs);
        }
    };
}

#[macro_export]
macro_rules! bench_binop {
    ($name: ident, $desc: expr, op => $binop: ident, from1 => $from1:expr, from2 => $from2:expr) => {
        pub(crate) fn $name(c: &mut Criterion) {
            const SIZE: usize = 1 << 13;
            let mut rng = support::PCG32::default();
            let inputs1 =
                criterion::black_box((0..SIZE).map(|_| $from1(&mut rng)).collect::<Vec<_>>());
            let inputs2 =
                criterion::black_box((0..SIZE).map(|_| $from2(&mut rng)).collect::<Vec<_>>());
            // pre-fill output vector with some random value
            let mut outputs = vec![$from1(&mut rng).$binop($from2(&mut rng)); SIZE];
            let mut i = 0;
            c.bench_function($desc, |b| {
                b.iter(|| {
                    i = (i + 1) & (SIZE - 1);
                    unsafe {
                        *outputs.get_unchecked_mut(i) = inputs1.get_unchecked(i).$binop(*inputs2.get_unchecked(i));
                    }
                })
            });
            criterion::black_box(outputs);
        }
    };
    ($name: ident, $desc: expr, op => $binop: ident, from => $from: expr) => {
        bench_binop!($name, $desc, op => $binop, from1 => $from, from2 => $from);
    };
}

#[macro_export]
macro_rules! bench_trinop {
    ($name: ident, $desc: expr, op => $trinop: ident, from1 => $from1:expr, from2 => $from2:expr, from3 => $from3:expr) => {
        pub(crate) fn $name(c: &mut Criterion) {
            const SIZE: usize = 1 << 13;
            let mut rng = support::PCG32::default();
            let inputs1 =
                criterion::black_box((0..SIZE).map(|_| $from1(&mut rng)).collect::<Vec<_>>());
            let inputs2 =
                criterion::black_box((0..SIZE).map(|_| $from2(&mut rng)).collect::<Vec<_>>());
            let inputs3 =
                criterion::black_box((0..SIZE).map(|_| $from3(&mut rng)).collect::<Vec<_>>());
            // pre-fill output vector with some random value
            let mut outputs =
                vec![$from1(&mut rng).$trinop($from2(&mut rng), $from3(&mut rng)); SIZE];
            let mut i = 0;
            c.bench_function($desc, |b| {
                b.iter(|| {
                    i = (i + 1) & (SIZE - 1);
                    unsafe {
                        *outputs.get_unchecked_mut(i) = inputs1
                            .get_unchecked(i)
                            .$trinop(*inputs2.get_unchecked(i), *inputs3.get_unchecked(i));
                    }
                })
            });
            criterion::black_box(outputs);
        }
    };
}

#[macro_export]
macro_rules! bench_select {
    ($name:ident, $desc:expr, ty => $ty: ident, op => $op: ident, from => $from:expr) => {
        pub(crate) fn $name(c: &mut Criterion) {
            const SIZE: usize = 1 << 13;
            let mut rng = support::PCG32::default();
            let inputs1 =
                criterion::black_box((0..SIZE).map(|_| $from(&mut rng)).collect::<Vec<_>>());
            let inputs2 =
                criterion::black_box((0..SIZE).map(|_| $from(&mut rng)).collect::<Vec<_>>());
            let masks = vec![$from(&mut rng).$op($from(&mut rng)); SIZE];
            // pre-fill output vector with some random value
            let mut outputs = vec![$from(&mut rng); SIZE];
            let mut i = 0;
            c.bench_function($desc, |b| {
                b.iter(|| {
                    i = (i + 1) & (SIZE - 1);
                    unsafe {
                        *outputs.get_unchecked_mut(i) = $ty::select(
                            *masks.get_unchecked(i),
                            *inputs1.get_unchecked(i),
                            *inputs2.get_unchecked(i),
                        );
                    }
                })
            });
            criterion::black_box(outputs);
        }
    };
}
