use super::{uvec4, vec4, UVec4, Vec4};

#[cfg(target_arch = "spirv")]
use num_traits::Float;

/// Extensions to [`Vec4`]
///
/// Adds additional functionality to [`Vec4`] that [`glam`] doesn't have.
pub trait Vec4Ext {
    /// Return the square root of each component.
    fn sqrt(self) -> Self;

    /// Raw transmute each component to u32.
    fn to_bits(self) -> UVec4;
}

impl Vec4Ext for Vec4 {
    fn sqrt(self) -> Self {
        vec4(self.x.sqrt(), self.y.sqrt(), self.z.sqrt(), self.w.sqrt())
    }

    fn to_bits(self) -> UVec4 {
        uvec4(
            self.x.to_bits(),
            self.y.to_bits(),
            self.z.to_bits(),
            self.w.to_bits(),
        )
    }
}
