use super::prelude::*;
use super::{mat3, Mat3, Mat4};

/// Extensions to [`Mat4`]
///
/// Adds additional functionality to [`Mat4`] that [`glam`] doesn't have.
pub trait Mat4Ext {
    /// Truncates `self` by one in each dimension into a [`Mat3`]
    fn to_mat3(&self) -> Mat3;
}

impl Mat4Ext for Mat4 {
    fn to_mat3(&self) -> Mat3 {
        mat3(self.x_axis.xyz(), self.y_axis.xyz(), self.z_axis.xyz())
    }
}
