use super::{mat4, vec4, Mat3, Mat4};

/// Extensions to [`Mat3`]
///
/// Adds additional functionality to [`Mat3`] that [`glam`] doesn't have.
pub trait Mat3Ext {
    /// Expands `self` into a homogeneous [`Mat4`]
    fn to_homogeneous(&self) -> Mat4;
}

impl Mat3Ext for Mat3 {
    fn to_homogeneous(&self) -> Mat4 {
        mat4(
            self.x_axis.extend(0.0),
            self.y_axis.extend(0.0),
            self.z_axis.extend(0.0),
            vec4(0.0, 0.0, 0.0, 1.0),
        )
    }
}
