use m_ipd::strategies::{always_defect, axelrod::{self, *}};
use m_ipd::policies::{self, *};

pub fn main() {
    // The policies we want to test
    let policies: [(_, m_ipd::RevealPolicy); 4] = [
        ("Always Show", always_show),
        ("Never Show", never_show),
        ("Random", || policies::random(0.5)),
        ("By Cooperate Rate", || show_cooperate(1f32)),
    ];

    // The strategies we want to test
    let strategies: [(_, m_ipd::Strategy); 10] = [
        ("Always Defect", always_defect),
        ("Tit for Tat", tit_for_tat),
        ("Optimistic Tit for Tat", optimistic_tit_for_tat),
        ("Punishing Tit for Tat", punishing_tit_for_tat),
        ("Betray Defect", betray_defect),
        ("Defect Streaks", defect_streaks),
        ("Grudge Holder", grudge_holder),
        ("Decreasing Tit for Tat", decreasing_tit_for_tat),
        ("Random Tit for Tat", random_tit_for_tat),
        ("Random", || axelrod::random(0.5))
    ];

    let strat_names = strategies.iter().map(|(n, _)| n).collect::<Vec<_>>();
    let strategies = strategies.iter().map(|(_, s)| *s).collect::<Vec<_>>();

    for &(p_name, p) in policies.iter() {
        println!("{}", p_name);
        let res = m_ipd::tournament(&strategies[..], p);
        for (name, points) in strat_names.iter().zip(res){
            println!("{}\t{}", name, points);
        }
        println!("");
    }
}
