/*
通过release profile来自定义构建
release profile：
    是预定义的
    可自定义：可使用不同的配置，对代码编译拥有更多的控制
每个profile的配置都独立于其它的profile
cargo主要的两个profile:
    dev profile: 适用于开发，cargo build
    release profile: 适用于发布 cargo build --release
自定义profile
    针对每个profile,cargo都提供了默认的配置
    如果项自定义xxx profile的配置
        可以在cargo.toml里添加[profile.xxxx]区域，在里面覆盖默认配置的子集
    对于每个配置的默认值和完整选项，请参见：https://doc.rust-lang.org/cargo/.
发布crate到crates.io
    可以通过发布包来共享你的代码
    ctate的注册表在https://crates.io/
        它会分发已注册的包的源代码
        主要托管开源的代码
    发布crate前，需要子啊crate.io创建账号并获得API token
    运行cargo login [API]
        通知cargo，你的apt token存储在本地~/.cargo/credentials
    在发布crate之前，需要在Cargo.toml的[package]区域为crate添加一些元数据
        crate需要唯一的名称：name
        description：一两句话即可，会出现在crate搜索的结果里
        license: 需要提供许可证标识值（https://spdx.org/licenses/）
            可指定多个license：用OR
        version
        author
    发布： cargo publish命令


文档注释
    用于生成文档
        生成HTML文档
        显式公共AP的文档注释，如何使用API
        使用///
        支持markdown
        放置在被说明条目之前
    cargo doc
        会运行rustdoc工具
        会放到target/doc文件里
    cargo doc --open
        构建当前crate的文档（也包含crate依赖项的文档）
        在浏览器打开文档
常用章节
    #Examples
    #Panics  函数可能发生panic的场景
    #Errors  如果函数返回Result，描述可能的错误种类，已经可导致错误的条件
    #safety 如果函数处于unsafe调用，就应该解释函数unsafe的原因，以及调用者确保的使用前提
文档注释作为测试
    示例代码块的附加值：
        运行cargo test：将把文档注释中的示例代码作为测试来运行
为包含注释的项添加文档注释
    符号：//!
    这类注释通常描述crate和模块：
        crate root(按惯例src/lib.rs)
        一个模块内，将crate或模块作为一个整体进行记录
使用pub use导出方便使用公共API
    问题：crate的程序结构在开发时对于开发者很合理，但对于它的使用者不够方便
        开发者会把程序结构分为很多层，使用者想找到这种深层结构中的某个类很费劲
    解决办法
        不需要重新组织内部代码结构
        使用pub use：可以重新导出，创建一个与内部私有结构不同的对外公共结构

*/
// use release_profile::utils::mix;
// use release_profile::{add_one,kinds::PrimaryColor};
use lxc_profile::PrimaryColor;
use lxc_profile::mix;
fn main() {
    // println!("Hello, world!");
    // let x =crate::add_one(3);

    let red = PrimaryColor::Red;
    let yellow = PrimaryColor::Yellow;
    mix(red,yellow);
}
