use lunesrs::wallet::assembly::to_address;
use wasm_bindgen_test::wasm_bindgen_test;

#[test]
#[wasm_bindgen_test]
fn multple_address() {
    let mainnet_id = 1;
    let version_address = 1;
    let public_key = vec![
        [
            28, 105, 36, 199, 36, 111, 120, 95, 152, 208, 215, 39, 161, 71, 78, 237, 200, 160, 71,
            209, 177, 102, 140, 170, 56, 206, 9, 214, 227, 38, 117, 117,
        ],
        [
            138, 251, 177, 135, 204, 17, 215, 139, 107, 110, 163, 159, 69, 66, 230, 125, 46, 90,
            155, 251, 112, 76, 80, 226, 246, 159, 0, 247, 24, 204, 238, 127,
        ],
        [
            83, 143, 55, 207, 188, 113, 76, 98, 188, 187, 21, 6, 121, 237, 114, 87, 56, 119, 247,
            123, 107, 235, 127, 93, 111, 125, 177, 254, 234, 7, 182, 102,
        ],
        [
            24, 17, 29, 210, 50, 221, 206, 124, 241, 169, 109, 116, 202, 228, 241, 10, 66, 235, 31,
            179, 74, 61, 220, 114, 110, 17, 25, 9, 161, 78, 24, 115,
        ],
        [
            199, 51, 26, 241, 231, 42, 46, 169, 1, 155, 227, 85, 160, 76, 123, 191, 181, 159, 48,
            66, 209, 156, 162, 79, 235, 66, 199, 211, 35, 21, 161, 56,
        ],
    ];
    let address = vec![
        [
            1, 49, 44, 46, 82, 88, 220, 91, 204, 187, 92, 83, 89, 68, 39, 15, 115, 185, 143, 151,
            57, 38, 99, 41, 200, 192,
        ],
        [
            1, 49, 100, 15, 35, 15, 57, 108, 76, 243, 246, 206, 122, 97, 86, 56, 125, 82, 146, 153,
            2, 191, 247, 116, 35, 216,
        ],
        [
            1, 49, 70, 204, 18, 41, 121, 119, 51, 99, 11, 250, 56, 190, 114, 202, 109, 245, 133,
            232, 82, 31, 212, 75, 87, 56,
        ],
        [
            1, 49, 132, 46, 58, 18, 143, 212, 98, 181, 24, 5, 121, 141, 54, 144, 157, 172, 120,
            255, 157, 67, 171, 180, 211, 179,
        ],
        [
            1, 49, 125, 33, 20, 80, 131, 75, 252, 110, 0, 36, 84, 146, 24, 131, 61, 235, 243, 119,
            150, 138, 78, 202, 75, 45,
        ],
    ];

    for (pubk, addr) in public_key.iter().zip(address) {
        assert_eq!(to_address(version_address, mainnet_id, pubk.to_vec()), addr);
    }
}

#[test]
#[wasm_bindgen_test]
fn single_address() {
    let mainnet_id = 1;
    let version_address = 1;
    let public_key: Vec<u8> = vec![
        28, 105, 36, 199, 36, 111, 120, 95, 152, 208, 215, 39, 161, 71, 78, 237, 200, 160, 71, 209,
        177, 102, 140, 170, 56, 206, 9, 214, 227, 38, 117, 117,
    ];

    assert_eq!(
        to_address(version_address, mainnet_id, public_key),
        [
            1, 49, 44, 46, 82, 88, 220, 91, 204, 187, 92, 83, 89, 68, 39, 15, 115, 185, 143, 151,
            57, 38, 99, 41, 200, 192,
        ],
    );
}
