use lunesrs::account::wallet::to_private_key;
use wasm_bindgen_test::wasm_bindgen_test;

#[test]
#[wasm_bindgen_test]
fn multple_private_key() {
    let hashed_seeds = [
        [
            [
                163, 66, 17, 225, 21, 144, 128, 203, 241, 21, 205, 209, 16, 138, 219, 155, 50, 48,
                24, 209, 227, 79, 35, 104, 252, 102, 213, 74, 63, 165, 20, 96,
            ],
            [
                160, 66, 17, 225, 21, 144, 128, 203, 241, 21, 205, 209, 16, 138, 219, 155, 50, 48,
                24, 209, 227, 79, 35, 104, 252, 102, 213, 74, 63, 165, 20, 96,
            ],
        ],
        [
            [
                158, 195, 158, 43, 235, 175, 81, 113, 71, 142, 134, 117, 226, 247, 140, 189, 9, 86,
                193, 54, 59, 40, 100, 59, 213, 171, 8, 113, 151, 244, 43, 116,
            ],
            [
                152, 195, 158, 43, 235, 175, 81, 113, 71, 142, 134, 117, 226, 247, 140, 189, 9, 86,
                193, 54, 59, 40, 100, 59, 213, 171, 8, 113, 151, 244, 43, 116,
            ],
        ],
        [
            [
                50, 135, 161, 15, 52, 78, 234, 177, 234, 101, 67, 192, 68, 174, 104, 124, 28, 156,
                23, 33, 81, 118, 210, 255, 127, 127, 59, 24, 148, 215, 25, 141,
            ],
            [
                48, 135, 161, 15, 52, 78, 234, 177, 234, 101, 67, 192, 68, 174, 104, 124, 28, 156,
                23, 33, 81, 118, 210, 255, 127, 127, 59, 24, 148, 215, 25, 77,
            ],
        ],
        [
            [
                68, 188, 249, 142, 153, 123, 119, 187, 134, 139, 142, 224, 144, 233, 96, 219, 118,
                79, 3, 179, 172, 145, 191, 189, 235, 205, 232, 119, 176, 55, 76, 197,
            ],
            [
                64, 188, 249, 142, 153, 123, 119, 187, 134, 139, 142, 224, 144, 233, 96, 219, 118,
                79, 3, 179, 172, 145, 191, 189, 235, 205, 232, 119, 176, 55, 76, 69,
            ],
        ],
        [
            [
                176, 132, 66, 150, 25, 7, 98, 166, 0, 121, 84, 17, 161, 132, 204, 58, 19, 4, 158,
                161, 26, 205, 63, 198, 230, 171, 218, 199, 199, 217, 26, 102,
            ],
            [
                176, 132, 66, 150, 25, 7, 98, 166, 0, 121, 84, 17, 161, 132, 204, 58, 19, 4, 158,
                161, 26, 205, 63, 198, 230, 171, 218, 199, 199, 217, 26, 102,
            ],
        ],
    ];

    for x in hashed_seeds {
        assert_eq!(to_private_key(x[0].to_vec()), x[1]);
    }
}

#[test]
#[wasm_bindgen_test]
fn single_private_key() {
    let hidden_seed: Vec<u8> = vec![
        163, 66, 17, 225, 21, 144, 128, 203, 241, 21, 205, 209, 16, 138, 219, 155, 50, 48, 24, 209,
        227, 79, 35, 104, 252, 102, 213, 74, 63, 165, 20, 96,
    ];

    assert_eq!(
        to_private_key(hidden_seed),
        [
            160, 66, 17, 225, 21, 144, 128, 203, 241, 21, 205, 209, 16, 138, 219, 155, 50, 48, 24,
            209, 227, 79, 35, 104, 252, 102, 213, 74, 63, 165, 20, 96,
        ]
    );
}
