use luka::{Graph, algorithms};

#[test]
fn test_find_subtrees_size() {
    let mut graph = Graph::new(12);

    graph.add_edge(1, 4, 0).unwrap();
    graph.add_edge(1, 2, 0).unwrap();
    graph.add_edge(4, 11, 0).unwrap();
    graph.add_edge(4, 12, 0).unwrap();
    graph.add_edge(12, 3, 0).unwrap();
    graph.add_edge(2, 5, 0).unwrap();
    graph.add_edge(2, 6, 0).unwrap();
    graph.add_edge(5, 9, 0).unwrap();
    graph.add_edge(5, 10, 0).unwrap();
    graph.add_edge(6, 7, 0).unwrap();
    graph.add_edge(7, 8, 0).unwrap();

    let subtrees_size = algorithms::find_subtrees_size(&graph, graph.get_vertex(1).unwrap()).unwrap();
    assert_eq!(subtrees_size.get_subtree_size(graph.get_vertex(1).unwrap()), Some(12));
    assert_eq!(subtrees_size.get_subtree_size(graph.get_vertex(2).unwrap()), Some(7));
    assert_eq!(subtrees_size.get_subtree_size(graph.get_vertex(4).unwrap()), Some(4));
}