use luka::{Graph};
use luka::algorithms::LCA;

#[test]
fn test_lca() {

    let mut graph = Graph::new(8);
    graph.add_edge(1, 2, 0).unwrap();
    graph.add_edge(1, 3, 0).unwrap();
    graph.add_edge(2, 4, 0).unwrap();
    graph.add_edge(2, 5, 0).unwrap();
    graph.add_edge(3, 6, 0).unwrap();
    graph.add_edge(3, 7, 0).unwrap();
    graph.add_edge(7, 8, 0).unwrap();

    let lca = LCA::build(&graph, graph.get_vertex(1).unwrap()).unwrap();

    assert_eq!(2, lca.query(graph.get_vertex(4).unwrap(), graph.get_vertex(5).unwrap()).id());
    assert_eq!(1, lca.query(graph.get_vertex(4).unwrap(), graph.get_vertex(8).unwrap()).id());
    assert_eq!(2, lca.query(graph.get_vertex(4).unwrap(), graph.get_vertex(2).unwrap()).id());
    assert_eq!(1, lca.query(graph.get_vertex(2).unwrap(), graph.get_vertex(8).unwrap()).id());
    assert_eq!(3, lca.query(graph.get_vertex(6).unwrap(), graph.get_vertex(8).unwrap()).id());
}