use luka::Graph;
use luka::error::GraphError;
use luka::error::ErrorKind::UnableCreateEdge;

#[test]
fn integration_test_add_edge() {
    let mut graph = Graph::new(1000);
    graph.add_edge(1, 2, 1).unwrap();
    graph.add_edge(1, 2, 1000).unwrap();
}

#[test]
fn integraion_test_invalid_add_edge() {
    let mut graph = Graph::new(10);
    let res = match graph.add_edge(1, 0, 1) {
        Err(err) => {
            match err{
                GraphError::Regular(UnableCreateEdge(_from, _to)) => true,
                _ => false
            }
        }
        Ok(()) => {
            false
        }
    };
    assert_eq!(true, res);
}

#[test]
#[should_panic]
fn integration_test_invalid_add_edge_with_panic() {
    let mut graph = Graph::new(10);
    graph.add_edge(1, 102, 1).unwrap();
}