use luka::{Graph, algorithms};

#[test]
fn test_floid() {
    let mut graph = Graph::new(4);
    graph.add_edge(1, 2, 1).unwrap();
    graph.add_edge(1, 3, 6).unwrap();
    graph.add_edge(2, 3, 4).unwrap();
    graph.add_edge(2, 4, 1).unwrap();
    graph.add_edge(4, 3, 1).unwrap();

    let dist = algorithms::floid(&graph).unwrap();
    assert_eq!(*dist.get_distance(graph.get_vertex(2).unwrap(), graph.get_vertex(4).unwrap()).unwrap(), 1);
    assert_eq!(*dist.get_distance(graph.get_vertex(1).unwrap(), graph.get_vertex(3).unwrap()).unwrap(), 3);


}

#[test]
#[should_panic]
fn test_floid_exists_cycle_negative_weight() {
    let mut graph = Graph::new(4);
    graph.add_edge(1, 2, 1).unwrap();
    graph.add_edge(2, 3, -5).unwrap();
    graph.add_edge(3, 1, -7).unwrap();

    algorithms::floid(&graph).unwrap();
}