use luka::{Graph, algorithms};

#[test]
fn test_find_bridges() {
    let mut graph = Graph::new(7);
    graph.add_edge(1, 2, 0).unwrap();
    graph.add_edge(2, 1, 0).unwrap();
    graph.add_edge(2, 3, 0).unwrap();
    graph.add_edge(3, 2, 0).unwrap();
    graph.add_edge(3, 1, 0).unwrap();
    graph.add_edge(1, 3, 0).unwrap();
    graph.add_edge(3, 4, 0).unwrap();
    graph.add_edge(4, 3, 0).unwrap();
    graph.add_edge(4, 5, 0).unwrap();
    graph.add_edge(5, 4, 0).unwrap();
    graph.add_edge(4, 6, 0).unwrap();
    graph.add_edge(6, 4, 0).unwrap();
    graph.add_edge(6, 5, 0).unwrap();
    graph.add_edge(5, 6, 0).unwrap();
    graph.add_edge(5, 7, 0).unwrap();
    graph.add_edge(7, 5, 0).unwrap();

    let mut bridges = vec![];
    let res = algorithms::find_bridges(&graph).unwrap();
    for bridge in res {
        bridges.push((bridge.from.id(), bridge.to.id()));
    }
    assert_eq!(bridges, vec![(5, 7), (3, 4)]);
}