use luka::{Graph, algorithms};

#[test]
fn integration_test_find_cycle() {
    let mut graph = Graph::new(10);
    graph.add_edge(1, 2, 0).unwrap();
    graph.add_edge(2, 1, 0).unwrap();
    graph.add_edge(2, 3, 0).unwrap();
    graph.add_edge(3, 2, 0).unwrap();
    assert_eq!(algorithms::find_cycle(&graph).unwrap().is_none(), true);
    graph.add_edge(3, 1, 0).unwrap();
    graph.add_edge(1, 3, 0).unwrap();
    assert_eq!(algorithms::find_cycle(&graph).unwrap().unwrap().iter().map(|vertex| vertex.id()).collect::<Vec<usize>>(), vec![1, 2, 3]);
}

#[test]
fn test_find_oriented_cycle() {
    let mut graph = Graph::new(10);
    graph.add_edge(1, 2, 0).unwrap();
    graph.add_edge(2, 3, 0).unwrap();
    assert!(algorithms::find_oriented_cycle(&graph).unwrap().is_none());
    graph.add_edge(3, 1, 0).unwrap();
    assert_eq!(algorithms::find_oriented_cycle(&graph).unwrap().unwrap().iter().map(|vertex| vertex.id()).collect::<Vec<usize>>(), vec![1, 2, 3]);
}