use luka::{Graph, utils, algorithms};

#[test]
fn test_bellman_ford(){
    let mut graph = Graph::new(10);

    graph.add_edge(1, 2, 2.0).unwrap();
    graph.add_edge(2, 3, 5.0).unwrap();
    graph.add_edge(3, 5, 7.0).unwrap();
    graph.add_edge(1, 5, 19.0).unwrap();

    let start = graph.get_vertex(1).unwrap();
    let (parents, distances) = algorithms::bellman_ford(&graph, start).unwrap();

    let target = graph.get_vertex(5).unwrap();
    let path = utils::find_path(&graph, &target, &parents).unwrap().unwrap();
    assert_eq!(path.iter().map(|vertex|vertex.id()).collect::<Vec<usize>>(), vec![1, 2, 3, 5]);
    assert_eq!(distances.get_distance(target).unwrap(), 14.0);

    let target = graph.get_vertex(3).unwrap();
    let path = utils::find_path(&graph, &target, &parents).unwrap().unwrap();
    assert_eq!(path.iter().map(|vertex|vertex.id()).collect::<Vec<usize>>(), vec![1, 2, 3]);

    let target = graph.get_vertex(7).unwrap();
    assert_eq!(distances.get_distance(target), None);
}

#[test]
#[should_panic]
fn test_bellman_ford_exists_cycle(){
    let mut graph = Graph::new(4);

    graph.add_edge(1, 2, 2.0).unwrap();
    graph.add_edge(2, 3, -2.0).unwrap();
    graph.add_edge(3, 4, -2.0).unwrap();
    graph.add_edge(4, 2, -2.0).unwrap();

    let start = graph.get_vertex(1).unwrap();
    algorithms::bellman_ford(&graph, start).unwrap();
}