use luka::{Graph, algorithms};

#[test]
fn test_find_vertices_depths() {
    let mut graph = Graph::new(12);

    graph.add_edge(1, 4, 0).unwrap();
    graph.add_edge(1, 2, 0).unwrap();
    graph.add_edge(4, 11, 0).unwrap();
    graph.add_edge(4, 12, 0).unwrap();
    graph.add_edge(12, 3, 0).unwrap();
    graph.add_edge(2, 5, 0).unwrap();
    graph.add_edge(2, 6, 0).unwrap();
    graph.add_edge(5, 9, 0).unwrap();
    graph.add_edge(5, 10, 0).unwrap();
    graph.add_edge(6, 7, 0).unwrap();
    graph.add_edge(7, 8, 0).unwrap();

    let depths = algorithms::find_vertices_depths(&graph, graph.get_vertex(1).unwrap()).unwrap();
    assert_eq!(depths.get_vertix_depth(graph.get_vertex(3).unwrap()), Some(3));
    assert_eq!(depths.get_vertix_depth(graph.get_vertex(8).unwrap()), Some(4));
    assert_eq!(depths.get_vertix_depth(graph.get_vertex(11).unwrap()), Some(2));
}