use luka::Graph;
use luka::algorithms::topoligical_sort;

#[test]
fn integration_test_topology_sort() {
    let mut graph = Graph::new(5);

    graph.add_edge(1, 2, 0.0).unwrap();
    graph.add_edge(1, 3, 0.0).unwrap();
    graph.add_edge(1, 5, 0.0).unwrap();
    graph.add_edge(1, 4, 0.0).unwrap();
    graph.add_edge(2, 4, 0.0).unwrap();
    graph.add_edge(3, 4, 0.0).unwrap();
    graph.add_edge(3, 5, 0.0).unwrap();
    let vertexes = topoligical_sort(&graph).unwrap();
    assert_eq!(vertexes.iter().map(|vertex|vertex.id()).collect::<Vec<usize>>(), vec![1, 3, 5, 2, 4]);

    let mut graph = Graph::new(8);
    graph.add_edge(1, 2, 0.0).unwrap();
    graph.add_edge(1, 3, 0.0).unwrap();
    graph.add_edge(1, 5, 0.0).unwrap();
    graph.add_edge(1, 4, 0.0).unwrap();
    graph.add_edge(2, 4, 0.0).unwrap();
    graph.add_edge(3, 4, 0.0).unwrap();
    graph.add_edge(3, 5, 0.0).unwrap();
    graph.add_edge(6, 7, 0.0).unwrap();
    graph.add_edge(7, 8, 0.0).unwrap();
    let vertexes = topoligical_sort(&graph).unwrap();
    assert_eq!(vertexes.iter().map(|vertex|vertex.id()).collect::<Vec<usize>>(), vec![6, 7, 8, 1, 3, 5, 2, 4]);

    let mut graph = Graph::new(10);
    graph.add_edge(2, 4, 0).unwrap();
    graph.add_edge(2, 5, 0).unwrap();
    graph.add_edge(2, 1, 0).unwrap();
    graph.add_edge(3, 1, 0).unwrap();
    graph.add_edge(4, 5, 0).unwrap();
    graph.add_edge(4, 3, 0).unwrap();
    graph.add_edge(5, 3, 0).unwrap();
    let vertexes = topoligical_sort(&graph).unwrap();
    assert_eq!(vertexes.iter().map(|vertex|vertex.id()).collect::<Vec<usize>>(), vec![10, 9, 8, 7, 6, 2, 4, 5, 3, 1]);
}

#[test]
#[should_panic]
fn integration_test_exists_cycle_topology_sort() {
    let mut graph = Graph::new(5);

    graph.add_edge(1, 2, 0.0).unwrap();
    graph.add_edge(2, 3, 0.0).unwrap();
    graph.add_edge(3, 4, 0.0).unwrap();
    graph.add_edge(4, 2, 0.0).unwrap();
    let vertexes = topoligical_sort(&graph).unwrap();
    assert_eq!(vertexes.iter().map(|vertex|vertex.id()).collect::<Vec<usize>>(), vec![1, 3, 5, 2, 4]);
}
