use luka::{Graph, algorithms};

#[test]
fn test_kruskal() {
    let mut graph = Graph::new(20);

    graph.add_edge(1, 2, 7.0).unwrap();
    graph.add_edge(2, 1, 7.0).unwrap();
    graph.add_edge(1, 4, 5.0).unwrap();
    graph.add_edge(4, 1, 5.0).unwrap();
    graph.add_edge(2, 3, 8.0).unwrap();
    graph.add_edge(3, 2, 8.0).unwrap();
    graph.add_edge(2, 5, 7.0).unwrap();
    graph.add_edge(5, 2, 7.0).unwrap();
    graph.add_edge(2, 4, 9.0).unwrap();
    graph.add_edge(4, 2, 9.0).unwrap();
    graph.add_edge(3, 5, 5.0).unwrap();
    graph.add_edge(5, 3, 5.0).unwrap();
    graph.add_edge(5, 7, 9.0).unwrap();
    graph.add_edge(7, 5, 9.0).unwrap();
    graph.add_edge(5, 6, 8.0).unwrap();
    graph.add_edge(6, 5, 8.0).unwrap();
    graph.add_edge(5, 4, 15.0).unwrap();
    graph.add_edge(4, 5, 15.0).unwrap();
    graph.add_edge(6, 7, 11.0).unwrap();
    graph.add_edge(7, 6, 11.0).unwrap();
    graph.add_edge(6, 4, 6.0).unwrap();
    graph.add_edge(4, 6, 6.0).unwrap();

    let edges = algorithms::kruskal(&graph).unwrap();

    let summary_weight: f64 = edges.iter().map(|value| value.weight).sum();
    assert_eq!(39.0, summary_weight);
    let res = edges.iter().map(|value| (value.from.id(), value.to.id())).collect::<Vec<(usize, usize)>>();
    assert_eq!(res, vec![(1, 4), (5, 3), (4, 6), (2, 1), (5, 2), (7, 5)]);
}