use luka::{utils, Graph};
use luka::algorithms;

#[test]
fn integration_test_dijkstra(){
    let mut graph = Graph::new(10);

    graph.add_edge(1, 2, 2.0).unwrap();
    graph.add_edge(2, 3, 5.0).unwrap();
    graph.add_edge(3, 5, 7.0).unwrap();
    graph.add_edge(1, 5, 19.0).unwrap();

    let start = graph.get_vertex(1).unwrap();
    let (parents, distances) = algorithms::dijkstra(&graph, &start).unwrap();

    let target = graph.get_vertex(5).unwrap();
    let path = utils::find_path(&graph, &target, &parents).unwrap().unwrap();
    assert_eq!(path.iter().map(|vertex|vertex.id()).collect::<Vec<usize>>(), vec![1, 2, 3, 5]);
    let target = graph.get_vertex(3).unwrap();
    let path = utils::find_path(&graph, &target, &parents).unwrap().unwrap();
    assert_eq!(path.iter().map(|vertex|vertex.id()).collect::<Vec<usize>>(), vec![1, 2, 3]);

    assert_eq!(distances.get_distance(graph.get_vertex(5).unwrap()).unwrap(), 14.0);
    assert_eq!(distances.get_distance(graph.get_vertex(7).unwrap()), None);
}