use luka::algorithms::{find_connected_components, find_strongly_connected_components_search};
use luka::Graph;

#[test]
fn integration_test_find_connected_components(){
    let mut graph = Graph::new(11);

    graph.add_edge(1, 2, 0.0).unwrap();
    graph.add_edge(2, 3, 0.0).unwrap();
    graph.add_edge(3, 4, 0.0).unwrap();

    graph.add_edge(5, 6, 0.0).unwrap();
    graph.add_edge(6, 7, 0.0).unwrap();

    graph.add_edge(8, 9, 0.0).unwrap();
    graph.add_edge(9, 10, 0.0).unwrap();
    graph.add_edge(10, 11, 0.0).unwrap();

    let components = find_connected_components(&graph).unwrap();
    assert_eq!(components[0].iter().map(|elem| elem.id()).collect::<Vec<usize>>(), [1, 2, 3, 4]);
    assert_eq!(components[1].iter().map(|elem| elem.id()).collect::<Vec<usize>>(), [5, 6, 7]);
    assert_eq!(components[2].iter().map(|elem| elem.id()).collect::<Vec<usize>>(), [8, 9, 10, 11]);
    assert_eq!(components.len(), 3);

    let graph = Graph::<i32>::new(100);
    let components = find_connected_components(&graph).unwrap();
    assert_eq!(components.len(), 100);
}

#[cfg(test)]
#[test]
fn integration_test_find_strongly_connected_components() {
    let mut graph = Graph::new(8);

    graph.add_edge(1, 2, 0.0).unwrap();
    graph.add_edge(2, 6, 0.0).unwrap();
    graph.add_edge(5, 1, 0.0).unwrap();
    graph.add_edge(2, 5, 0.0).unwrap();
    graph.add_edge(5, 6, 0.0).unwrap();

    graph.add_edge(2, 3, 0.0).unwrap();
    graph.add_edge(6, 7, 0.0).unwrap();
    graph.add_edge(7, 6, 0.0).unwrap();
    graph.add_edge(3, 7, 0.0).unwrap();

    graph.add_edge(3, 4, 0.0).unwrap();
    graph.add_edge(4, 3, 0.0).unwrap();
    graph.add_edge(4, 8, 0.0).unwrap();
    graph.add_edge(8, 4, 0.0).unwrap();
    graph.add_edge(8, 7, 0.0).unwrap();

    let components = find_strongly_connected_components_search(&graph).unwrap();
    assert_eq!(components[0].iter().map(|vertex| vertex.id()).collect::<Vec<usize>>(), [6, 7]);
    assert_eq!(components[1].iter().map(|vertex| vertex.id()).collect::<Vec<usize>>(), [3, 4, 8]);
    assert_eq!(components[2].iter().map(|vertex| vertex.id()).collect::<Vec<usize>>(), [1, 2, 5]);
}