pub struct Stack<T> {
    stack: Vec<T>,
}

impl<T> Stack<T> {
    pub fn new() -> Self {
        Stack { stack: Vec::new() }
    }

    #[allow(unused)]
    pub fn len(&self) -> usize {
        self.stack.len()
    }

    pub fn pop(&mut self) -> Option<T> {
        self.stack.pop()
    }

    pub fn push(&mut self, item: T) {
        self.stack.push(item)
    }

    #[allow(unused)]
    pub fn is_empty(&self) -> bool {
        self.stack.is_empty()
    }

    #[allow(unused)]
    pub fn peek(&self) -> Option<&T> {
        self.stack.last()
    }
}

impl<T> Default for Stack<T> {
    fn default() -> Self {
        Self::new()
    }
}

#[cfg(test)]
#[test]
fn test_stack(){
    let mut st = Stack::new();
    st.push(1);
    st.push(2);
    st.push(3);
    assert_eq!(st.pop().unwrap(), 3);
    assert_eq!(st.pop().unwrap(), 2);
    assert_eq!(st.pop().unwrap(), 1);
    assert_eq!(st.pop(), None);
    assert_eq!(st.pop(), None);
}