# NEXT-VERSION

# v0.6.1
- Hotfix for the parser:
  fixed a panic (attempt to subtract with overflow) for the parsing error line and column numbers reconstruction.
  this panic most likely only occurred on empty `.twig` files.

# v0.6.0
- [Feature #5](https://github.com/MalteJanz/ludtwig/issues/5):
  Implemented layered configuration via environment variables or `.toml` files.
  The default configuration file can be generated on the fly with the `-C` flag and
  contains documentation for each config key. There is also a `-c` option to specify the path
  to a configuration file that should be used / generated by ludtwig
  (that is only necessary if it isn't in the current working directory).
  The default values behave the same as before this update.
- [Removed #38](https://github.com/MalteJanz/ludtwig/issues/38):
  All async code has been removed which makes the code base easier to read and to maintain.
  Ludtwig will still utilize all the processor cores that are available with a thread pool.
  This change comes with a massive performance improvement (around 2x on my machine) and slightly
  decreases the size of the compiled release binary.
- [Feature #33](https://github.com/MalteJanz/ludtwig/issues/33):
  The first iteration of attribute reordering is implemented together with it's own configuration.
  The default ordering configuration is not final yet.
  Also, any tags which contain twig syntax skip reordering their attributes for now.
  This feature also discards part of the previously mentioned performance improvement.
  Documentation for this can be found in the default config.
  Feel free to play with this feature and provide feedback.
- [Parser Bugfix #2](https://github.com/MalteJanz/ludtwig-parser/issues/2):
  Line and column numbers for the human-readable errors should now be correct regardless of the line ending.
  They now also work correctly with utf-8 files.

# v0.5.1
- [Bugfix #29](https://github.com/MalteJanz/ludtwig/issues/29):
  Allow `.` or `./` (current working directory paths) as input.
- [Bugfix #30](https://github.com/MalteJanz/ludtwig/issues/30):
  Fix ludtwig formatted files line endings to use CRLF on windows and LF on linux and macOS.
- [Kown Issue](https://github.com/MalteJanz/ludtwig-parser/issues/2) :
  The parser does not report the correct line number on windows (CRLF line endings) for parsing errors.

# v0.5.0
- [Bugfix / Breaking change #27](https://github.com/MalteJanz/ludtwig/issues/27):
  Twig block nesting was causing missing empty lines around twig blocks in some cases.

# v0.4.0
- An Update of [ludtwig-parser (see changelog)](https://github.com/MalteJanz/ludtwig-parser/releases/tag/v0.3.0)
  and the use of iterators for the analyzing has improved the performance of ludtwig itself by around 20%.
- The analyzer for duplicate twig block names now also checks blocks that are inside html tag attributes.
- Code cleanup and refactoring

# v0.3.0
- Performance increase of around 91% (almost doubled) in some cases.
  This was made possible by switching the async runtime from tokio to async-std and doing
  some optimizations of the directory traversal (which was blocking code).
- \[BREAKING\] Improved directory traversal by skipping hidden directories and files

# v0.2.1
- Bump version for crates.io release.
- Extracted parser code into it's own repository and public crate.

# v0.2.0
- [FEATURE #4](https://github.com/MalteJanz/ludtwig/issues/4):
  Implemented twig syntax support for `if` / `elseif` / `else` / `for` / `apply` / `set` (without `=`) blocks.
  Also any other non hierarchical twig statement `{% ... %}` will now be parsed (but not validated)
- [FEATURE #16](https://github.com/MalteJanz/ludtwig/issues/16):
  Implemented support for twig comments and structures like `if` / `block` / ... in the attributes of an html tag.
  Tag attributes are only a subset of the AST structure and their children only can contain other Tag attributes (for example no html tag as an html attribute is possible).
- [FEATURE #19](https://github.com/MalteJanz/ludtwig/issues/19):
  Enabled parsing support for output expressions as html tag attribute names and allow any twig structure or output expression inside attribute values.
  This also allows nested quotes `"` that are inside twig syntax inside of a value like  
  `alt="{{ "something.other"|trans|striptags }}"`
- [REMOVED #21](https://github.com/MalteJanz/ludtwig/issues/21)
  Removed example analyzer that has checked that twig block names contain their parent block name.
  The reasoning behind this is that it looks not very useful in practice and clutters the output with warnings.
- [FEATURE]
  Added new analyzer that checks for duplicate twig block names.
- \[BUGFIX\]: 
  Improved readability for parsing errors by displaying the error and its context in a way that is readable by the user.
  For example missing closing tags will give the context with each attribute to identify the right tag.
  The attributes were not displayed in a user readable way before this change.
  