---
layout: single
title:  "Luau Recap: May 2021"
---

Luau is our new language that you can read more about at [https://roblox.github.io/luau](https://roblox.github.io/luau). This month we have added a new small feature to the language and spent a lot of time improving our typechecker.

[Cross-posted to the [Roblox Developer Forum](https://devforum.roblox.com/t/luau-recap-may-2021/).]

## Named function type arguments

We've updated Luau syntax to support optional names of arguments inside function types.
The syntax follows the same format as regular function argument declarations: `(a: number, b: string)`

Names can be provided in any place where function type is used, for example:

* in type aliases:
```
type MyCallbackType = (cost: number, name: string) -> string
```

* for variables:
```
local cb: (amount: number) -> number
local function foo(cb: (name: string) -> ())
```

Variadic arguments cannot have an extra name, they are already written as ...: number.

These names are used for documentation purposes and we also plan to display them in Roblox Studio auto-complete and type hovers.
They do not affect how the typechecking of Luau scripts is performed.

## Typechecking improvements

Speaking of typechecking, we've implemented many improvements this month:
* Typechecker will now visit bodies of all member functions, previously it didn't check methods if the self type was unknown
* Made improvements to cyclic module import detection and error reporting
* Fixed incorrect error on modification of table intersection type fields
* When using an 'or' between a nillable type and a value, the resulting type is now inferred to be non-nil
* We have improved error messages that suggest to use ':' for a method call
* Fixed order of types in type mismatch error that was sometimes reversed
* Fixed an issue with `table.insert` function signature
* Fixed a bug which caused spurious unknown global errors

We've also added new checks to our linter:
* A new check will report uses of deprecated Roblox APIs
* Linter will now suggest replacing globals with locals in more cases
* New warning is generated if array loop starts or ends on index '0', but the array is indexed from '1'
* FormatString lint will now check string patterns for `find`/`match` calls via `:` when object type is known to be a string

We also fixed one of the sources for "Free types leaked into this module's public interface" error message and we are working to fix the remaining ones.

As usual, typechecking improvements will not break execution of your games even if new errors get reported.

## Editor features

We continue to improve our built-in support for auto-complete that will be used in future Roblox Studio updates and will make it easier to implement custom extensions for applications that support Language Server Protocol.

As part of this work we will improve the type information provided by Roblox APIs to match actual arguments and results.

## Behavior changes

When a relational comparison fails at runtime, the error message now specifies the comparison direction (e.g. `attempt to compare nil <= number`)

## Performance improvements

* Improved performance of table lookup with an index operator and a literal string: `t["name"]`
* Bytecode compilation is now ~5% faster which can improve server startup time for games with lots of scripts
