extern crate td_rlua;

#[allow(improper_ctypes)]
extern "C" {
    pub fn luaopen_socket_core(L : *mut td_rlua::lua_State);
}

/// custom lua load func
extern "C" fn load_func(lua: *mut td_rlua::lua_State) -> libc::c_int {
    let path:String = td_rlua::LuaRead::lua_read(lua).unwrap_or(String::new());
    if &path == "socket.core" || &path == "luasocket" {
        unsafe {
            luaopen_socket_core(lua);
        }
        return 1;
    }
    return 0;
}

pub fn enable_socket_core(lua : *mut td_rlua::lua_State) {
    let mut lua = td_rlua::Lua::from_existing_state(lua, false);
    lua.add_lualoader(load_func);
}