#[macro_export]
macro_rules! test {
    ($name:ident, $input:literal, $expected:literal) => {
        #[test]
        fn $name() {
            let mut out = std::io::BufWriter::new(Vec::new());
            let mut vm = luallaby::VM::create(&mut out);
            vm.run_str($input).unwrap();

            let out = out.into_inner().unwrap();
            let out = String::from_utf8(out).unwrap();
            pretty_assertions::assert_eq!(
                out.trim().split('\n').collect::<Vec<_>>(),
                $expected.trim().split('\n').collect::<Vec<_>>()
            );
        }
    };
}

#[macro_export]
macro_rules! test_regex {
    ($name:ident, $input:literal, $expected:literal) => {
        #[test]
        fn $name() {
            let mut out = std::io::BufWriter::new(Vec::new());
            let mut vm = luallaby::VM::create(&mut out);
            vm.run_str($input).unwrap();

            let out = out.into_inner().unwrap();
            let out = String::from_utf8(out).unwrap();
            let re = regex::Regex::new($expected.trim()).unwrap();
            assert!(re.is_match(out.trim()));
        }
    };
}

#[macro_export]
macro_rules! test_err {
    ($name:ident, $input:literal, $err:pat) => {
        #[test]
        fn $name() {
            let mut out = std::io::BufWriter::new(Vec::new());
            let mut vm = luallaby::VM::create(&mut out);
            let res = vm.run_str($input);

            match res {
                Ok(..) => assert!(false, "expected error"),
                Err(e) => match e {
                    luallaby::Error::Lua { typ, .. } => assert!(matches!(typ, $err)),
                    _ => assert!(false, "expected parse error"),
                },
            }
        }
    };
}

// TODO: Get rid of this in favor of test_err!
#[macro_export]
macro_rules! test_panic {
    ($name:ident, $input:literal) => {
        #[should_panic]
        #[test]
        fn $name() {
            let mut out = std::io::BufWriter::new(Vec::new());
            let mut vm = luallaby::VM::create(&mut out);
            vm.run_str($input).unwrap();
        }
    };
}
