mod macros;

test!(
    basic_assert_pass,
    "
print(assert(0, \"failed\"))
",
    "
0 failed
"
);

test_panic!(basic_assert_fail, "assert(nil, \"hehe\")");

test!(
    basic_load,
    "
f = load(\"a = 'Hello world!'; print(a, a)\")
f()
",
    "
Hello world! Hello world!
"
);

test!(
    basic_pcall,
    "
function f()
    print(\"Hello world!\")
    error()
    print(\"Don't come here\")
end
pcall(f)
",
    "
Hello world!
"
);

test!(
    basic_pcall_pass,
    "
function f()
    print('Hello world!')
end
function g()
    return 5
end
pcall(f)
p, r = pcall(g)
print(r + 4)
pcall(print)
",
    "
Hello world!
9
"
);

test!(
    basic_pcall_filled_stack,
    "
function f()
    local a, b, c = 4, 5, error()
end
a, b, c = 1, pcall(f), 2
print(a, b, c)
",
    "
1 false 2
"
);

test!(
    basic_select,
    "
print(select(1, 1, 2, 3, 4))
print(select('-2', 1, 2, 3, 4))
print(select('2.0', 1, 2, 3, 4))
print(select('-2.0', 1, 2, 3, 4))
print(select(5, 1, 2, 3, 4))
print(select('#', 1, 2, 3, 4))
",
    "
1 2 3 4
3 4
2 3 4
3 4

4
"
);

test_panic!(basic_select_fail_1, "select(4.1, 1, 2, 3, 4)");
test_panic!(basic_select_fail_2, "select(0, 1, 2, 3, 4)");
test_panic!(basic_select_fail_3, "select(-5, 1, 2, 3, 4)");

test!(
    basic_tonumber,
    "
print(tonumber('4', 3))
print(tonumber('10', 16))
print(tonumber('10.2', 16))
print(tonumber('10.2'))
print(tonumber('0x10.2'))
print(tonumber('0x10'))
print(tonumber(' 10 '))
",
    "
nil
16
nil
10.2
16.125
16
10
"
);

test_panic!(basic_tonumber_fail_1, "print(tonumber(4, 3))");
test_panic!(basic_tonumber_fail_2, "print(tonumber('4', '3F'))");

test_regex!(
    basic_tostring,
    "
a = nil
b = true
c = 0.1
d = \"a\"
e = {}
function f()
end
print(a)
print(b)
print(c)
print(d)
print(e)
print(f)
",
    r"
nil
true
0.1
a
table: 0x([a-fA-F0-9])+
function: 0x([a-fA-F0-9])+
"
);
