use std::fs::File;
use std::io::Read;

use clap::{App, Arg};

use luallaby::VM;

fn main() {
    let matches = App::new(env!("CARGO_PKG_NAME"))
        .version(env!("CARGO_PKG_VERSION"))
        .author(env!("CARGO_PKG_AUTHORS"))
        .about("A pure Rust Lua compiler/interpreter")
        .arg(
            Arg::with_name("FILE")
                .help("Path to the Lua script to run")
                .required(true)
                .index(1),
        )
        .get_matches();

    let mut input = String::new();
    let mut file = File::open(matches.value_of("FILE").unwrap()).unwrap();
    file.read_to_string(&mut input).unwrap();

    let mut out = std::io::stdout();
    let mut vm = VM::create(&mut out);

    if let Err(e) = vm.run_str(&input) {
        println!("{}: {}", env!("CARGO_PKG_NAME"), e);
        std::process::exit(1);
    }
}
