use crate::ast::While;
use crate::compiler::{offset, Compiler, ScopeType};
use crate::vm::OpCode;

impl<'a> Compiler<'a> {
    pub(super) fn compile_while(&mut self, r#while: While) {
        self.scope_enter(ScopeType::Loop);

        // Start
        let start = self.code.pos();
        let cmp_reg = self.compile_exp(*r#while.cond);

        // Jump to end if condition is false, placeholder
        let jump_end = self.code.pos();
        self.code.emit(OpCode::Jump { off: 0 }); // Placeholder

        self.compile_block(*r#while.block);

        // Jump to start
        let off = offset(self.code.pos(), start);
        self.code.emit(OpCode::Jump { off });

        // Fill in jump to end
        let off = offset(jump_end, self.code.pos());
        self.code.set(jump_end, OpCode::JumpIfNot { cmp_reg, off }); // In position where jump inserted, cmp_reg is valid

        self.scopes.reg_free(cmp_reg);
        self.scope_leave(ScopeType::Loop);
    }
}
