use crate::ast::Repeat;
use crate::compiler::{offset, Compiler, ScopeType};
use crate::vm::OpCode;

impl<'a> Compiler<'a> {
    pub(super) fn compile_repeat(&mut self, repeat: Repeat) {
        self.scope_enter(ScopeType::Loop);

        // Start
        let start = self.code.pos();

        // Block
        self.compile_block(*repeat.block);

        // Condition
        let cmp_reg = self.compile_exp(*repeat.cond);

        // Jump to start if condition false
        let off = offset(self.code.pos(), start);
        self.code.emit(OpCode::JumpIfNot { cmp_reg, off });

        self.scopes.reg_free(cmp_reg);
        self.scope_leave(ScopeType::Loop);
    }
}
