use crate::ast::Block;
use crate::compiler::Compiler;
use crate::vm::{OpCode, Value};

impl<'a> Compiler<'a> {
    pub(super) fn compile_block(&mut self, block: Block) -> bool {
        for stat in block.stats {
            self.compile_stat(stat);
        }

        if let Some(exps) = block.ret {
            let ret_reg = self.scopes.reg_reserve();
            self.code.emit(OpCode::Lit {
                val: Value::empty(),
                dst_reg: ret_reg,
            });
            for exp in exps.into_iter() {
                let exp_reg = self.compile_exp(exp);
                self.code.emit(OpCode::Single { reg: exp_reg });
                self.code.emit(OpCode::Append {
                    src_reg: exp_reg,
                    dst_reg: ret_reg,
                });
                self.scopes.reg_free(exp_reg);
            }
            self.code.emit(OpCode::Return { ret_reg });
            self.scopes.reg_free(ret_reg);
            true
        } else {
            false
        }
    }
}
