use crate::ast::{Block, Exp, Parser};
use crate::error::Result;
use crate::token::Token;

/// ```test
/// stat ::= while exp do block end
/// ```
pub struct While {
    pub cond: Box<Exp>,
    pub block: Box<Block>,
}

impl<'a> Parser<'a> {
    pub(super) fn parse_while(&mut self) -> Result<While> {
        expect_token!(self.tokens.next(), Token::While);

        let cond = Box::new(self.parse_exp()?);

        expect_token!(self.tokens.next(), Token::Do);
        let block = Box::new(self.parse_block()?);
        expect_token!(self.tokens.next(), Token::End);

        Ok(While { cond, block })
    }
}
