# luallaby

![Crates.io](https://img.shields.io/crates/v/luallaby)
![docs.rs](https://img.shields.io/docsrs/luallaby)
![Crates.io](https://img.shields.io/crates/l/luallaby)

**This project is a work in progress. Please do not use this (yet) if you need a fully featured and/or compliant Lua interpreter.**

A Lua compiler and interpreter fully written in Rust.
This project aims to provide a fully compliant Lua implementation including interoperability between Lua and Rust.

## Things to do and implement

A list of features to be implemented, in somewhat particular order:

- [x] (Almost) full language syntax support
- [ ] Proper error handling with trace+context (not panicking on every problem)
- [ ] Rust-Lua interoperability
- [ ] Standard libraries
    - [ ] Basic library
    - [ ] Coroutine library
    - [ ] Package library
    - [ ] String manipulation
    - [ ] Basic UTF-8 support
    - [ ] Table manipulation
    - [x] Mathematical functions
    - [ ] Input and output
    - [ ] Operating system facilities
    - [ ] Debug facilities
- [ ] Garbage collector
- [ ] Passing the Lua test suite
- [ ] Benchmarks vs the C implementation
- [ ] REPL

## Testing

This crate has its own test suite that can be executed with `cargo test`.
A copy of the Lua test suite has also been included in this repository.
These tests can be run by running them as regular Lua files `cargo run -- <file>.lua`, the test is considered passed if the output ends with "OK" and the interpreter has returned without error.

## Usage

TODO:

## License

`luallaby` is distributed under the terms of the MIT license.

See the [LICENSE](LICENSE) file for more information.
