#[macro_use]
mod macros;

test!(
    table_list,
    "
t = { 3, 4, 5, 6 }
print(t[1], t[2], t[3], t[4])
",
    "
3 4 5 6
"
);

test!(
    table_separator,
    "
t = { 3; 4, 5 }
print(t[1], t[2], t[3])
",
    "
3 4 5
"
);

test!(
    table_associative,
    "
t = { [false] = 3, [3] = 4, [\"f\"] = 5, g = 6 }
print(t[false], t[3], t.f, t[\"f\"], t.g)
",
    "
3 4 5 5 6
"
);

test!(
    table_mixed,
    "
t = { 3, [false] = 4, 5, f = 6 }
print(t[1], t[false], t[2], t.f)
",
    "
3 4 5 6
"
);

test!(
    table_assign,
    "
t = { 3, [false] = 4, 5, f = 6 }
print(t[1], t[false], t[2], t.f)
t.f = 5
t[false] = \"a\"
print(t[1], t[false], t[2], t.f)
",
    "
3 4 5 6
3 a 5 5
"
);

test!(
    table_ref,
    "
a = {}
b = a
a.t = 1
print(a.t, b.t)
",
    "
1 1
"
);

// TODO: Nil and NaN not allowed as table keys
