mod macros;

test!(
    hello_world,
    "
print(\"Hello world!\")
",
    "
Hello world!
"
);

test!(
    assignment,
    "
a = \"Hello world!\"
b = a
print(b)
",
    "
Hello world!
"
);

test!(
    assignment_multiple,
    "
x, y = 1, 2
print(x, y)
x, y = y, x
print(x, y)
",
    "
1 2
2 1
"
);

test!(
    assignment_multiple_table,
    "
a = {}
i = 3
i, a[i] = i+1, 20
print(i, a[3], a[4])

a = {k = 1}
b = a
a, a[1] = {}, 2
print(a[1], a.k, b[1], b.k)
",
    "
4 20 nil
nil nil 2 1
"
);

test!(
    undefined_var,
    "
print(a)
",
    "
nil
"
);

test_regex!(
    value_to_string,
    "
a = nil
b = true
c = 0.1
d = \"a\"
e = {}
function f()
end
print(a)
print(b)
print(c)
print(d)
print(e)
print(f)
",
    r"
nil
true
0.1
a
table: 0x([a-fA-F0-9])+
function: 0x([a-fA-F0-9])+
"
);

test_panic!(
    local_const,
    "
local a <const> = 5
a = 6
"
);

test!(
    lexer_numbers,
    "
print(0)
print(0.1)
print(.1)
print(2e-2)
print(2E2)
print(2e+2)
print(0xfp2)
print(0x1.4p3)
",
    "
0
0.1
0.1
0.02
200
200
60
10
"
);

// TODO: Variable assignment (+local), value matching/overflow
