use crate::vm::{BinOp, UnOp, Value, VarType};

#[derive(Clone, Copy, Debug)]
pub struct HeapID(usize);

// TODO: Check if stack order of op parameters makes sense (SetTbl especially)
#[derive(Clone, Debug)]
pub enum OpCode {
    // Stack stuff
    PushEnv,
    PushLit(Value),
    PushLocal(usize),
    PushLocalMult(usize, usize),
    PushVarargs,
    PopDisc,
    PopLocal(usize),
    Copy,
    // Operations
    BinOp(BinOp),
    UnOp(UnOp),
    Single,
    Combine(usize),
    GetTbl,          // index, table -> val
    SetTbl,          // table, index, val
    BuildTbl(usize), // (index, val)*usize
    Closure,         // func,
    // Jumps (relative)
    Jump(i64),
    JumpIf(i64),
    JumpIfNot(i64),
    Goto(usize, i64),
    // Call stack
    ScopeEnter(Vec<VarType>),
    ScopeLeave,
    Call(usize), // func, (arg)*usize
    Return,
}
