pub type Result<T> = std::result::Result<T, Error>;

#[derive(Debug)]
pub enum Error {
    IO(std::io::Error),
    Parse(ErrorType),
}

#[derive(Debug)]
pub enum ErrorType {}

impl From<std::io::Error> for Error {
    fn from(from: std::io::Error) -> Self {
        Self::IO(from)
    }
}
