use crate::ast::While;
use crate::compiler::{offset, Compiler, ScopeType};
use crate::vm::OpCode;

impl Compiler {
    pub(super) fn compile_while(&mut self, r#while: While) {
        self.scope_enter(ScopeType::Loop);

        // Start
        let start = self.pos();
        self.compile_exp(*r#while.cond);

        // Jump to end if condition is false, placeholder
        let jump_end = self.pos();
        self.emit(OpCode::Jump(0)); // Placeholder

        self.compile_block(*r#while.block);

        // Jump to start
        let off = offset(self.pos(), start);
        self.emit(OpCode::Jump(off));

        // Fill in jump to end
        let off = offset(jump_end, self.pos());
        self.set(jump_end, OpCode::JumpIfNot(off));

        self.scope_leave();
    }
}
