use crate::ast::Repeat;
use crate::compiler::{offset, Compiler, ScopeType};
use crate::vm::OpCode;

impl Compiler {
    pub(super) fn compile_repeat(&mut self, repeat: Repeat) {
        self.scope_enter(ScopeType::Loop);

        // Start
        let start = self.pos();

        // Block
        self.compile_block(*repeat.block);

        // Condition
        self.compile_exp(*repeat.cond);

        // Jump to start if condition false
        let off = offset(self.pos(), start);
        self.emit(OpCode::JumpIfNot(off));

        self.scope_leave();
    }
}
