use crate::ast::PrefixExp;
use crate::compiler::Compiler;
use crate::vm::{OpCode, Value};

impl Compiler {
    pub(super) fn compile_prefix_exp(&mut self, exp: PrefixExp) {
        match exp {
            PrefixExp::Call(prefix, args) => {
                self.compile_call(*prefix, args);
            }
            PrefixExp::CallMethod(prefix, name, args) => {
                self.compile_call_method(*prefix, name, args);
            }
            PrefixExp::Index(prefix, exp) => {
                self.compile_prefix_exp(*prefix);
                self.compile_exp(*exp);
                self.emit(OpCode::GetTbl);
            }
            PrefixExp::Par(exp) => {
                self.compile_exp(*exp);
                self.emit(OpCode::Single);
            }
            PrefixExp::Var(name) => match self.scopes.get(&name) {
                Some((dst, _)) => self.emit(OpCode::PushLocal(dst)),
                None => {
                    self.emit(OpCode::PushEnv);
                    self.emit(OpCode::PushLit(Value::String(name)));
                    self.emit(OpCode::GetTbl);
                }
            },
        }
    }
}
